/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.base;

import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.trippi.TripleIterator;
import org.trippi.TriplePattern;
import org.trippi.TriplestoreReader;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;
import org.trippi.impl.base.AliasManager;
import org.trippi.impl.base.DistinctTripleIterator;
import org.trippi.impl.base.DistinctTupleIterator;
import org.trippi.impl.base.LimitedTripleIterator;
import org.trippi.impl.base.LimitedTupleIterator;
import org.trippi.impl.base.PoolAwareTripleIterator;
import org.trippi.impl.base.PoolAwareTupleIterator;
import org.trippi.impl.base.TriplestoreSession;
import org.trippi.impl.base.TriplestoreSessionPool;
import org.trippi.impl.base.TupleBasedTripleIterator;

public class ConcurrentTriplestoreReader
implements TriplestoreReader {
    private static final Logger logger = Logger.getLogger((String)ConcurrentTriplestoreReader.class.getName());
    private TriplestoreSessionPool m_pool;
    private AliasManager m_aliasManager;

    public ConcurrentTriplestoreReader(TriplestoreSessionPool pool, AliasManager aliasManager) {
        this.m_pool = pool;
        this.m_aliasManager = aliasManager;
    }

    public Map getAliasMap() {
        return this.m_aliasManager.getAliasMap();
    }

    public void setAliasMap(Map aliasMap) {
        this.m_aliasManager.setAliasMap(aliasMap);
    }

    public String[] listTupleLanguages() {
        return this.m_pool.listTupleLanguages();
    }

    public String[] listTripleLanguages() {
        return this.m_pool.listTripleLanguages();
    }

    public int countTuples(String queryLang, String tupleQuery, int limit, boolean distinct) throws TrippiException {
        return this.findTuples(queryLang, tupleQuery, limit, distinct).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleIterator findTuples(String queryLang, String tupleQuery, int limit, boolean distinct) throws TrippiException {
        TriplestoreSession session = this.m_pool.get();
        if (session == null) {
            throw new TrippiException("Maximum triplestore connections exceeded.");
        }
        TupleIterator iter = null;
        boolean failed = true;
        try {
            iter = session.query(tupleQuery, queryLang);
            if (distinct) {
                iter = new DistinctTupleIterator(iter);
            }
            if (limit > 0) {
                iter = new LimitedTupleIterator(iter, limit);
            }
            iter = new PoolAwareTupleIterator(iter, session, this.m_pool);
            failed = false;
            TupleIterator tupleIterator = iter;
            return tupleIterator;
        }
        finally {
            if (failed) {
                this.m_pool.release(session);
            }
        }
    }

    private String doAliasReplacements(String q) {
        String out = q;
        Map m = this.m_aliasManager.getAliasMap();
        Iterator iter = m.keySet().iterator();
        while (iter.hasNext()) {
            String alias = (String)iter.next();
            String fullForm = (String)m.get(alias);
            out = out.replaceAll("<" + alias + ":", "<" + fullForm).replaceAll("\\^\\^" + alias + ":(\\S+)", "^^<" + fullForm + "$1>");
        }
        if (!q.equals(out)) {
            logger.info((Object)("Substituted aliases, query is now: " + out));
        }
        return out;
    }

    public int countTriples(String queryLang, String tripleQuery, int limit, boolean distinct) throws TrippiException {
        return this.findTriples(queryLang, tripleQuery, limit, distinct).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TripleIterator findTriples(String queryLang, String tripleQuery, int limit, boolean distinct) throws TrippiException {
        if (queryLang.equals("spo")) {
            TriplePattern[] patterns = TriplePattern.parse(this.doAliasReplacements(tripleQuery));
            if (patterns.length == 1) {
                TriplePattern p = patterns[0];
                SubjectNode subject = null;
                PredicateNode predicate = null;
                ObjectNode object = null;
                if (p.getSubject() instanceof SubjectNode) {
                    subject = (SubjectNode)p.getSubject();
                }
                if (p.getPredicate() instanceof PredicateNode) {
                    predicate = (PredicateNode)p.getPredicate();
                }
                if (p.getObject() instanceof ObjectNode) {
                    object = (ObjectNode)p.getObject();
                }
                return this.findTriples(subject, predicate, object, limit);
            }
            throw new TrippiException("Only one triple pattern may be specified.");
        }
        TriplestoreSession session = this.m_pool.get();
        if (session == null) {
            throw new TrippiException("Maximum triplestore connections exceeded.");
        }
        TripleIterator iter = null;
        boolean failed = true;
        try {
            iter = session.findTriples(queryLang, tripleQuery);
            if (distinct) {
                iter = new DistinctTripleIterator(iter);
            }
            if (limit > 0) {
                iter = new LimitedTripleIterator(iter, limit);
            }
            iter = new PoolAwareTripleIterator(iter, session, this.m_pool);
            failed = false;
            TripleIterator tripleIterator = iter;
            return tripleIterator;
        }
        finally {
            if (failed) {
                this.m_pool.release(session);
            }
        }
    }

    public int countTriples(SubjectNode subject, PredicateNode predicate, ObjectNode object, int limit) throws TrippiException {
        return this.findTriples(subject, predicate, object, limit).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TripleIterator findTriples(SubjectNode subject, PredicateNode predicate, ObjectNode object, int limit) throws TrippiException {
        TriplestoreSession session = this.m_pool.get();
        if (session == null) {
            throw new TrippiException("Maximum triplestore connections exceeded.");
        }
        TripleIterator iter = null;
        boolean failed = true;
        try {
            iter = session.findTriples(subject, predicate, object);
            if (limit > 0) {
                iter = new LimitedTripleIterator(iter, limit);
            }
            iter = new PoolAwareTripleIterator(iter, session, this.m_pool);
            failed = false;
            TripleIterator tripleIterator = iter;
            return tripleIterator;
        }
        finally {
            if (failed) {
                this.m_pool.release(session);
            }
        }
    }

    public int countTriples(String queryLang, String tupleQuery, String tripleTemplate, int limit, boolean distinct) throws TrippiException {
        return this.findTriples(queryLang, tupleQuery, tripleTemplate, limit, distinct).count();
    }

    public TripleIterator findTriples(String queryLang, String tupleQuery, String tripleTemplate, int limit, boolean distinct) throws TrippiException {
        TriplePattern[] patterns = TriplePattern.parse(tripleTemplate);
        TripleIterator iter = new TupleBasedTripleIterator(this.findTuples(queryLang, tupleQuery, -1, distinct), patterns);
        if (distinct) {
            iter = new DistinctTripleIterator(iter);
        }
        if (limit > 0) {
            iter = new LimitedTripleIterator(iter, limit);
        }
        return iter;
    }

    public void close() throws TrippiException {
        logger.info((Object)"ConcurrentTripleStoreReader closing TripleStoreSessionPool...");
        this.m_pool.close();
    }

    public void finalize() throws TrippiException {
        this.close();
    }
}

