/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.trippi.TrippiException;
import org.trippi.impl.base.TriplestoreSession;
import org.trippi.impl.base.TriplestoreSessionFactory;
import org.trippi.impl.base.TriplestoreSessionPool;

public class ConfigurableSessionPool
extends Thread
implements TriplestoreSessionPool {
    private static final Logger logger = Logger.getLogger((String)ConfigurableSessionPool.class.getName());
    private TriplestoreSessionFactory m_factory;
    private int m_initialSize;
    private int m_maxGrowth;
    private int m_spareSessions;
    private int m_maxSize;
    private int m_size;
    private List m_inUseSessions;
    private List m_freeSessions;
    private boolean m_needToFinish = false;

    public ConfigurableSessionPool(TriplestoreSessionFactory factory, int initialSize, int maxGrowth, int spareSessions) throws TrippiException {
        this.m_factory = factory;
        this.m_initialSize = initialSize;
        this.m_maxGrowth = maxGrowth;
        this.m_spareSessions = spareSessions;
        this.m_maxSize = this.m_maxGrowth == -1 ? this.m_maxGrowth : this.m_initialSize + this.m_maxGrowth;
        this.m_freeSessions = new ArrayList(initialSize);
        this.m_inUseSessions = new ArrayList(initialSize);
        this.grow(initialSize);
        if (maxGrowth != 0) {
            this.start();
        }
    }

    public String[] listTripleLanguages() {
        return this.m_factory.listTripleLanguages();
    }

    public String[] listTupleLanguages() {
        return this.m_factory.listTupleLanguages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TriplestoreSession get() throws TrippiException {
        TriplestoreSession session;
        if (this.getFreeCount() == 0) {
            if (this.m_maxSize == -1 || this.m_maxGrowth > 0 && this.m_size < this.m_maxSize) {
                this.grow(1);
            } else {
                return null;
            }
        }
        List list = this.m_freeSessions;
        synchronized (list) {
            session = (TriplestoreSession)this.m_freeSessions.remove(0);
        }
        list = this.m_inUseSessions;
        synchronized (list) {
            this.m_inUseSessions.add(session);
        }
        logger.info((Object)("Leased session: " + this.getStats()));
        return session;
    }

    private String getStats() {
        return "free = " + this.getFreeCount() + ", in-use = " + this.getInUseCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release(TriplestoreSession session) {
        boolean released = false;
        List list = this.m_inUseSessions;
        synchronized (list) {
            if (this.m_inUseSessions.remove(session)) {
                List list2 = this.m_freeSessions;
                synchronized (list2) {
                    this.m_freeSessions.add(session);
                }
                released = true;
            } else {
                System.err.println("Warning: Session not released; it didn't originate with this pool!");
            }
        }
        if (released) {
            logger.info((Object)("Got session back: " + this.getStats()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInUseCount() {
        List list = this.m_inUseSessions;
        synchronized (list) {
            return this.m_inUseSessions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFreeCount() {
        List list = this.m_freeSessions;
        synchronized (list) {
            return this.m_freeSessions.size();
        }
    }

    public void run() {
        while (!this.m_needToFinish) {
            int diff = this.m_spareSessions - this.getFreeCount();
            if (diff > 0) {
                int numToAdd = diff;
                if (this.m_maxGrowth != -1) {
                    while (numToAdd + this.m_size > this.m_maxSize) {
                        --numToAdd;
                    }
                }
                if (numToAdd > 0) {
                    try {
                        this.grow(numToAdd);
                    }
                    catch (TrippiException e) {
                        logger.warn((Object)("Error proactively growing triplestore session pool (maintenance thread): " + e.getMessage()));
                    }
                }
            }
            if (this.m_needToFinish) continue;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void closeAll(Iterator iter) {
        while (iter.hasNext()) {
            try {
                ((TriplestoreSession)iter.next()).close();
            }
            catch (Exception e) {
                System.err.println("Warning: attempt to close TriplestoreSession failed, continuing...");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grow(int numToAdd) throws TrippiException {
        ArrayList<TriplestoreSession> newSessions = new ArrayList<TriplestoreSession>();
        for (int i = 0; i < numToAdd; ++i) {
            newSessions.add(this.m_factory.newSession());
        }
        List list = this.m_freeSessions;
        synchronized (list) {
            this.m_freeSessions.addAll(newSessions);
            this.m_size += newSessions.size();
        }
    }

    public synchronized void close() throws TrippiException {
        if (!this.m_needToFinish) {
            logger.info((Object)"Closing all sessions...");
            this.closeAll(this.m_freeSessions.iterator());
            this.closeAll(this.m_inUseSessions.iterator());
            this.m_factory.close();
            this.m_needToFinish = true;
        }
    }

    public void finalize() throws TrippiException {
        this.close();
    }
}

