/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.base;

import gnu.trove.TIntHashSet;
import java.util.Map;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;

public class DistinctTupleIterator
extends TupleIterator {
    private TupleIterator m_wrapped;
    private TIntHashSet m_seen;
    private Map m_next;
    private boolean m_closed = false;

    public DistinctTupleIterator(TupleIterator wrapped) throws TrippiException {
        this.m_wrapped = wrapped;
        this.m_seen = new TIntHashSet();
        this.m_next = this.getNext();
    }

    private Map getNext() throws TrippiException {
        while (this.m_wrapped.hasNext()) {
            Map nextMap = this.m_wrapped.next();
            if (this.seen(((Object)nextMap).hashCode())) continue;
            return nextMap;
        }
        return null;
    }

    private boolean seen(int id) {
        if (this.m_seen.contains(id)) {
            return true;
        }
        this.m_seen.add(id);
        return false;
    }

    public boolean hasNext() {
        return this.m_next != null;
    }

    public Map next() throws TrippiException {
        if (this.m_next == null) {
            return null;
        }
        Map last = this.m_next;
        this.m_next = this.getNext();
        return last;
    }

    public String[] names() throws TrippiException {
        return this.m_wrapped.names();
    }

    public void close() throws TrippiException {
        if (!this.m_closed) {
            this.m_wrapped.close();
            this.m_closed = true;
        }
    }

    public void finalize() throws TrippiException {
        this.close();
    }
}

