/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.base;

import java.util.Map;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;

public class LimitedTupleIterator
extends TupleIterator {
    private TupleIterator m_wrapped;
    private int m_count;
    private int m_limit;
    private Map m_next;
    private boolean m_closed = false;

    public LimitedTupleIterator(TupleIterator wrapped, int limit) throws TrippiException {
        this.m_wrapped = wrapped;
        this.m_count = 0;
        this.m_limit = limit;
        this.m_next = this.getNext();
    }

    private Map getNext() throws TrippiException {
        if (this.m_wrapped.hasNext() && this.m_count < this.m_limit) {
            ++this.m_count;
            return this.m_wrapped.next();
        }
        return null;
    }

    public boolean hasNext() {
        return this.m_next != null;
    }

    public Map next() throws TrippiException {
        if (this.m_next == null) {
            return null;
        }
        Map last = this.m_next;
        this.m_next = this.getNext();
        return last;
    }

    public String[] names() throws TrippiException {
        return this.m_wrapped.names();
    }

    public void close() throws TrippiException {
        if (!this.m_closed) {
            this.m_wrapped.close();
            this.m_closed = true;
        }
    }

    public void finalize() throws TrippiException {
        this.close();
    }
}

