/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.base;

import org.jrdf.graph.Triple;
import org.trippi.TripleIterator;
import org.trippi.TrippiException;
import org.trippi.impl.base.SynchronizedTriplestoreSession;

public class SynchronizedTripleIterator
extends TripleIterator {
    private TripleIterator m_iter;
    private SynchronizedTriplestoreSession m_session;
    private boolean m_closed = false;

    public SynchronizedTripleIterator(TripleIterator iter, SynchronizedTriplestoreSession session) {
        this.m_iter = iter;
        this.m_session = session;
    }

    public boolean hasNext() throws TrippiException {
        boolean has = this.m_iter.hasNext();
        if (!has) {
            this.close();
        }
        return has;
    }

    public Triple next() throws TrippiException {
        return this.m_iter.next();
    }

    public void close() throws TrippiException {
        if (!this.m_closed) {
            try {
                this.m_iter.close();
            }
            catch (TrippiException e) {
                throw e;
            }
            finally {
                this.m_session.releaseLock();
                this.m_closed = true;
            }
        }
    }

    public void finalize() throws TrippiException {
        this.close();
    }
}

