/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.base;

import java.util.List;
import java.util.Map;
import org.trippi.TriplePattern;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;
import org.trippi.impl.base.SynchronizedTriplestoreSession;

public class SynchronizedTupleIterator
extends TupleIterator {
    private TupleIterator m_iter;
    private SynchronizedTriplestoreSession m_session;
    private boolean m_closed = false;

    public SynchronizedTupleIterator(TupleIterator iter, SynchronizedTriplestoreSession session) {
        this.m_iter = iter;
        this.m_session = session;
    }

    public boolean hasNext() throws TrippiException {
        boolean has = this.m_iter.hasNext();
        if (!has) {
            this.close();
        }
        return has;
    }

    public Map next() throws TrippiException {
        return this.m_iter.next();
    }

    public List nextTriples(TriplePattern[] patterns) throws TrippiException {
        return this.m_iter.nextTriples(patterns);
    }

    public String[] names() throws TrippiException {
        return this.m_iter.names();
    }

    public void close() throws TrippiException {
        if (!this.m_closed) {
            try {
                this.m_iter.close();
            }
            catch (TrippiException e) {
                throw e;
            }
            finally {
                this.m_session.releaseLock();
                this.m_closed = true;
            }
        }
    }

    public void finalize() throws TrippiException {
        this.close();
    }
}

