/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.io;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.jrdf.graph.BlankNode;
import org.jrdf.graph.Literal;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.jrdf.graph.URIReference;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RdfDocumentWriter;
import org.trippi.TripleIterator;
import org.trippi.TrippiException;
import org.trippi.io.TripleWriter;

public class RIOTripleWriter
extends TripleWriter {
    private RdfDocumentWriter m_writer;
    private ValueFactoryImpl m_rioFactory = new ValueFactoryImpl();

    public RIOTripleWriter(RdfDocumentWriter writer, Map aliases) throws TrippiException {
        try {
            this.m_writer = writer;
            Iterator iter = aliases.keySet().iterator();
            while (iter.hasNext()) {
                String prefix = (String)iter.next();
                String name = (String)aliases.get(prefix);
                this.m_writer.setNamespace(prefix, name);
            }
        }
        catch (IOException e) {
            throw new TrippiException("Error setting up RIOTripleWriter", e);
        }
    }

    public int write(TripleIterator iter) throws TrippiException {
        try {
            this.m_writer.startDocument();
            int count = 0;
            while (iter.hasNext()) {
                Triple triple = iter.next();
                this.m_writer.writeStatement(this.rioResource(triple.getSubject()), this.rioURI(triple.getPredicate()), this.rioValue(triple.getObject()));
                ++count;
            }
            this.m_writer.endDocument();
            iter.close();
            return count;
        }
        catch (IOException e) {
            throw new TrippiException("Error setting up RIOTripleWriter", e);
        }
    }

    private Resource rioResource(SubjectNode s) {
        if (s instanceof BlankNode) {
            return this.m_rioFactory.createBNode("" + s.hashCode());
        }
        return this.m_rioFactory.createURI(((URIReference)s).getURI().toString());
    }

    private URI rioURI(PredicateNode p) {
        return this.m_rioFactory.createURI(((URIReference)p).getURI().toString());
    }

    private Value rioValue(ObjectNode o) {
        if (o instanceof BlankNode) {
            return this.m_rioFactory.createBNode("" + o.hashCode());
        }
        if (o instanceof Literal) {
            Literal l = (Literal)o;
            if (l.getDatatypeURI() != null) {
                return this.m_rioFactory.createLiteral(l.getLexicalForm(), this.m_rioFactory.createURI(l.getDatatypeURI().toString()));
            }
            if (l.getLanguage() != null && !l.getLanguage().equals("")) {
                return this.m_rioFactory.createLiteral(l.getLexicalForm(), l.getLanguage());
            }
            return this.m_rioFactory.createLiteral(l.getLexicalForm());
        }
        return this.m_rioFactory.createURI(((URIReference)o).getURI().toString());
    }
}

