/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.server.http;

import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class Styler {
    private final String m_indexStyle;
    private final String m_formStyle;
    private final String m_errorStyle;
    private Templates m_indexTemplates;
    private Templates m_formTemplates;
    private Templates m_errorTemplates;
    private TransformerFactory m_factory;

    public Styler(String indexStyle, String formStyle, String errorStyle) throws Exception {
        this.m_indexStyle = indexStyle;
        this.m_formStyle = formStyle;
        this.m_errorStyle = errorStyle;
        this.m_factory = TransformerFactory.newInstance();
        this.reload();
    }

    public void sendIndex(String xml, PrintWriter out) throws Exception {
        Styler.send(xml, out, this.m_indexTemplates);
    }

    public void sendForm(String xml, PrintWriter out) throws Exception {
        Styler.send(xml, out, this.m_formTemplates);
    }

    public void sendError(String xml, PrintWriter out) throws Exception {
        Styler.send(xml, out, this.m_errorTemplates);
    }

    public synchronized void reload() throws Exception {
        if (this.m_indexStyle != null) {
            this.m_indexTemplates = this.load(this.m_indexStyle);
        }
        if (this.m_formStyle != null) {
            this.m_formTemplates = this.load(this.m_formStyle);
        }
        if (this.m_errorStyle != null) {
            this.m_errorTemplates = this.load(this.m_errorStyle);
        }
    }

    private Templates load(String filePath) throws Exception {
        return this.m_factory.newTemplates(new StreamSource(new FileInputStream(filePath)));
    }

    private static void send(String source, PrintWriter out, Templates stylesheet) throws Exception {
        stylesheet.newTransformer().transform(new StreamSource(new StringReader(source)), new StreamResult(out));
    }
}

