/*
 * Decompiled with CFR 0.152.
 */
package org.trippi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jrdf.graph.Triple;
import org.trippi.RDFFormat;
import org.trippi.TriplePattern;
import org.trippi.TrippiException;
import org.trippi.io.CSVTupleWriter;
import org.trippi.io.SimpleTupleWriter;
import org.trippi.io.SparqlTupleIterator;
import org.trippi.io.SparqlTupleWriter;
import org.trippi.io.TSVTupleWriter;
import org.trippi.io.TupleWriter;

public abstract class TupleIterator {
    public static final RDFFormat[] INPUT_FORMATS = new RDFFormat[]{RDFFormat.SPARQL};
    public static final RDFFormat[] OUTPUT_FORMATS = new RDFFormat[]{RDFFormat.CSV, RDFFormat.SIMPLE, RDFFormat.SPARQL, RDFFormat.TSV};
    private Map m_aliases = new HashMap();

    public abstract boolean hasNext() throws TrippiException;

    public abstract Map next() throws TrippiException;

    public abstract String[] names() throws TrippiException;

    public abstract void close() throws TrippiException;

    public List nextTriples(TriplePattern[] patterns) throws TrippiException {
        Map map = this.next();
        if (map == null) {
            return null;
        }
        ArrayList<Triple> triples = new ArrayList<Triple>();
        for (int i = 0; i < patterns.length; ++i) {
            Triple triple = patterns[i].match(map);
            if (triple == null) continue;
            triples.add(triple);
        }
        return triples;
    }

    public void finalize() throws TrippiException {
        this.close();
    }

    public void setAliasMap(Map aliases) {
        this.m_aliases = aliases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() throws TrippiException {
        try {
            int n = 0;
            while (this.hasNext()) {
                this.next();
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.close();
        }
    }

    public int toStream(OutputStream out, RDFFormat format) throws TrippiException {
        TupleWriter writer;
        if (format == RDFFormat.SPARQL) {
            writer = new SparqlTupleWriter(out, this.m_aliases);
        } else if (format == RDFFormat.SIMPLE) {
            writer = new SimpleTupleWriter(out, this.m_aliases);
        } else if (format == RDFFormat.CSV) {
            writer = new CSVTupleWriter(out, this.m_aliases);
        } else if (format == RDFFormat.TSV) {
            writer = new TSVTupleWriter(out, this.m_aliases);
        } else {
            throw new TrippiException("Unsupported output format: " + format.getName());
        }
        return ((TupleWriter)writer).write(this);
    }

    public static TupleIterator fromStream(InputStream in, RDFFormat format) throws IOException, TrippiException {
        if (format == RDFFormat.SPARQL) {
            return new SparqlTupleIterator(in);
        }
        throw new TrippiException("Unsupported input format: " + format.getName());
    }

    public static void main(String[] args) throws Exception {
        TupleIterator.fromStream(new FileInputStream(new File(args[0])), RDFFormat.SPARQL).toStream(System.out, RDFFormat.SIMPLE);
    }
}

