/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.impl.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.trippi.FlushErrorHandler;
import org.trippi.RDFFormat;
import org.trippi.TripleIterator;
import org.trippi.TriplestoreWriter;
import org.trippi.TrippiException;
import org.trippi.impl.base.AliasManager;
import org.trippi.impl.base.SynchronizedTriplestoreReader;
import org.trippi.impl.base.SynchronizedTriplestoreSession;

public class SynchronizedTriplestoreWriter
extends SynchronizedTriplestoreReader
implements TriplestoreWriter {
    private static final Logger logger = Logger.getLogger((String)SynchronizedTriplestoreWriter.class.getName());
    private SynchronizedTriplestoreSession m_session;
    private int m_flushSize;

    public SynchronizedTriplestoreWriter(SynchronizedTriplestoreSession session, AliasManager aliasManager, int flushSize) {
        super(session, aliasManager);
        this.m_session = session;
        this.m_flushSize = flushSize;
    }

    public void add(List triples, boolean flush) throws TrippiException {
        HashSet set = new HashSet();
        Iterator iter = triples.iterator();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        this.m_session.add(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TripleIterator iter, boolean flush) throws IOException, TrippiException {
        try {
            HashSet<Triple> set = new HashSet<Triple>();
            while (iter.hasNext()) {
                set.add(iter.next());
                if (set.size() != this.m_flushSize) continue;
                this.m_session.add(set);
                set = null;
                set = new HashSet();
            }
            if (set.size() > 0) {
                this.m_session.add(set);
            }
        }
        finally {
            iter.close();
        }
    }

    public void add(Triple triple, boolean flush) throws TrippiException {
        HashSet<Triple> set = new HashSet<Triple>(1);
        set.add(triple);
        this.m_session.add(set);
    }

    public void delete(List triples, boolean flush) throws IOException, TrippiException {
        HashSet set = new HashSet();
        Iterator iter = triples.iterator();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        this.m_session.delete(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(TripleIterator iter, boolean flush) throws IOException, TrippiException {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("trippi-deltriples", "txt");
            FileOutputStream fout = new FileOutputStream(tempFile);
            try {
                iter.toStream(fout, RDFFormat.TURTLE);
            }
            finally {
                try {
                    fout.close();
                }
                catch (Exception e) {}
            }
            iter.close();
            iter = TripleIterator.fromStream(new FileInputStream(tempFile), RDFFormat.TURTLE);
            try {
                HashSet<Triple> set = new HashSet<Triple>();
                while (iter.hasNext()) {
                    set.add(iter.next());
                    if (set.size() != this.m_flushSize) continue;
                    this.m_session.delete(set);
                    set = null;
                    set = new HashSet();
                }
                if (set.size() > 0) {
                    this.m_session.delete(set);
                }
            }
            finally {
                iter.close();
            }
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    public void delete(Triple triple, boolean flush) throws IOException, TrippiException {
        HashSet<Triple> set = new HashSet<Triple>(1);
        set.add(triple);
        this.m_session.delete(set);
    }

    public void flushBuffer() {
    }

    public void setFlushErrorHandler(FlushErrorHandler h) {
    }

    public int getBufferSize() {
        return 0;
    }

    public List findBufferedUpdates(SubjectNode subject, PredicateNode predicate, ObjectNode object, int updateType) {
        return Collections.EMPTY_LIST;
    }
}

