/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jrdf.graph.Node;
import org.trippi.RDFUtil;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class SparqlTupleIterator
extends TupleIterator {
    private InputStream m_inputStream;
    private XmlPullParser m_xpp;
    private String[] m_names;
    private Map m_next;
    private boolean m_closed;
    private RDFUtil m_util;

    public SparqlTupleIterator(InputStream in) throws TrippiException {
        try {
            this.m_inputStream = in;
            this.m_xpp = XmlPullParserFactory.newInstance().newPullParser();
            this.m_xpp.setInput((Reader)new InputStreamReader(this.m_inputStream));
            this.m_xpp.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            this.m_closed = false;
            this.m_util = new RDFUtil();
            this.m_names = this.parseNames();
            this.m_next = this.getNext();
        }
        catch (IOException e) {
            throw new TrippiException("IOError with xml stream", e);
        }
        catch (XmlPullParserException e) {
            throw new TrippiException("Error parsing", e);
        }
    }

    public boolean hasNext() {
        return this.m_next != null;
    }

    public Map next() throws TrippiException {
        if (this.m_next == null) {
            return null;
        }
        Map last = this.m_next;
        this.m_next = this.getNext();
        return last;
    }

    private Map getNext() throws TrippiException {
        try {
            boolean inResult = false;
            while (!inResult) {
                int eventType = this.m_xpp.next();
                if (eventType == 2 && this.m_xpp.getName().equals("result")) {
                    inResult = true;
                    continue;
                }
                if (eventType != 1) continue;
                return null;
            }
            HashMap<String, Node> m = new HashMap<String, Node>();
            while (inResult) {
                int eventType = this.m_xpp.next();
                if (eventType == 2) {
                    m.put(this.m_xpp.getName(), this.parseNode());
                    continue;
                }
                if (eventType != 3) continue;
                inResult = false;
            }
            return m;
        }
        catch (IOException e) {
            throw new TrippiException("IO Error while getting next result", e);
        }
        catch (XmlPullParserException e) {
            throw new TrippiException("Parser error while getting next result", e);
        }
    }

    private Node parseNode() throws TrippiException {
        try {
            String uri = this.m_xpp.getAttributeValue(null, "uri");
            if (uri != null) {
                this.m_xpp.nextText();
                return this.m_util.createResource(new URI(uri));
            }
            String dType = this.m_xpp.getAttributeValue(null, "datatype");
            if (dType != null) {
                return this.m_util.createLiteral(this.m_xpp.nextText(), new URI(dType));
            }
            String lang = this.m_xpp.getAttributeValue(null, "xml:lang");
            if (lang != null) {
                return this.m_util.createLiteral(this.m_xpp.nextText(), lang);
            }
            String nodeID = this.m_xpp.getAttributeValue(null, "bnodeid");
            if (nodeID != null) {
                this.m_xpp.nextText();
                return this.m_util.createResource(nodeID.hashCode());
            }
            String bound = this.m_xpp.getAttributeValue(null, "bound");
            if (bound != null && bound.equals("false")) {
                this.m_xpp.nextText();
                return null;
            }
            String val = this.m_xpp.nextText();
            if (val == null) {
                val = "";
            }
            return this.m_util.createLiteral(val);
        }
        catch (Exception e) {
            throw new TrippiException("Error parsing value as JRDF Node.", e);
        }
    }

    private String[] parseNames() throws XmlPullParserException, IOException {
        boolean inVariables = false;
        while (!inVariables) {
            int eventType = this.m_xpp.next();
            if (eventType != 2 || !this.m_xpp.getName().equals("head")) continue;
            inVariables = true;
        }
        ArrayList<String> names = new ArrayList<String>();
        while (inVariables) {
            int eventType = this.m_xpp.next();
            if (eventType == 2) {
                names.add(this.m_xpp.getAttributeValue(null, "name"));
                continue;
            }
            if (eventType != 3 || !this.m_xpp.getName().equals("head")) continue;
            inVariables = false;
        }
        return names.toArray(new String[0]);
    }

    public String[] names() {
        return this.m_names;
    }

    public void close() throws TrippiException {
        if (!this.m_closed) {
            try {
                this.m_inputStream.close();
                this.m_closed = true;
            }
            catch (Exception e) {
                throw new TrippiException("Error closing underlying InputStream.", e);
            }
        }
    }
}

