/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import org.jrdf.graph.Literal;
import org.jrdf.graph.Node;
import org.jrdf.graph.URIReference;
import org.trippi.RDFUtil;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;
import org.trippi.io.TupleWriter;

public class TSVTupleWriter
extends TupleWriter {
    private PrintWriter m_out;
    private Map m_aliases;

    public TSVTupleWriter(OutputStream out, Map aliases) throws TrippiException {
        try {
            this.m_out = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
            this.m_aliases = aliases;
        }
        catch (IOException e) {
            throw new TrippiException("Error setting up writer", e);
        }
    }

    public int write(TupleIterator iter) throws TrippiException {
        String[] names = iter.names();
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                this.m_out.print("\t");
            }
            this.m_out.print(names[i]);
        }
        this.m_out.println();
        int count = 0;
        while (iter.hasNext()) {
            Map result = iter.next();
            for (int i = 0; i < names.length; ++i) {
                if (i > 0) {
                    this.m_out.print("\t");
                }
                String val = this.getValue((Node)result.get(names[i]));
                this.m_out.print(val.replaceAll("\t", " ").replaceAll("\n", " "));
            }
            this.m_out.println();
            this.m_out.flush();
            ++count;
        }
        this.m_out.flush();
        iter.close();
        return count;
    }

    public String getValue(Node node) {
        String fullString;
        block2: {
            Literal literal;
            block3: {
                fullString = RDFUtil.toString(node);
                if (this.m_aliases == null) break block2;
                if (!(node instanceof URIReference)) break block3;
                Iterator iter = this.m_aliases.keySet().iterator();
                while (iter.hasNext()) {
                    String alias = (String)iter.next();
                    String prefix = (String)this.m_aliases.get(alias);
                    if (!fullString.startsWith("<" + prefix)) continue;
                    return this.fix("<" + alias + ":" + fullString.substring(prefix.length() + 1));
                }
                break block2;
            }
            if (!(node instanceof Literal) || (literal = (Literal)node).getDatatypeURI() == null) break block2;
            String uri = literal.getDatatypeURI().toString();
            Iterator iter = this.m_aliases.keySet().iterator();
            while (iter.hasNext()) {
                String alias = (String)iter.next();
                String prefix = (String)this.m_aliases.get(alias);
                if (!uri.startsWith(prefix)) continue;
                StringBuffer out = new StringBuffer();
                out.append('\"');
                out.append(literal.getLexicalForm().replaceAll("\"", "\\\""));
                out.append("\"^^");
                out.append(alias);
                out.append(':');
                out.append(uri.substring(prefix.length()));
                return this.fix(out.toString());
            }
        }
        return this.fix(fullString);
    }

    private String fix(String in) {
        if (in.startsWith("\"")) {
            String lit = in.substring(1, in.lastIndexOf("\""));
            return lit.replaceAll("\\\\\"", "\"");
        }
        if (in.startsWith("<")) {
            return in.substring(1, in.length() - 1);
        }
        return in;
    }
}

