/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.nodegraph.impl;

import gnu.trove.TIntHashSet;
import java.util.NoSuchElementException;
import org.jrdf.graph.Node;
import org.jrdf.graph.Triple;
import org.jrdf.util.ClosableIterator;

public class NodeIterator
implements ClosableIterator {
    public static final int SUBJECTS = 0;
    public static final int PREDICATES = 1;
    public static final int OBJECTS = 2;
    private ClosableIterator _triples;
    private int _type;
    private Node _nextNode;
    private TIntHashSet _seen;
    private boolean _closed;

    public NodeIterator(ClosableIterator triples, int type, boolean alreadyDistinct) {
        this._triples = triples;
        this._type = type;
        if (!alreadyDistinct) {
            this._seen = new TIntHashSet();
        }
        this._nextNode = this.getNextDistinctNode();
    }

    private Node getNextDistinctNode() {
        Object node = null;
        while (this._triples.hasNext() && node == null) {
            Triple triple = (Triple)this._triples.next();
            node = this._type == 0 ? triple.getSubject() : (this._type == 1 ? triple.getPredicate() : triple.getObject());
            if (this.isDistinct((Node)node)) continue;
            node = null;
        }
        if (node == null) {
            this.close();
        }
        return node;
    }

    private boolean isDistinct(Node node) {
        if (this._seen == null) {
            return true;
        }
        int uniqueId = node.hashCode();
        if (this._seen.contains(uniqueId)) {
            return false;
        }
        this._seen.add(uniqueId);
        return true;
    }

    public boolean hasNext() {
        return this._nextNode != null;
    }

    public Object next() {
        if (this._nextNode == null) {
            throw new NoSuchElementException();
        }
        Node lastNode = this._nextNode;
        this._nextNode = this.getNextDistinctNode();
        return lastNode;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean close() {
        if (!this._closed) {
            this._closed = this._triples.close();
            if (this._closed) {
                this._triples = null;
            }
            this._nextNode = null;
            this._seen = null;
        }
        return this._closed;
    }
}

