/*
 * Decompiled with CFR 0.152.
 */
package org.nsdl.mptstore.query.lang.spo;

import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.nsdl.mptstore.core.TableManager;
import org.nsdl.mptstore.query.QueryException;
import org.nsdl.mptstore.query.component.BasicNodePattern;
import org.nsdl.mptstore.query.component.BasicTriplePattern;
import org.nsdl.mptstore.query.component.TriplePattern;
import org.nsdl.mptstore.query.lang.QueryCompiler;
import org.nsdl.mptstore.query.lang.QuerySyntaxException;
import org.nsdl.mptstore.query.provider.SQLProvider;
import org.nsdl.mptstore.query.provider.TriplePatternSQLProvider;
import org.nsdl.mptstore.rdf.ObjectNode;
import org.nsdl.mptstore.rdf.PredicateNode;
import org.nsdl.mptstore.rdf.SubjectNode;
import org.nsdl.mptstore.util.NTriplesUtil;

public class SPOQueryCompiler
implements QueryCompiler {
    public static final List<String> SPO_TARGETS;
    private static final Logger LOG;
    private static final String EXPECTED_AQLST = "Expected '*', '\"', '<', ' ', or TAB";
    private static final String EXPECTED_ALST = "Expected '*', '<', ' ', or TAB";
    private static final String EXPECTED_EOS = "Expected end of query string";
    private static final String EXPECTED_G = "Expected '>'";
    private static final String EXPECTED_ST = "Expected ' ' or TAB";
    private TableManager _tableManager;
    private boolean _backslashIsEscape;

    public SPOQueryCompiler(TableManager tableManager, boolean backslashIsEscape) {
        this._tableManager = tableManager;
        this._backslashIsEscape = backslashIsEscape;
    }

    public SQLProvider compile(String query) throws QueryException {
        try {
            LOG.info((Object)("Compiling query: " + query));
            return new TriplePatternSQLProvider(this._tableManager, this._backslashIsEscape, this.parseTriplePattern(query), SPO_TARGETS);
        }
        catch (ParseException e) {
            throw new QuerySyntaxException("Error parsing SPO query", e);
        }
    }

    private TriplePattern parseTriplePattern(String query) throws ParseException {
        StringReader reader = new StringReader(query);
        try {
            ObjectNode object;
            PredicateNode predicate;
            SubjectNode subject;
            int i = 0;
            int c = reader.read();
            if (c == 42) {
                subject = null;
                ++i;
            } else {
                reader.reset();
                String sString = NTriplesUtil.consumeURIReference(reader, i);
                subject = NTriplesUtil.parseSubject(sString);
                i += sString.length();
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Parsed subject pattern as " + subject));
            }
            i += NTriplesUtil.consumeWhitespace(reader, i);
            reader.mark(Integer.MAX_VALUE);
            c = reader.read();
            if (c == 42) {
                predicate = null;
                ++i;
            } else {
                reader.reset();
                String pString = NTriplesUtil.consumeURIReference(reader, i);
                try {
                    predicate = NTriplesUtil.parsePredicate(pString);
                }
                catch (ParseException e) {
                    throw new ParseException(e.getMessage(), e.getErrorOffset() + i);
                }
                i += pString.length();
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Parsed predicate pattern as " + predicate));
            }
            i += NTriplesUtil.consumeWhitespace(reader, i);
            c = reader.read();
            if (c == 42) {
                object = null;
                if (reader.read() != -1) {
                    throw new ParseException(EXPECTED_EOS, i + 1);
                }
            } else {
                try {
                    object = NTriplesUtil.parseObject(query.substring(i));
                }
                catch (ParseException e) {
                    throw new ParseException(e.getMessage(), e.getErrorOffset() + i);
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Parsed object pattern as " + object));
            }
            reader.close();
            return SPOQueryCompiler.getTriplePattern(subject, predicate, object);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO error", e);
        }
    }

    private static TriplePattern getTriplePattern(SubjectNode subject, PredicateNode predicate, ObjectNode object) {
        BasicNodePattern<SubjectNode> sPattern = subject != null ? new BasicNodePattern<SubjectNode>(subject) : new BasicNodePattern("s");
        BasicNodePattern<PredicateNode> pPattern = predicate != null ? new BasicNodePattern<PredicateNode>(predicate) : new BasicNodePattern("p");
        BasicNodePattern<ObjectNode> oPattern = object != null ? new BasicNodePattern<ObjectNode>(object) : new BasicNodePattern("o");
        return new BasicTriplePattern(sPattern, pPattern, oPattern);
    }

    static {
        LOG = Logger.getLogger((String)SPOQueryCompiler.class.getName());
        SPO_TARGETS = new ArrayList<String>();
        SPO_TARGETS.add("s");
        SPO_TARGETS.add("p");
        SPO_TARGETS.add("o");
    }
}

