/*
 * Decompiled with CFR 0.152.
 */
package org.nsdl.mptstore.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.text.ParseException;
import org.nsdl.mptstore.rdf.Literal;
import org.nsdl.mptstore.rdf.Node;
import org.nsdl.mptstore.rdf.ObjectNode;
import org.nsdl.mptstore.rdf.PredicateNode;
import org.nsdl.mptstore.rdf.SubjectNode;
import org.nsdl.mptstore.rdf.Triple;
import org.nsdl.mptstore.rdf.URIReference;

public abstract class NTriplesUtil {
    private static final int SUBTAG_MAXLEN = 8;
    private static final int HIGHEST_ASCII_CHAR = 127;
    private static final int HEX = 16;
    private static final int SHORT_ESCAPE_LENGTH = 5;
    private static final int LONG_ESCAPE_LENGTH = 10;
    private static final int UC_LOW1 = 0;
    private static final int UC_HIGH1 = 8;
    private static final int UC_LOW2 = 11;
    private static final int UC_HIGH2 = 12;
    private static final int UC_LOW3 = 14;
    private static final int UC_HIGH3 = 31;
    private static final int UC_LOW4 = 127;
    private static final int UC_HIGH4 = 65535;
    private static final int UC_LOW5 = 65536;
    private static final int UC_HIGH5 = 0x10FFFF;
    private static final String EXPECTED_ABS_URI = "Expected absolute URI";
    private static final String EXPECTED_ACE = "Expected '@', '^', or EOF";
    private static final String EXPECTED_C = "Expected '^'";
    private static final String EXPECTED_G = "Expected '>'";
    private static final String EXPECTED_L = "Expected '<'";
    private static final String EXPECTED_LST = "Expected '<', ' ', or TAB";
    private static final String EXPECTED_PST = "Expected '.', ' ', or TAB";
    private static final String EXPECTED_Q = "Expected '\"'";
    private static final String EXPECTED_QL = "Expected '\"' or '<'";
    private static final String EXPECTED_QLST = "Expected '\"', '<', ' ', or TAB";
    private static final String EXPECTED_ST = "Expected ' ' or TAB";
    private static final String UNEXPECTED_EOF = "Unexpected EOF";
    private static final String NON_ASCII_CHAR = "Non-ASCII character";
    private static final String UNESCAPED_BACKSLASH = "Unescaped backslash";
    private static final String ILLEGAL_ESCAPE = "Illegal Unicode escape sequence";
    private static final String INCOMPLETE_ESCAPE = "Incomplete Unicode escape sequence";
    private static final String UNESCAPED_CR = "Unescaped carriage return";
    private static final String UNESCAPED_LF = "Unescaped linefeed";
    private static final String UNESCAPED_TAB = "Unescaped tab";
    private static final int[] SPACE_OR_TAB = new int[]{32, 9};

    private NTriplesUtil() {
    }

    public static String consumeURIReference(Reader reader, int pos) throws IOException, ParseException {
        int i = 0;
        StringBuffer buf = new StringBuffer();
        int c = reader.read();
        while (c != 62) {
            if (c == -1) {
                throw new ParseException(EXPECTED_G, pos + i);
            }
            buf.append((char)c);
            ++i;
            c = reader.read();
        }
        buf.append((char)c);
        return buf.toString();
    }

    private static boolean isOneOf(int[] chars, int c) {
        for (int i = 0; i < chars.length; ++i) {
            if (c != chars[i]) continue;
            return true;
        }
        return false;
    }

    public static int consumeWhitespace(Reader reader, int pos) throws IOException, ParseException {
        int i = 0;
        int c = reader.read();
        if (!NTriplesUtil.isOneOf(SPACE_OR_TAB, c)) {
            throw new ParseException(EXPECTED_ST, pos + i);
        }
        while (NTriplesUtil.isOneOf(SPACE_OR_TAB, c)) {
            if (c == -1) {
                throw new ParseException(UNEXPECTED_EOF, pos + i - 1);
            }
            ++i;
            reader.mark(Integer.MAX_VALUE);
            c = reader.read();
        }
        reader.reset();
        return i;
    }

    private static String getObjectString(String ntTriple, int i) throws ParseException {
        int j = ntTriple.length() - 1;
        char ch = ntTriple.charAt(j);
        while (ch != '.') {
            if (ch != '\t' && ch != ' ') {
                throw new ParseException(EXPECTED_PST, j);
            }
            if (--j < i) {
                throw new ParseException(EXPECTED_QLST, j);
            }
            ch = ntTriple.charAt(j);
        }
        if (--j < i) {
            throw new ParseException(EXPECTED_QLST, j);
        }
        ch = ntTriple.charAt(j);
        while (ch == ' ' || ch == '\t') {
            if (--j < i) {
                throw new ParseException(EXPECTED_QLST, j);
            }
            ch = ntTriple.charAt(j);
        }
        return ntTriple.substring(i, j + 1);
    }

    public static Triple parseTriple(String ntTriple) throws ParseException {
        StringReader reader = new StringReader(ntTriple);
        try {
            ObjectNode object;
            PredicateNode predicate;
            int i = 0;
            String sString = NTriplesUtil.consumeURIReference(reader, i);
            SubjectNode subject = NTriplesUtil.parseSubject(sString);
            i += sString.length();
            i += NTriplesUtil.consumeWhitespace(reader, i);
            String pString = NTriplesUtil.consumeURIReference(reader, i);
            try {
                predicate = NTriplesUtil.parsePredicate(pString);
            }
            catch (ParseException e) {
                throw new ParseException(e.getMessage(), e.getErrorOffset() + i);
            }
            i += pString.length();
            i += NTriplesUtil.consumeWhitespace(reader, i);
            String oString = NTriplesUtil.getObjectString(ntTriple, i);
            try {
                object = NTriplesUtil.parseObject(oString);
            }
            catch (ParseException e) {
                throw new ParseException(e.getMessage(), e.getErrorOffset() + i);
            }
            return new Triple(subject, predicate, object);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO error", e);
        }
    }

    public static SubjectNode parseSubject(String ntSubject) throws ParseException {
        return NTriplesUtil.parseURIReference(ntSubject);
    }

    public static PredicateNode parsePredicate(String ntPredicate) throws ParseException {
        return NTriplesUtil.parseURIReference(ntPredicate);
    }

    public static ObjectNode parseObject(String ntObject) throws ParseException {
        return (ObjectNode)NTriplesUtil.parseNode(ntObject);
    }

    public static Node parseNode(String ntNode) throws ParseException {
        char first = ntNode.charAt(0);
        if (first == '\"') {
            return NTriplesUtil.parseLiteral(ntNode);
        }
        if (first == '<') {
            return NTriplesUtil.parseURIReference(ntNode);
        }
        throw new ParseException(EXPECTED_QL, 0);
    }

    private static String consumeLiteralValue(Reader reader, int pos) throws IOException, ParseException {
        StringBuffer escaped = new StringBuffer();
        int i = 0;
        int c = reader.read();
        while (c != 34) {
            if (c == -1) {
                throw new ParseException(EXPECTED_Q, pos + i);
            }
            escaped.append((char)c);
            if (c == 92) {
                c = reader.read();
                ++i;
                if (c == -1) {
                    throw new ParseException(EXPECTED_Q, pos + i);
                }
                escaped.append((char)c);
            } else {
                if (c == 13) {
                    throw new ParseException(UNESCAPED_LF, pos + i);
                }
                if (c == 10) {
                    throw new ParseException(UNESCAPED_CR, pos + i);
                }
                if (c == 9) {
                    throw new ParseException(UNESCAPED_TAB, pos + i);
                }
            }
            c = reader.read();
            ++i;
        }
        return escaped.toString();
    }

    public static Literal parseLiteral(String s) throws ParseException {
        StringReader reader = new StringReader(s);
        try {
            String value;
            int first = reader.read();
            if (first != 34) {
                throw new ParseException(EXPECTED_Q, 0);
            }
            int i = 1;
            String escaped = NTriplesUtil.consumeLiteralValue(reader, i);
            try {
                value = NTriplesUtil.unescapeLiteralValue(escaped);
            }
            catch (ParseException e) {
                throw new ParseException(e.getMessage(), e.getErrorOffset() + i);
            }
            i += escaped.length();
            int c = reader.read();
            ++i;
            if (c == 64) {
                try {
                    return new Literal(value, s.substring(i + 1));
                }
                catch (ParseException e) {
                    throw new ParseException(e.getMessage(), e.getErrorOffset() + i + 1);
                }
            }
            if (c == 94) {
                c = reader.read();
                ++i;
                if (c != 94) {
                    throw new ParseException(EXPECTED_C, i);
                }
                try {
                    URIReference datatype = NTriplesUtil.parseURIReference(s.substring(i + 1));
                    return new Literal(value, datatype);
                }
                catch (ParseException e) {
                    throw new ParseException(e.getMessage(), e.getErrorOffset() + i);
                }
            }
            if (c == -1) {
                return new Literal(value);
            }
            throw new ParseException(EXPECTED_ACE, i);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO error", e);
        }
    }

    public static URIReference parseURIReference(String s) throws ParseException {
        char first = s.charAt(0);
        if (first != '<') {
            throw new ParseException(EXPECTED_L, 0);
        }
        char last = s.charAt(s.length() - 1);
        if (last != '>') {
            throw new ParseException(EXPECTED_G, s.length() - 1);
        }
        try {
            return new URIReference(s.substring(1, s.length() - 1));
        }
        catch (URISyntaxException e) {
            throw new ParseException(EXPECTED_ABS_URI, 1);
        }
    }

    private static void verifyAscii(String s) throws ParseException {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c <= '\u007f') continue;
            throw new ParseException(NON_ASCII_CHAR, i);
        }
    }

    private static int appendUnescaped(String s, int backslashPos, int i, char c, StringBuffer buf) throws ParseException {
        if (c == 'u') {
            if (backslashPos + 5 >= s.length()) {
                throw new ParseException(INCOMPLETE_ESCAPE, i);
            }
            String xx = s.substring(backslashPos + 2, backslashPos + 5 + 1);
            try {
                char nextChar = (char)Integer.parseInt(xx, 16);
                buf.append(nextChar);
                return backslashPos + 5 + 1;
            }
            catch (NumberFormatException e) {
                throw new ParseException(ILLEGAL_ESCAPE, i);
            }
        }
        if (c == 'U') {
            if (backslashPos + 10 - 1 >= s.length()) {
                throw new ParseException(INCOMPLETE_ESCAPE, i);
            }
            String xx = s.substring(backslashPos + 2, backslashPos + 10);
            try {
                char nextChar = (char)Integer.parseInt(xx, 16);
                buf.append(nextChar);
                return backslashPos + 10;
            }
            catch (NumberFormatException e) {
                throw new ParseException(ILLEGAL_ESCAPE, i);
            }
        }
        buf.append(NTriplesUtil.getUnescaped(c, i));
        return backslashPos + 2;
    }

    private static char getUnescaped(char c, int i) throws ParseException {
        if (c == 't') {
            return '\t';
        }
        if (c == 'r') {
            return '\r';
        }
        if (c == 'n') {
            return '\n';
        }
        if (c == '\"' || c == '\\') {
            return c;
        }
        throw new ParseException(UNESCAPED_BACKSLASH, i);
    }

    public static String unescapeLiteralValue(String s) throws ParseException {
        NTriplesUtil.verifyAscii(s);
        int backslashPos = s.indexOf(92);
        if (backslashPos == -1) {
            return s;
        }
        int i = 0;
        StringBuffer buf = new StringBuffer(s.length());
        while (backslashPos != -1) {
            buf.append(s.substring(i, backslashPos));
            if (backslashPos + 1 >= s.length()) {
                throw new ParseException(UNESCAPED_BACKSLASH, i);
            }
            char c = s.charAt(backslashPos + 1);
            i = NTriplesUtil.appendUnescaped(s, backslashPos, i, c, buf);
            backslashPos = s.indexOf(92, i);
        }
        buf.append(s.substring(i));
        return buf.toString();
    }

    public static String escapeLiteralValue(String s) {
        int len = s.length();
        StringBuffer out = new StringBuffer(len * 2);
        for (int i = 0; i < len; ++i) {
            char c;
            char cNum = c = s.charAt(i);
            if (c == '\\') {
                out.append("\\\\");
                continue;
            }
            if (c == '\"') {
                out.append("\\\"");
                continue;
            }
            if (c == '\n') {
                out.append("\\n");
                continue;
            }
            if (c == '\r') {
                out.append("\\r");
                continue;
            }
            if (c == '\t') {
                out.append("\\t");
                continue;
            }
            if (NTriplesUtil.isLowUnicode(cNum)) {
                out.append("\\u");
                out.append(NTriplesUtil.hexString(cNum, 4));
                continue;
            }
            if (NTriplesUtil.isHighUnicode(cNum)) {
                out.append("\\U");
                out.append(NTriplesUtil.hexString(cNum, 8));
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static void validateLanguage(String language) throws ParseException {
        if (language == null || language.length() == 0) {
            throw new ParseException("Language tag must not be empty", 0);
        }
        if (language.indexOf(" ") != -1) {
            throw new ParseException("Space character not allowed in language tag", language.indexOf(" "));
        }
        if (language.startsWith("-") || language.endsWith("-")) {
            throw new ParseException("Language tag cannot start or end with -", 0);
        }
        NTriplesUtil.validateLanguageSubtags(language.split("-"));
    }

    private static void validateLanguageSubtags(String[] subtags) throws ParseException {
        for (int i = 0; i < subtags.length; ++i) {
            if (subtags[i].length() < 1 || subtags[i].length() > 8) {
                throw new ParseException("Language subtags must be 1-8 characters long", 0);
            }
            NTriplesUtil.validateLanguageSubtagChars(subtags[i], i == 0);
        }
    }

    private static void validateLanguageSubtagChars(String subtag, boolean isFirst) throws ParseException {
        for (int i = 0; i < subtag.length(); ++i) {
            char c = subtag.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' && !isFirst) continue;
            throw new ParseException("Language subtag cannot contain character '" + c + "'", 0);
        }
    }

    private static boolean isLowUnicode(int cNum) {
        return cNum >= 0 && cNum <= 8 || cNum == 11 || cNum == 12 || cNum >= 14 && cNum <= 31 || cNum >= 127 && cNum <= 65535;
    }

    private static boolean isHighUnicode(int cNum) {
        return cNum >= 65536 && cNum <= 0x10FFFF;
    }

    private static String hexString(int num, int len) {
        StringBuffer out = new StringBuffer(len);
        String hex = Integer.toHexString(num).toUpperCase();
        int n = len - hex.length();
        for (int i = 0; i < n; ++i) {
            out.append('0');
        }
        out.append(hex);
        return out.toString();
    }
}

