/*
 * Decompiled with CFR 0.152.
 */
package fedora.client;

import fedora.client.Administrator;
import fedora.client.SwingWorker;
import fedora.server.management.FedoraAPIM;
import fedora.server.types.gen.Datastream;
import fedora.server.types.gen.RelationshipTuple;
import java.awt.Dimension;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.axis.types.NonNegativeInteger;

public class APIMStubWrapper
implements FedoraAPIM {
    private FedoraAPIM m_instance;

    public APIMStubWrapper(FedoraAPIM instance) {
        this.m_instance = instance;
    }

    public String ingest(byte[] objectXML, String format, String logMessage) throws RemoteException {
        String METHOD_NAME = "ingest";
        HashMap<String, Object> PARMS = new HashMap<String, Object>();
        PARMS.put("objectXML", objectXML);
        PARMS.put("format", format);
        PARMS.put("logMessage", logMessage);
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.ingest((byte[])this.parms.get("objectXML"), (String)this.parms.get("format"), (String)this.parms.get("logMessage"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (String)worker.get();
    }

    public String modifyObject(String pid, String state, String label, String ownerId, String logMessage) throws RemoteException {
        String METHOD_NAME = "modifyObject";
        HashMap<String, String> PARMS = new HashMap<String, String>();
        PARMS.put("pid", pid);
        PARMS.put("state", state);
        PARMS.put("label", label);
        PARMS.put("ownerId", ownerId);
        PARMS.put("logMessage", logMessage);
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.modifyObject((String)this.parms.get("pid"), (String)this.parms.get("state"), (String)this.parms.get("label"), (String)this.parms.get("ownerId"), (String)this.parms.get("logMessage"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (String)worker.get();
    }

    public byte[] getObjectXML(String pid) throws RemoteException {
        String METHOD_NAME = "getObjectXML";
        HashMap<String, String> PARMS = new HashMap<String, String>();
        PARMS.put("pid", pid);
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.getObjectXML((String)this.parms.get("pid"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (byte[])worker.get();
    }

    public byte[] export(String pid, String format, String context) throws RemoteException {
        String METHOD_NAME = "export";
        HashMap<String, String> PARMS = new HashMap<String, String>();
        PARMS.put("pid", pid);
        PARMS.put("format", format);
        PARMS.put("context", context);
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.export((String)this.parms.get("pid"), (String)this.parms.get("format"), (String)this.parms.get("context"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (byte[])worker.get();
    }

    public String purgeObject(String pid, String logMessage, boolean force) throws RemoteException {
        String METHOD_NAME = "purgeObject";
        HashMap<String, Object> PARMS = new HashMap<String, Object>();
        PARMS.put("pid", pid);
        PARMS.put("logMessage", logMessage);
        PARMS.put("force", new Boolean(force));
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.purgeObject((String)this.parms.get("pid"), (String)this.parms.get("logMessage"), (Boolean)this.parms.get("force"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (String)worker.get();
    }

    public String addDatastream(String pid, String dsID, String[] altIDs, String dsLabel, boolean versionable, String MIMEType, String formatURI, String dsLocation, String controlGroup, String dsState, String checksumType, String checksum, String logMessage) throws RemoteException {
        String METHOD_NAME = "addDatastream";
        HashMap<String, Object> PARMS = new HashMap<String, Object>();
        PARMS.put("pid", pid);
        PARMS.put("dsID", dsID);
        PARMS.put("altIDs", altIDs);
        PARMS.put("dsLabel", dsLabel);
        PARMS.put("versionable", new Boolean(versionable));
        PARMS.put("MIMEType", MIMEType);
        PARMS.put("formatURI", formatURI);
        PARMS.put("dsLocation", dsLocation);
        PARMS.put("controlGroup", controlGroup);
        PARMS.put("dsState", dsState);
        PARMS.put("checksumType", checksumType);
        PARMS.put("checksum", checksum);
        PARMS.put("logMessage", logMessage);
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.addDatastream((String)this.parms.get("pid"), (String)this.parms.get("dsID"), (String[])this.parms.get("altIDs"), (String)this.parms.get("dsLabel"), (Boolean)this.parms.get("versionable"), (String)this.parms.get("MIMEType"), (String)this.parms.get("formatURI"), (String)this.parms.get("dsLocation"), (String)this.parms.get("controlGroup"), (String)this.parms.get("dsState"), (String)this.parms.get("checksumType"), (String)this.parms.get("checksum"), (String)this.parms.get("logMessage"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (String)worker.get();
    }

    public String modifyDatastreamByReference(String pid, String dsID, String[] altIDs, String dsLabel, String MIMEType, String formatURI, String dsLocation, String checksumType, String checksum, String logMessage, boolean force) throws RemoteException {
        String METHOD_NAME = "modifyDatastreamByReference";
        HashMap<String, Object> PARMS = new HashMap<String, Object>();
        PARMS.put("pid", pid);
        PARMS.put("dsID", dsID);
        PARMS.put("altIDs", altIDs);
        PARMS.put("dsLabel", dsLabel);
        PARMS.put("MIMEType", MIMEType);
        PARMS.put("formatURI", formatURI);
        PARMS.put("dsLocation", dsLocation);
        PARMS.put("checksumType", checksumType);
        PARMS.put("checksum", checksum);
        PARMS.put("logMessage", logMessage);
        PARMS.put("force", new Boolean(force));
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.modifyDatastreamByReference((String)this.parms.get("pid"), (String)this.parms.get("dsID"), (String[])this.parms.get("altIDs"), (String)this.parms.get("dsLabel"), (String)this.parms.get("MIMEType"), (String)this.parms.get("formatURI"), (String)this.parms.get("dsLocation"), (String)this.parms.get("checksumType"), (String)this.parms.get("checksum"), (String)this.parms.get("logMessage"), (Boolean)this.parms.get("force"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (String)worker.get();
    }

    public String modifyDatastreamByValue(String pid, String dsID, String[] altIDs, String dsLabel, String MIMEType, String formatURI, byte[] dsContent, String checksumType, String checksum, String logMessage, boolean force) throws RemoteException {
        String METHOD_NAME = "modifyDatastreamByValue";
        HashMap<String, Object> PARMS = new HashMap<String, Object>();
        PARMS.put("pid", pid);
        PARMS.put("dsID", dsID);
        PARMS.put("altIDs", altIDs);
        PARMS.put("dsLabel", dsLabel);
        PARMS.put("MIMEType", MIMEType);
        PARMS.put("formatURI", formatURI);
        PARMS.put("dsContent", dsContent);
        PARMS.put("checksumType", checksumType);
        PARMS.put("checksum", checksum);
        PARMS.put("logMessage", logMessage);
        PARMS.put("force", new Boolean(force));
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.modifyDatastreamByValue((String)this.parms.get("pid"), (String)this.parms.get("dsID"), (String[])this.parms.get("altIDs"), (String)this.parms.get("dsLabel"), (String)this.parms.get("MIMEType"), (String)this.parms.get("formatURI"), (byte[])this.parms.get("dsContent"), (String)this.parms.get("checksumType"), (String)this.parms.get("checksum"), (String)this.parms.get("logMessage"), (Boolean)this.parms.get("force"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (String)worker.get();
    }

    public String setDatastreamState(String pid, String dsID, String dsState, String logMessage) throws RemoteException {
        String METHOD_NAME = "setDatastreamState";
        HashMap<String, String> PARMS = new HashMap<String, String>();
        PARMS.put("pid", pid);
        PARMS.put("dsID", dsID);
        PARMS.put("dsState", dsState);
        PARMS.put("logMessage", logMessage);
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.setDatastreamState((String)this.parms.get("pid"), (String)this.parms.get("dsID"), (String)this.parms.get("dsState"), (String)this.parms.get("logMessage"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (String)worker.get();
    }

    public String setDatastreamVersionable(String pid, String dsID, boolean versionable, String logMessage) throws RemoteException {
        String METHOD_NAME = "setDatastreamVersionable";
        HashMap<String, Object> PARMS = new HashMap<String, Object>();
        PARMS.put("pid", pid);
        PARMS.put("dsID", dsID);
        PARMS.put("versionable", new Boolean(versionable));
        PARMS.put("logMessage", logMessage);
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.setDatastreamVersionable((String)this.parms.get("pid"), (String)this.parms.get("dsID"), (Boolean)this.parms.get("versionable"), (String)this.parms.get("logMessage"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (String)worker.get();
    }

    public String compareDatastreamChecksum(String pid, String dsID, String versionDate) throws RemoteException {
        String METHOD_NAME = "compareDatastreamChecksum";
        HashMap<String, String> PARMS = new HashMap<String, String>();
        PARMS.put("pid", pid);
        PARMS.put("dsID", dsID);
        PARMS.put("versionDate", versionDate);
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.compareDatastreamChecksum((String)this.parms.get("pid"), (String)this.parms.get("dsID"), (String)this.parms.get("versionDate"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (String)worker.get();
    }

    public Datastream getDatastream(String pid, String dsID, String asOfDateTime) throws RemoteException {
        String METHOD_NAME = "getDatastream";
        HashMap<String, String> PARMS = new HashMap<String, String>();
        PARMS.put("pid", pid);
        PARMS.put("dsID", dsID);
        PARMS.put("asOfDateTime", asOfDateTime);
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.getDatastream((String)this.parms.get("pid"), (String)this.parms.get("dsID"), (String)this.parms.get("asOfDateTime"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (Datastream)worker.get();
    }

    public Datastream[] getDatastreams(String pid, String asOfDateTime, String dsState) throws RemoteException {
        String METHOD_NAME = "getDatastreams";
        HashMap<String, String> PARMS = new HashMap<String, String>();
        PARMS.put("pid", pid);
        PARMS.put("asOfDateTime", asOfDateTime);
        PARMS.put("dsState", dsState);
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.getDatastreams((String)this.parms.get("pid"), (String)this.parms.get("asOfDateTime"), (String)this.parms.get("dsState"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (Datastream[])worker.get();
    }

    public Datastream[] getDatastreamHistory(String pid, String dsID) throws RemoteException {
        String METHOD_NAME = "getDatastreamHistory";
        HashMap<String, String> PARMS = new HashMap<String, String>();
        PARMS.put("pid", pid);
        PARMS.put("dsID", dsID);
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.getDatastreamHistory((String)this.parms.get("pid"), (String)this.parms.get("dsID"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (Datastream[])worker.get();
    }

    public String[] purgeDatastream(String pid, String dsID, String startDT, String endDT, String logMessage, boolean force) throws RemoteException {
        String METHOD_NAME = "purgeDatastream";
        HashMap<String, Object> PARMS = new HashMap<String, Object>();
        PARMS.put("pid", pid);
        PARMS.put("dsID", dsID);
        PARMS.put("startDT", startDT);
        PARMS.put("endDT", endDT);
        PARMS.put("logMessage", logMessage);
        PARMS.put("force", new Boolean(force));
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.purgeDatastream((String)this.parms.get("pid"), (String)this.parms.get("dsID"), (String)this.parms.get("startDT"), (String)this.parms.get("endDT"), (String)this.parms.get("logMessage"), (Boolean)this.parms.get("force"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (String[])worker.get();
    }

    public String[] getNextPID(NonNegativeInteger numPIDs, String pidNamespace) throws RemoteException {
        String METHOD_NAME = "getNextPID";
        HashMap<String, Object> PARMS = new HashMap<String, Object>();
        PARMS.put("numPIDs", numPIDs);
        PARMS.put("pidNamespace", pidNamespace);
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.getNextPID((NonNegativeInteger)this.parms.get("numPIDs"), (String)this.parms.get("pidNamespace"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (String[])worker.get();
    }

    public RelationshipTuple[] getRelationships(String pid, String relationship) throws RemoteException {
        String METHOD_NAME = "getRelationships";
        HashMap<String, String> PARMS = new HashMap<String, String>();
        PARMS.put("pid", pid);
        PARMS.put("relationship", relationship);
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.getRelationships((String)this.parms.get("pid"), (String)this.parms.get("relationship"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (RelationshipTuple[])worker.get();
    }

    public boolean addRelationship(String pid, String relationship, String object, boolean isLiteral, String datatype) throws RemoteException {
        String METHOD_NAME = "addRelationship";
        HashMap<String, Object> PARMS = new HashMap<String, Object>();
        PARMS.put("pid", pid);
        PARMS.put("relationship", relationship);
        PARMS.put("object", object);
        PARMS.put("isLiteral", new Boolean(isLiteral));
        PARMS.put("datatype", datatype);
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.addRelationship((String)this.parms.get("pid"), (String)this.parms.get("relationship"), (String)this.parms.get("object"), (Boolean)this.parms.get("isLiteral"), (String)this.parms.get("datatype"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (Boolean)worker.get();
    }

    public boolean purgeRelationship(String pid, String relationship, String object, boolean isLiteral, String datatype) throws RemoteException {
        String METHOD_NAME = "purgeRelationship";
        HashMap<String, Object> PARMS = new HashMap<String, Object>();
        PARMS.put("pid", pid);
        PARMS.put("relationship", relationship);
        PARMS.put("object", object);
        PARMS.put("isLiteral", new Boolean(isLiteral));
        PARMS.put("datatype", datatype);
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    return APIMStubWrapper.this.m_instance.purgeRelationship((String)this.parms.get("pid"), (String)this.parms.get("relationship"), (String)this.parms.get("object"), (Boolean)this.parms.get("isLiteral"), (String)this.parms.get("datatype"));
                }
                catch (RemoteException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 0;
        Dimension d = Administrator.PROGRESS.getSize();
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean lastWasCaps = true;
        for (int i = 0; i < METHOD_NAME.length(); ++i) {
            char c = METHOD_NAME.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (!lastWasCaps) {
                    words.add(word.toString());
                    word = new StringBuffer();
                }
                word.append(c);
                lastWasCaps = true;
                continue;
            }
            word.append(c);
            lastWasCaps = false;
        }
        words.add(word.toString());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < words.size(); ++i) {
            String lcWord = ((String)words.get(i)).toLowerCase();
            if (i == 0) {
                String firstChar = lcWord.substring(0, 1).toUpperCase();
                char lastChar = lcWord.charAt(lcWord.length() - 1);
                String middle = lcWord.substring(1, lcWord.length() - 1);
                buf.append(firstChar);
                buf.append(middle);
                buf.append(lastChar);
                buf.append(" ");
                continue;
            }
            buf.append(lcWord + " ");
        }
        Administrator.PROGRESS.setString(buf.toString() + ". . .");
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Administrator.PROGRESS.setValue(0);
        Administrator.PROGRESS.setString("");
        if (worker.thrownException != null) {
            throw (RemoteException)worker.thrownException;
        }
        return (Boolean)worker.get();
    }
}

