/*
 * Decompiled with CFR 0.152.
 */
package fedora.client;

import fedora.client.Administrator;
import fedora.client.SwingWorker;
import fedora.server.utilities.StreamUtility;
import java.awt.Dimension;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;

public class Downloader {
    private final MultiThreadedHttpConnectionManager m_cManager = new MultiThreadedHttpConnectionManager();
    private final String m_fedoraUrlStart;
    private final AuthScope m_authScope;
    private final UsernamePasswordCredentials m_creds;

    public Downloader(String host, int port, String user, String pass) throws IOException {
        this.m_fedoraUrlStart = Administrator.getProtocol() + "://" + host + ":" + port + "/fedora/get/";
        this.m_authScope = new AuthScope(host, -1, AuthScope.ANY_REALM);
        this.m_creds = new UsernamePasswordCredentials(user, pass);
    }

    public void getDatastreamContent(String pid, String dsID, String asOfDateTime, OutputStream out) throws IOException {
        InputStream in = this.getDatastreamContent(pid, dsID, asOfDateTime);
        StreamUtility.pipeStream(in, out, 4096);
    }

    public InputStream getDatastreamContent(String pid, String dsID, String asOfDateTime) throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_fedoraUrlStart);
        buf.append(pid);
        buf.append('/');
        buf.append(dsID);
        if (asOfDateTime != null) {
            buf.append('/');
            buf.append(asOfDateTime);
        }
        return this.get(buf.toString());
    }

    public void getDatastreamDissemination(String pid, String dsId, String asOfDateTime, OutputStream out) throws IOException {
        InputStream in = this.getDatastreamDissemination(pid, dsId, asOfDateTime);
        StreamUtility.pipeStream(in, out, 4096);
    }

    public InputStream getDatastreamDissemination(String pid, String dsId, String asOfDateTime) throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_fedoraUrlStart);
        buf.append(pid);
        buf.append('/');
        buf.append(dsId);
        if (asOfDateTime != null) {
            buf.append('/');
            buf.append(asOfDateTime);
        }
        return this.get(buf.toString());
    }

    public void get(String url, OutputStream out) throws IOException {
        InputStream in = this.get(url);
        StreamUtility.pipeStream(in, out, 4096);
    }

    public InputStream get(String url) throws IOException {
        GetMethod get = null;
        boolean ok = false;
        try {
            this.m_cManager.getParams().setConnectionTimeout(20000);
            HttpClient client = new HttpClient((HttpConnectionManager)this.m_cManager);
            client.getState().setCredentials(this.m_authScope, (Credentials)this.m_creds);
            client.getParams().setAuthenticationPreemptive(true);
            int redirectCount = 0;
            int resultCode = 300;
            Dimension d = null;
            while (resultCode > 299 && resultCode < 400 && redirectCount < 25) {
                get = new GetMethod(url);
                get.setDoAuthentication(true);
                get.setFollowRedirects(true);
                if (Administrator.INSTANCE != null) {
                    d = Administrator.PROGRESS.getSize();
                    Administrator.PROGRESS.setString("Downloading " + url + " . . .");
                    Administrator.PROGRESS.setValue(100);
                    Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                }
                if ((resultCode = client.executeMethod((HttpMethod)get)) <= 299 || resultCode >= 400) continue;
                ++redirectCount;
                url = get.getResponseHeader("Location").getValue();
            }
            if (resultCode != 200) {
                System.err.println(get.getResponseBodyAsString());
                throw new IOException("Server returned error: " + resultCode + " " + HttpStatus.getStatusText((int)resultCode));
            }
            ok = true;
            if (Administrator.INSTANCE != null) {
                File tempFile = File.createTempFile("fedora-client-download-", null);
                tempFile.deleteOnExit();
                HashMap<String, Closeable> PARMS = new HashMap<String, Closeable>();
                PARMS.put("in", get.getResponseBodyAsStream());
                PARMS.put("out", new FileOutputStream(tempFile));
                SwingWorker worker = new SwingWorker(PARMS){

                    public Object construct() {
                        try {
                            StreamUtility.pipeStream((InputStream)this.parms.get("in"), (OutputStream)this.parms.get("out"), 8192);
                        }
                        catch (Exception e) {
                            this.thrownException = e;
                        }
                        return "";
                    }
                };
                worker.start();
                int ms = 200;
                while (!worker.done) {
                    try {
                        Administrator.PROGRESS.setValue(ms);
                        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                        Thread.sleep(100L);
                        if ((ms += 100) < 2000) continue;
                        ms = 200;
                    }
                    catch (InterruptedException ie) {}
                }
                if (worker.thrownException != null) {
                    throw worker.thrownException;
                }
                Administrator.PROGRESS.setValue(2000);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                FileInputStream fileInputStream = new FileInputStream(tempFile);
                return fileInputStream;
            }
            InputStream inputStream = get.getResponseBodyAsStream();
            return inputStream;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (get != null && !ok) {
                get.releaseConnection();
            }
            if (Administrator.INSTANCE != null) {
                Administrator.PROGRESS.setValue(0);
                Administrator.PROGRESS.setString("");
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 7 || args.length == 8) {
                String asOfDateTime = null;
                if (args.length == 8) {
                    asOfDateTime = args[7];
                }
                FileOutputStream out = new FileOutputStream(new File(args[6]));
                Downloader downloader = new Downloader(args[0], Integer.parseInt(args[1]), args[2], args[3]);
                downloader.getDatastreamContent(args[4], args[5], asOfDateTime, out);
            } else {
                System.err.println("Usage: Downloader host port user pass pid dsid outfile [MMDDYYTHH:MM:SS]");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("ERROR: " + e.getMessage());
        }
    }
}

