/*
 * Decompiled with CFR 0.152.
 */
package fedora.client;

import fedora.client.APIAStubFactory;
import fedora.client.APIMStubFactory;
import fedora.client.HttpInputStream;
import fedora.common.Constants;
import fedora.server.access.FedoraAPIA;
import fedora.server.management.FedoraAPIM;
import fedora.server.utilities.DateUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.log4j.Logger;
import org.jrdf.graph.Literal;
import org.trippi.RDFFormat;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FedoraClient
implements Constants {
    public static final String FEDORA_URI_PREFIX = "info:fedora/";
    @Deprecated
    public static boolean FORCE_LOG4J_CONFIGURATION = false;
    public int TIMEOUT_SECONDS = 20;
    public int SOCKET_TIMEOUT_SECONDS = 150;
    public int MAX_CONNECTIONS_PER_HOST = 15;
    public int MAX_TOTAL_CONNECTIONS = 30;
    public boolean FOLLOW_REDIRECTS = true;
    private static final Logger LOG = Logger.getLogger((String)FedoraClient.class.getName());
    private final SOAPEndpoint m_accessEndpoint = new SOAPEndpoint("access");
    private final SOAPEndpoint m_managementEndpoint = new SOAPEndpoint("management");
    private String m_baseURL;
    private final String m_user;
    private final String m_pass;
    private final AuthScope m_authScope;
    private final UsernamePasswordCredentials m_creds;
    private final MultiThreadedHttpConnectionManager m_cManager;
    private String m_serverVersion;
    private String m_uploadURL;

    public FedoraClient(String baseURL, String user, String pass) throws MalformedURLException {
        this.m_baseURL = baseURL;
        this.m_user = user;
        this.m_pass = pass;
        if (!baseURL.endsWith("/")) {
            this.m_baseURL = this.m_baseURL + "/";
        }
        URL url = new URL(this.m_baseURL);
        this.m_authScope = new AuthScope(url.getHost(), -1, AuthScope.ANY_REALM);
        this.m_creds = new UsernamePasswordCredentials(user, pass);
        this.m_cManager = new MultiThreadedHttpConnectionManager();
    }

    public HttpClient getHttpClient() {
        this.m_cManager.getParams().setDefaultMaxConnectionsPerHost(this.MAX_CONNECTIONS_PER_HOST);
        this.m_cManager.getParams().setMaxTotalConnections(this.MAX_TOTAL_CONNECTIONS);
        this.m_cManager.getParams().setConnectionTimeout(this.TIMEOUT_SECONDS * 1000);
        this.m_cManager.getParams().setSoTimeout(this.SOCKET_TIMEOUT_SECONDS * 1000);
        HttpClient client = new HttpClient((HttpConnectionManager)this.m_cManager);
        client.getState().setCredentials(this.m_authScope, (Credentials)this.m_creds);
        client.getParams().setAuthenticationPreemptive(true);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(File file) throws IOException {
        PostMethod post = null;
        try {
            post = new PostMethod(this.getUploadURL());
            post.setDoAuthentication(true);
            post.getParams().setParameter("Connection", (Object)"Keep-Alive");
            post.setContentChunked(true);
            Part[] parts = new Part[]{new FilePart("file", file)};
            post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
            int responseCode = this.getHttpClient().executeMethod((HttpMethod)post);
            String body = null;
            try {
                body = post.getResponseBodyAsString();
            }
            catch (Exception e) {
                LOG.warn((Object)"Error reading response body", (Throwable)e);
            }
            if (body == null) {
                body = "[empty response body]";
            }
            body = body.trim();
            if (responseCode != 201) {
                throw new IOException("Upload failed: " + HttpStatus.getStatusText((int)responseCode) + ": " + FedoraClient.replaceNewlines(body, " "));
            }
            String string = FedoraClient.replaceNewlines(body, "");
            return string;
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    private static String replaceNewlines(String in, String replaceWith) {
        return in.replaceAll("\r", replaceWith).replaceAll("\n", replaceWith);
    }

    public synchronized String getUploadURL() throws IOException {
        URL redirectURL;
        if (this.m_uploadURL != null) {
            return this.m_uploadURL;
        }
        this.m_uploadURL = this.m_baseURL + "management/upload";
        if (this.m_uploadURL.startsWith("http:") && (redirectURL = this.getRedirectURL(this.m_uploadURL)) != null) {
            this.m_uploadURL = redirectURL.toString();
        }
        return this.m_uploadURL;
    }

    public HttpInputStream get(String locator, boolean failIfNotOK) throws IOException {
        return this.get(locator, failIfNotOK, this.FOLLOW_REDIRECTS);
    }

    public HttpInputStream get(URL url, boolean failIfNotOK) throws IOException {
        return this.get(url, failIfNotOK, this.FOLLOW_REDIRECTS);
    }

    public HttpInputStream get(String locator, boolean failIfNotOK, boolean followRedirects) throws IOException {
        String url = this.getLocatorAsURL(locator);
        return this.get(new URL(url), failIfNotOK, followRedirects);
    }

    public HttpInputStream get(URL url, boolean failIfNotOK, boolean followRedirects) throws IOException {
        String urlString = url.toString();
        LOG.debug((Object)("FedoraClient is getting " + urlString));
        HttpClient client = this.getHttpClient();
        GetMethod getMethod = new GetMethod(urlString);
        getMethod.setDoAuthentication(true);
        getMethod.setFollowRedirects(followRedirects);
        HttpInputStream in = new HttpInputStream(client, (HttpMethod)getMethod, urlString);
        int status = in.getStatusCode();
        if (failIfNotOK && status != 200) {
            if (followRedirects && 300 <= status && status <= 399) {
                LOG.debug((Object)("FedoraClient is handling redirect for HTTP STATUS=" + status));
                Header hLoc = in.getResponseHeader("location");
                if (hLoc != null) {
                    LOG.debug((Object)("FedoraClient is trying redirect location: " + hLoc.getValue()));
                    return this.get(hLoc.getValue(), true, false);
                }
                try {
                    throw new IOException("Request failed [" + status + " " + in.getStatusText() + "]");
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Can't close InputStream: " + e.getMessage()));
                    }
                    throw throwable;
                }
            }
            try {
                throw new IOException("Request failed [" + in.getStatusCode() + " " + in.getStatusText() + "] : " + urlString);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    LOG.error((Object)("Can't close InputStream: " + e.getMessage()));
                }
                throw throwable;
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponseAsString(String locator, boolean failIfNotOK, boolean followRedirects) throws IOException {
        HttpInputStream in = this.get(locator, failIfNotOK, followRedirects);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuffer buffer = new StringBuffer();
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line + "\n");
                line = reader.readLine();
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception e) {
                LOG.error((Object)("Can't close InputStream: " + e.getMessage()));
            }
        }
    }

    private String getLocatorAsURL(String locator) throws IOException {
        String url;
        if (locator.startsWith(FEDORA_URI_PREFIX)) {
            url = this.m_baseURL + "get/" + locator.substring(FEDORA_URI_PREFIX.length());
        } else if (locator.startsWith("http://") || locator.startsWith("https://")) {
            url = locator;
        } else if (locator.startsWith("/")) {
            while (locator.startsWith("/")) {
                locator = locator.substring(1);
            }
            url = this.m_baseURL + locator;
        } else {
            throw new IOException("Bad locator (must start with 'info:fedora/', 'http[s]://', or '/'");
        }
        return url;
    }

    public FedoraAPIA getAPIA() throws Exception {
        return (FedoraAPIA)this.getSOAPStub(this.m_accessEndpoint);
    }

    public URL getAPIAEndpointURL() throws IOException {
        return this.m_accessEndpoint.getURL();
    }

    public FedoraAPIM getAPIM() throws Exception {
        return (FedoraAPIM)this.getSOAPStub(this.m_managementEndpoint);
    }

    public URL getAPIMEndpointURL() throws IOException {
        return this.m_managementEndpoint.getURL();
    }

    private Object getSOAPStub(SOAPEndpoint endpoint) throws Exception {
        URL url = endpoint.getURL();
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        String path = url.getPath();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        if (endpoint == this.m_accessEndpoint) {
            APIAStubFactory.SOCKET_TIMEOUT_SECONDS = this.SOCKET_TIMEOUT_SECONDS;
            return APIAStubFactory.getStubAltPath(protocol, host, port, url.getPath(), this.m_user, this.m_pass);
        }
        if (endpoint == this.m_managementEndpoint) {
            APIMStubFactory.SOCKET_TIMEOUT_SECONDS = this.SOCKET_TIMEOUT_SECONDS;
            return APIMStubFactory.getStubAltPath(protocol, host, port, url.getPath(), this.m_user, this.m_pass);
        }
        throw new Exception("Unrecognized endpoint: " + endpoint.getName());
    }

    public static String getVersion() {
        ResourceBundle bundle = ResourceBundle.getBundle("fedora.client.resources.Client");
        return bundle.getString("version");
    }

    public static List<String> getCompatibleServerVersions() {
        String clientVersion;
        ResourceBundle bundle = ResourceBundle.getBundle("fedora.client.resources.Client");
        ArrayList<String> list = new ArrayList<String>();
        String versions = bundle.getString("compatibleServerVersions");
        if (versions != null && versions.trim().length() > 0) {
            String[] va;
            for (String element : va = versions.trim().split(" ")) {
                list.add(element);
            }
        }
        if (!list.contains(clientVersion = FedoraClient.getVersion())) {
            list.add(FedoraClient.getVersion());
        }
        return list;
    }

    public String getServerVersion() throws IOException {
        if (this.m_serverVersion == null) {
            String desc = this.getResponseAsString("/describe?xml=true", true, true);
            LOG.debug((Object)("describeRepository response:\n" + desc));
            String[] parts = desc.split("<repositoryVersion>");
            if (parts.length < 2) {
                throw new IOException("Could not find repositoryVersion element in content of /describe?xml=true");
            }
            int i = parts[1].indexOf("<");
            if (i == -1) {
                throw new IOException("Could not find end of repositoryVersion element in content of /describe?xml=true");
            }
            this.m_serverVersion = parts[1].substring(0, i).trim();
            LOG.debug((Object)("Server version is " + this.m_serverVersion));
        }
        return this.m_serverVersion;
    }

    public Date getServerDate() throws IOException {
        HttpInputStream in = this.get("/describe", false, false);
        String dateString = null;
        try {
            Header header = in.getResponseHeader("Date");
            if (header == null) {
                throw new IOException("Date was not supplied in HTTP response header for " + this.m_baseURL + "describe");
            }
            dateString = header.getValue();
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date date = format.parse(dateString);
            return date;
        }
        catch (ParseException e) {
            throw new IOException("Unparsable date (" + dateString + ") in HTTP response header for " + this.m_baseURL + "describe");
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getLastModifiedDate(String locator) throws IOException {
        if (locator.startsWith(FEDORA_URI_PREFIX)) {
            String query = "select $date from <#ri> where <" + locator + "> <" + FedoraClient.VIEW.LAST_MODIFIED_DATE.uri + "> $date";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("lang", "itql");
            map.put("query", query);
            TupleIterator tuples = this.getTuples(map);
            try {
                if (tuples.hasNext()) {
                    Map row = tuples.next();
                    Literal dateLiteral = (Literal)row.get("date");
                    if (dateLiteral == null) {
                        throw new IOException("A row was returned, but it did not contain a 'date' binding");
                    }
                    Date date = DateUtility.parseDateAsUTC(dateLiteral.getLexicalForm());
                    return date;
                }
                try {
                    throw new IOException("No rows were returned");
                }
                catch (TrippiException e) {
                    throw new IOException(e.getMessage());
                }
            }
            finally {
                try {
                    tuples.close();
                }
                catch (Exception e) {}
            }
        }
        HttpClient client = this.getHttpClient();
        HeadMethod head = new HeadMethod(locator);
        head.setDoAuthentication(true);
        head.setFollowRedirects(this.FOLLOW_REDIRECTS);
        try {
            int statusCode = client.executeMethod((HttpMethod)head);
            if (statusCode != 200) {
                throw new IOException("Method failed: " + head.getStatusLine());
            }
            Header[] headers = head.getResponseHeaders();
            Header header = head.getResponseHeader("last-modified");
            if (header != null) {
                String lastModified = header.getValue();
                Date date = DateUtility.convertStringToDate(lastModified);
                return date;
            }
            Date date = new Date();
            return date;
        }
        finally {
            head.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadPolicies() throws IOException {
        InputStream in = null;
        try {
            in = this.get("/management/control?action=reloadPolicies", true, true);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                LOG.error((Object)("Can't close InputStream: " + e.getMessage()));
            }
        }
    }

    public TupleIterator getTuples(Map<String, String> params) throws IOException {
        params.put("type", "tuples");
        params.put("format", RDFFormat.SPARQL.getName());
        try {
            String url = this.getRIQueryURL(params);
            return TupleIterator.fromStream((InputStream)this.get(url, true, true), (RDFFormat)RDFFormat.SPARQL);
        }
        catch (TrippiException e) {
            throw new IOException("Error getting tuple iterator: " + e.getMessage());
        }
    }

    private String getRIQueryURL(Map<String, String> params) throws IOException {
        if (params.get("type") == null) {
            throw new IOException("'type' parameter is required");
        }
        if (params.get("lang") == null) {
            throw new IOException("'lang' parameter is required");
        }
        if (params.get("query") == null) {
            throw new IOException("'query' parameter is required");
        }
        if (params.get("format") == null) {
            throw new IOException("'format' parameter is required");
        }
        return this.m_baseURL + "risearch?" + this.encodeParameters(params);
    }

    private String encodeParameters(Map<String, String> params) {
        StringBuffer encoded = new StringBuffer();
        Iterator<String> iter = params.keySet().iterator();
        int n = 0;
        while (iter.hasNext()) {
            String name = iter.next();
            if (n > 0) {
                encoded.append("&");
            }
            ++n;
            encoded.append(name);
            encoded.append('=');
            try {
                encoded.append(URLEncoder.encode(params.get(name), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {}
        }
        return encoded.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getRedirectURL(String location) throws IOException {
        HttpInputStream in = this.get(location, false, false);
        try {
            Header h;
            if (in.getStatusCode() == 302 && (h = in.getResponseHeader("location")) != null) {
                URL uRL = new URL(h.getValue());
                return uRL;
            }
            URL uRL = null;
            return uRL;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
    }

    public class SOAPEndpoint {
        String m_name;
        URL m_url;

        public SOAPEndpoint(String name) {
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }

        public URL getURL() throws IOException {
            if (this.m_url == null) {
                if (FedoraClient.this.getServerVersion().equals("2.0")) {
                    this.m_url = new URL(FedoraClient.this.m_baseURL + this.m_name + "/soap");
                } else {
                    if (FedoraClient.this.m_baseURL.startsWith("http:")) {
                        this.m_url = FedoraClient.this.getRedirectURL("/services/" + this.m_name);
                    }
                    if (this.m_url == null) {
                        this.m_url = new URL(FedoraClient.this.m_baseURL + "services/" + this.m_name);
                    }
                }
            }
            return this.m_url;
        }
    }
}

