/*
 * Decompiled with CFR 0.152.
 */
package fedora.client;

import fedora.client.Administrator;
import fedora.client.FedoraClient;
import fedora.server.access.FedoraAPIA;
import fedora.server.management.FedoraAPIM;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class LoginDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger((String)LoginDialog.class.getName());
    private static final long serialVersionUID = 1L;
    private final JComboBox m_serverComboBox;
    private final JComboBox m_protocolComboBox;
    private final JComboBox m_usernameComboBox;
    private final JPasswordField m_passwordField;
    private String m_lastUsername = "fedoraAdmin";
    private String m_lastServer = "localhost:8080";
    private String m_lastProtocol = "http";
    private final HashMap m_usernames;
    private final HashMap m_servers = new HashMap();
    private final HashMap m_protocols = new HashMap();

    public LoginDialog() {
        super(JOptionPane.getFrameForComponent(Administrator.getDesktop()), "Login", true);
        this.m_protocols.put("http", "");
        this.m_protocols.put("https", "");
        this.m_usernames = new HashMap();
        JLabel serverLabel = new JLabel("Fedora Server");
        JLabel protocolLabel = new JLabel("Protocol");
        JLabel usernameLabel = new JLabel("Username");
        JLabel passwordLabel = new JLabel("Password");
        this.m_serverComboBox = new JComboBox();
        this.m_serverComboBox.setEditable(true);
        this.m_protocolComboBox = new JComboBox();
        this.m_protocolComboBox.setEditable(true);
        this.m_usernameComboBox = new JComboBox();
        this.m_usernameComboBox.setEditable(true);
        this.m_passwordField = new JPasswordField();
        this.setComboBoxValues();
        LoginAction loginAction = new LoginAction(this);
        JButton loginButton = new JButton(loginAction);
        loginAction.setButton(loginButton);
        loginButton.setEnabled(false);
        this.m_passwordField.getDocument().addDocumentListener(new PasswordChangeListener(loginButton, this.m_passwordField));
        this.m_passwordField.setAction(loginAction);
        JPanel inputPane = new JPanel();
        inputPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        GridBagLayout gridBag = new GridBagLayout();
        inputPane.setLayout(gridBag);
        this.addLabelValueRows(new JLabel[]{serverLabel, protocolLabel, usernameLabel, passwordLabel}, new JComponent[]{this.m_serverComboBox, this.m_protocolComboBox, this.m_usernameComboBox, this.m_passwordField}, gridBag, inputPane);
        JButton cancelButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.dispose();
            }
        });
        if (Administrator.APIA == null) {
            cancelButton.setText("Exit");
        } else {
            cancelButton.setText("Cancel");
        }
        JPanel buttonPane = new JPanel();
        buttonPane.add(loginButton);
        buttonPane.add(cancelButton);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)inputPane, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent evt) {
                LoginDialog.this.m_passwordField.requestFocus();
            }
        });
        this.pack();
        this.setLocation(Administrator.INSTANCE.getCenteredPos(this.getWidth(), this.getHeight()));
        this.setVisible(true);
    }

    public void saveProperties() {
        try {
            String name;
            Properties props = new Properties();
            props.setProperty("lastServer", this.m_lastServer);
            props.setProperty("lastProtocol", this.m_lastProtocol);
            props.setProperty("lastUsername", this.m_lastUsername);
            Iterator iter = this.m_servers.keySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                name = (String)iter.next();
                props.setProperty("server" + i, name);
                ++i;
            }
            iter = this.m_protocols.keySet().iterator();
            i = 0;
            while (iter.hasNext()) {
                name = (String)iter.next();
                props.setProperty("protocol" + i, name);
                ++i;
            }
            iter = this.m_usernames.keySet().iterator();
            i = 0;
            while (iter.hasNext()) {
                name = (String)iter.next();
                props.setProperty("username" + i, name);
                ++i;
            }
            props.store(new FileOutputStream(new File(Administrator.BASE_DIR, "fedora-admin.properties")), "Fedora Administrator saved settings");
        }
        catch (Exception e) {
            System.err.println("Warning: Error writing properties: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private void setComboBoxValues() {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(new File(Administrator.BASE_DIR, "fedora-admin.properties")));
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String prop = (String)names.nextElement();
                if (prop.equals("lastServer")) {
                    this.m_lastServer = props.getProperty(prop);
                    continue;
                }
                if (prop.equals("lastProtocol")) {
                    this.m_lastProtocol = props.getProperty(prop);
                    continue;
                }
                if (prop.equals("lastUsername")) {
                    this.m_lastUsername = props.getProperty(prop);
                    continue;
                }
                if (prop.startsWith("server")) {
                    this.m_servers.put(props.getProperty(prop), "");
                    continue;
                }
                if (prop.startsWith("protocol")) {
                    this.m_protocols.put(props.getProperty(prop), "");
                    continue;
                }
                if (!prop.startsWith("username")) continue;
                this.m_usernames.put(props.getProperty(prop), "");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.m_serverComboBox.addItem(this.m_lastServer);
        for (String a : this.m_servers.keySet()) {
            if (a.equals(this.m_lastServer)) continue;
            this.m_serverComboBox.addItem(a);
        }
        this.m_servers.put(this.m_lastServer, "");
        this.m_protocolComboBox.addItem(this.m_lastProtocol);
        for (String a : this.m_protocols.keySet()) {
            if (a.equals(this.m_lastProtocol)) continue;
            this.m_protocolComboBox.addItem(a);
        }
        this.m_protocols.put(this.m_lastProtocol, "");
        this.m_usernameComboBox.addItem(this.m_lastUsername);
        for (String a : this.m_usernames.keySet()) {
            if (a.equals(this.m_lastUsername)) continue;
            this.m_usernameComboBox.addItem(a);
        }
        this.m_usernames.put(this.m_lastUsername, "");
        Dimension newSize = new Dimension(this.m_serverComboBox.getPreferredSize().width + 20, this.m_serverComboBox.getPreferredSize().height);
        this.m_serverComboBox.setPreferredSize(newSize);
        this.m_protocolComboBox.setPreferredSize(newSize);
        this.m_usernameComboBox.setPreferredSize(newSize);
        this.m_passwordField.setPreferredSize(newSize);
    }

    public void addLabelValueRows(JLabel[] labels, JComponent[] values, GridBagLayout gridBag, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 6, 6, 6);
        for (int i = 0; i < labels.length; ++i) {
            c.anchor = 13;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            gridBag.setConstraints(labels[i], c);
            container.add(labels[i]);
            c.gridwidth = 0;
            if (!(values[i] instanceof JComboBox)) {
                c.fill = 2;
            } else {
                c.anchor = 17;
            }
            c.weightx = 1.0;
            gridBag.setConstraints(values[i], c);
            container.add(values[i]);
        }
    }

    public static void tryLogin(String protocol, String host, int port, String user, String pass) throws Exception {
        try {
            LOG.info((Object)"Logging in...");
            String baseURL = protocol + "://" + host + ":" + port + "/fedora";
            FedoraClient fc = new FedoraClient(baseURL, user, pass);
            String serverVersion = fc.getServerVersion();
            List<String> compatibleVersions = FedoraClient.getCompatibleServerVersions();
            if (!compatibleVersions.contains(serverVersion)) {
                StringBuffer endText = new StringBuffer();
                if (compatibleVersions.size() == 1) {
                    endText.append("version " + compatibleVersions.get(0));
                } else {
                    endText.append("versions ");
                    for (int i = 0; i < compatibleVersions.size(); ++i) {
                        if (i > 0) {
                            if (i == compatibleVersions.size() - 1) {
                                if (i > 1) {
                                    endText.append(",");
                                }
                                endText.append(" and ");
                            } else {
                                endText.append(", ");
                            }
                        }
                        endText.append(compatibleVersions.get(i));
                    }
                }
                throw new IOException("Server is version " + serverVersion + ", but this client only works with " + endText.toString());
            }
            Administrator.APIA = fc.getAPIA();
            Administrator.APIM = fc.getAPIM();
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("Unauthorized") != -1 || e.getMessage().indexOf("Unrecognized") != -1) {
                throw new IOException("Bad username or password.");
            }
            if (e.getMessage() != null) {
                throw new IOException(e.getClass().getName() + ": " + e.getMessage());
            }
            throw new IOException(e.getClass().getName());
        }
    }

    public class LoginAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        LoginDialog m_loginDialog;
        JButton m_button;

        public LoginAction(LoginDialog loginDialog2) {
            super("Login");
            this.m_loginDialog = loginDialog2;
        }

        public void setButton(JButton button) {
            this.m_button = button;
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.m_button.isEnabled()) {
                FedoraAPIA oldAPIA = Administrator.APIA;
                FedoraAPIM oldAPIM = Administrator.APIM;
                try {
                    String hostPort = (String)LoginDialog.this.m_serverComboBox.getSelectedItem();
                    int colonPos = hostPort.indexOf(":");
                    if (colonPos == -1) {
                        throw new IOException("Server must be specified as host:port");
                    }
                    String[] s = hostPort.split(":");
                    String host = s[0];
                    if (host.length() == 0) {
                        throw new IOException("No server name provided.");
                    }
                    int port = 0;
                    try {
                        port = Integer.parseInt(s[1]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IOException("Server port must be an integer.");
                    }
                    String protocol = (String)LoginDialog.this.m_protocolComboBox.getSelectedItem();
                    if (protocol.equals("")) {
                        throw new IOException("No protocol provided.");
                    }
                    String username = (String)LoginDialog.this.m_usernameComboBox.getSelectedItem();
                    if (username.equals("")) {
                        throw new IOException("No username provided.");
                    }
                    String pass = new String(LoginDialog.this.m_passwordField.getPassword());
                    LoginDialog.tryLogin(protocol, host, port, username, pass);
                    LoginDialog.this.m_lastServer = host + ":" + port;
                    LoginDialog.this.m_lastProtocol = protocol;
                    LoginDialog.this.m_lastUsername = username;
                    this.m_loginDialog.saveProperties();
                    Administrator.INSTANCE.setLoginInfo(protocol, host, port, username, pass);
                    this.m_loginDialog.dispose();
                }
                catch (Exception e) {
                    String msg = e.getMessage();
                    Administrator.showErrorDialog(this.m_loginDialog, "Login Error", msg, e);
                    Administrator.APIA = oldAPIA;
                    Administrator.APIM = oldAPIM;
                }
            }
        }
    }

    public class PasswordChangeListener
    implements DocumentListener {
        private final JButton m_loginButton;
        private final JPasswordField m_passField;

        public PasswordChangeListener(JButton loginButton, JPasswordField pf) {
            this.m_loginButton = loginButton;
            this.m_passField = pf;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dataChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dataChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dataChanged();
        }

        public void dataChanged() {
            if (this.m_passField.getPassword().length == 0) {
                this.m_loginButton.setEnabled(false);
            } else {
                this.m_loginButton.setEnabled(true);
            }
        }
    }
}

