/*
 * Decompiled with CFR 0.152.
 */
package fedora.client;

import fedora.client.Administrator;
import fedora.client.actions.ViewObject;
import fedora.client.utility.ingest.AutoIngestor;
import fedora.common.Constants;
import fedora.server.utilities.StreamUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayInputStream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class NewObjectDialog
extends JDialog
implements Constants,
ItemListener {
    private static final long serialVersionUID = 1L;
    private final JTextField m_labelField;
    private final JCheckBox m_customPIDCheckBox;
    private final JTextField m_customPIDField;
    private final boolean isContentModel;

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            this.m_customPIDField.setEditable(false);
        } else if (e.getStateChange() == 1) {
            this.m_customPIDField.setEditable(true);
        }
    }

    public NewObjectDialog(boolean isContentModel) {
        super(JOptionPane.getFrameForComponent(Administrator.getDesktop()), isContentModel ? "New Content Model" : "New Object", true);
        this.isContentModel = isContentModel;
        JPanel inputPane = new JPanel();
        inputPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        GridBagLayout gridBag = new GridBagLayout();
        inputPane.setLayout(gridBag);
        JLabel labelLabel = new JLabel("Label");
        this.m_customPIDCheckBox = new JCheckBox("Use Custom PID");
        this.m_customPIDCheckBox.addItemListener(this);
        this.m_labelField = new JTextField("Enter a one-line description of the object.");
        this.m_customPIDField = new JTextField();
        this.m_customPIDField.setEditable(false);
        this.addLabelValueRows(new JComponent[]{labelLabel, this.m_customPIDCheckBox}, new JComponent[]{this.m_labelField, this.m_customPIDField}, gridBag, inputPane);
        CreateAction createAction = new CreateAction();
        CreateListener createListener = new CreateListener(createAction);
        JButton okButton = new JButton(createAction);
        okButton.registerKeyboardAction(createListener, KeyStroke.getKeyStroke(10, 0, false), 2);
        okButton.setText("Create");
        JButton cancelButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                NewObjectDialog.this.dispose();
            }
        });
        cancelButton.setText("Cancel");
        JPanel buttonPane = new JPanel();
        buttonPane.add(okButton);
        buttonPane.add(cancelButton);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)inputPane, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.pack();
        this.setLocation(Administrator.INSTANCE.getCenteredPos(this.getWidth(), this.getHeight()));
        this.setVisible(true);
    }

    public void addLabelValueRows(JComponent[] labels, JComponent[] values, GridBagLayout gridBag, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 6, 6, 6);
        for (int i = 0; i < labels.length; ++i) {
            c.anchor = 13;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            gridBag.setConstraints(labels[i], c);
            container.add(labels[i]);
            c.gridwidth = 0;
            if (!(values[i] instanceof JComboBox)) {
                c.fill = 2;
            } else {
                c.anchor = 17;
            }
            c.weightx = 1.0;
            gridBag.setConstraints(values[i], c);
            container.add(values[i]);
        }
    }

    public class CreateListener
    implements ActionListener {
        private final CreateAction m_createAction;

        public CreateListener(CreateAction createAction) {
            this.m_createAction = createAction;
        }

        public void actionPerformed(ActionEvent e) {
            this.m_createAction.actionPerformed(e);
        }
    }

    public class CreateAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent evt) {
            try {
                String pid = null;
                String label = NewObjectDialog.this.m_labelField.getText();
                boolean ok = true;
                if (NewObjectDialog.this.m_labelField.getText().equals("")) {
                    JOptionPane.showMessageDialog(Administrator.getDesktop(), "Label must be non-empty", "Error", 0);
                    ok = false;
                }
                if (NewObjectDialog.this.m_customPIDCheckBox.isSelected()) {
                    pid = NewObjectDialog.this.m_customPIDField.getText();
                    if (NewObjectDialog.this.m_customPIDField.getText().indexOf(":") < 1) {
                        JOptionPane.showMessageDialog(Administrator.getDesktop(), "Custom PID should be of the form \"namespace:alphaNumericName\"", "Error", 0);
                        ok = false;
                    }
                }
                if (ok) {
                    NewObjectDialog.this.dispose();
                    StringBuffer xml = new StringBuffer();
                    xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    xml.append("<foxml:digitalObject xmlns:xsi=\"" + Constants.XSI.uri + "\"\n");
                    xml.append("           xmlns:foxml=\"" + Constants.FOXML.uri + "\"\n");
                    xml.append("           xsi:schemaLocation=\"" + Constants.FOXML.uri + " " + Constants.FOXML1_1.xsdLocation + "\"");
                    xml.append("\n           VERSION=\"1.1\"\n");
                    if (pid != null) {
                        xml.append("\n           PID=\"" + StreamUtility.enc(pid) + "\">\n");
                    } else {
                        xml.append(">\n");
                    }
                    xml.append("  <foxml:objectProperties>\n");
                    xml.append("    <foxml:property NAME=\"" + Constants.MODEL.LABEL.uri + "\" VALUE=\"" + StreamUtility.enc(label) + "\"/>\n");
                    xml.append("    <foxml:property NAME=\"" + Constants.MODEL.OWNER.uri + "\" VALUE=\"" + Administrator.getUser() + "\"/>");
                    xml.append("  </foxml:objectProperties>\n");
                    xml.append("</foxml:digitalObject>");
                    String objXML = xml.toString();
                    ByteArrayInputStream in = new ByteArrayInputStream(objXML.getBytes("UTF-8"));
                    String newPID = AutoIngestor.ingestAndCommit(Administrator.APIA, Administrator.APIM, in, Constants.FOXML1_1.uri, "Created with Admin GUI \"New Object\" command");
                    new ViewObject(newPID).launch();
                }
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.getClass().getName();
                }
                Administrator.showErrorDialog(Administrator.getDesktop(), "Error Creating Object", msg, e);
            }
        }
    }
}

