/*
 * Decompiled with CFR 0.152.
 */
package fedora.client;

import fedora.client.Administrator;
import fedora.common.Constants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ObjectFormatDialog
extends JDialog
implements ActionListener,
Constants {
    private static final long serialVersionUID = 1L;
    private final JRadioButton foxml11Button;
    private final JRadioButton foxml10Button;
    private final JRadioButton metsfButton;
    private final JRadioButton atomButton;
    private final ButtonGroup fmt_buttonGroup = new ButtonGroup();
    private final JLabel warningLabel;
    protected String fmt_chosen;

    public ObjectFormatDialog(String title) {
        super(JOptionPane.getFrameForComponent(Administrator.getDesktop()), title, true);
        this.setSize(350, 320);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                ObjectFormatDialog.this.fmt_chosen = null;
                ObjectFormatDialog.this.dispose();
            }
        });
        JPanel textPane = new JPanel();
        textPane.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 12));
        String warningText = "<html>Select the XML format of files to be ingested.<br>Files not in FOXML 1.1 format will be updated<br>to FOXML 1.1 on ingest. This conversion process<br>may not retain all information available in the<br>original format.</html>";
        this.warningLabel = new JLabel(warningText);
        this.warningLabel.setHorizontalTextPosition(0);
        textPane.add(this.warningLabel);
        JPanel inputPane = new JPanel();
        inputPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
        inputPane.setLayout(new GridLayout(0, 1));
        this.foxml11Button = new JRadioButton("FOXML (Fedora Object XML) version 1.1", true);
        this.foxml11Button.setActionCommand(ObjectFormatDialog.FOXML1_1.uri);
        this.foxml11Button.addActionListener(this);
        this.foxml10Button = new JRadioButton("FOXML (Fedora Object XML) version 1.0", true);
        this.foxml10Button.setActionCommand(ObjectFormatDialog.FOXML1_0.uri);
        this.foxml10Button.addActionListener(this);
        this.metsfButton = new JRadioButton("METS (Fedora METS Extension)", false);
        this.metsfButton.setActionCommand(ObjectFormatDialog.METS_EXT1_1.uri);
        this.metsfButton.addActionListener(this);
        this.atomButton = new JRadioButton("Atom (Fedora Atom)", false);
        this.atomButton.setActionCommand(ObjectFormatDialog.ATOM1_0.uri);
        this.atomButton.addActionListener(this);
        this.fmt_buttonGroup.add(this.foxml11Button);
        this.fmt_buttonGroup.add(this.foxml10Button);
        this.fmt_buttonGroup.add(this.metsfButton);
        this.fmt_buttonGroup.add(this.atomButton);
        this.fmt_chosen = ObjectFormatDialog.FOXML1_1.uri;
        inputPane.add(this.foxml11Button);
        inputPane.add(this.foxml10Button);
        inputPane.add(this.metsfButton);
        inputPane.add(this.atomButton);
        JButton okButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                ObjectFormatDialog.this.dispose();
            }
        });
        okButton.setText("OK");
        JButton cancelButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                ObjectFormatDialog.this.fmt_chosen = null;
                ObjectFormatDialog.this.dispose();
            }
        });
        cancelButton.setText("Cancel");
        JPanel buttonPane = new JPanel();
        buttonPane.add(okButton);
        buttonPane.add(cancelButton);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)textPane, "North");
        contentPane.add((Component)inputPane, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.setLocation(Administrator.INSTANCE.getCenteredPos(this.getWidth(), this.getHeight()));
        this.setVisible(true);
    }

    public String getSelection() {
        return this.fmt_chosen;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.foxml11Button.isSelected()) {
            this.fmt_chosen = ObjectFormatDialog.FOXML1_1.uri;
        } else if (this.foxml10Button.isSelected()) {
            this.fmt_chosen = ObjectFormatDialog.FOXML1_0.uri;
        } else if (this.metsfButton.isSelected()) {
            this.fmt_chosen = ObjectFormatDialog.METS_EXT1_1.uri;
        } else if (this.atomButton.isSelected()) {
            this.fmt_chosen = ObjectFormatDialog.ATOM1_0.uri;
        }
    }
}

