/*
 * Decompiled with CFR 0.152.
 */
package fedora.client;

import fedora.client.Administrator;
import fedora.client.FedoraClient;
import fedora.client.SwingWorker;
import fedora.server.utilities.StreamUtility;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.log4j.Logger;

public class Uploader {
    private final MultiThreadedHttpConnectionManager m_cManager = new MultiThreadedHttpConnectionManager();
    private final String m_uploadURL;
    private final UsernamePasswordCredentials m_creds;
    private final FedoraClient fc;
    private static final Logger logger = Logger.getLogger((String)FedoraClient.class.getName());

    public Uploader(String host, int port, String user, String pass) throws IOException {
        this.m_uploadURL = Administrator.getProtocol() + "://" + host + ":" + port + "/fedora/management/upload";
        this.m_creds = new UsernamePasswordCredentials(user, pass);
        String baseURL = Administrator.getProtocol() + "://" + host + ":" + port + "/fedora";
        this.fc = new FedoraClient(baseURL, user, pass);
    }

    public Uploader(String protocol, String host, int port, String user, String pass) throws IOException {
        this.m_uploadURL = protocol + "://" + host + ":" + port + "/fedora/management/upload";
        this.m_creds = new UsernamePasswordCredentials(user, pass);
        String baseURL = protocol + "://" + host + ":" + port + "/fedora";
        this.fc = new FedoraClient(baseURL, user, pass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(InputStream in) throws IOException {
        File tempFile = File.createTempFile("fedora-upload-", null);
        FileOutputStream out = new FileOutputStream(tempFile);
        try {
            StreamUtility.pipeStream(in, out, 8192);
            String string = this.upload(tempFile);
            return string;
        }
        finally {
            in.close();
            out.close();
            if (!tempFile.delete()) {
                System.err.println("WARNING: Could not remove temporary file: " + tempFile.getName());
                tempFile.deleteOnExit();
            }
        }
    }

    public String upload(File file) throws IOException {
        if (Administrator.INSTANCE == null) {
            return this.fc.uploadFile(file);
        }
        String msg = "Uploading " + file.length() + " bytes to " + this.fc.getUploadURL();
        Dimension d = Administrator.PROGRESS.getSize();
        Administrator.PROGRESS.setString(msg);
        Administrator.PROGRESS.setValue(100);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        HashMap<String, Object> PARMS = new HashMap<String, Object>();
        PARMS.put("fc", this.fc);
        PARMS.put("file", file);
        SwingWorker worker = new SwingWorker(PARMS){

            public Object construct() {
                try {
                    FedoraClient fc = (FedoraClient)this.parms.get("fc");
                    File file = (File)this.parms.get("file");
                    return fc.uploadFile(file);
                }
                catch (IOException e) {
                    this.thrownException = e;
                    return "";
                }
            }
        };
        worker.start();
        int ms = 200;
        while (!worker.done) {
            try {
                Administrator.PROGRESS.setValue(ms);
                Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
                Thread.sleep(100L);
                if ((ms += 100) < 2000) continue;
                ms = 200;
            }
            catch (InterruptedException ie) {}
        }
        Administrator.PROGRESS.setValue(2000);
        Administrator.PROGRESS.paintImmediately(0, 0, (int)d.getWidth() - 1, (int)d.getHeight() - 1);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (worker.thrownException != null) {
            throw (IOException)worker.thrownException;
        }
        return (String)worker.getValue();
    }

    public static void main(String[] args) {
        try {
            if (args.length == 5) {
                Uploader uploader = new Uploader(args[0], Integer.parseInt(args[1]), args[2], args[3]);
                File f = new File(args[4]);
                System.out.println(uploader.upload(new FileInputStream(f)));
                System.out.println(uploader.upload(f));
                uploader = new Uploader(args[0], Integer.parseInt(args[1]), args[2], args[3] + "test");
                System.out.println(uploader.upload(f));
            } else {
                System.err.println("Usage: Uploader host port user pass file");
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
        }
    }
}

