/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.actions;

import fedora.client.Administrator;
import fedora.client.utility.export.AutoExporter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ViewObjectXML
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private Set m_pids;
    private boolean m_prompt;
    private JPanel m_viewPane;

    public ViewObjectXML() {
        super("View Object XML...");
        this.m_prompt = true;
    }

    public ViewObjectXML(String pid) {
        super("View Object XML");
        this.m_pids = new HashSet();
        this.m_pids.add(pid);
    }

    public ViewObjectXML(String pid, JPanel viewPane) {
        super("View Object XML");
        this.m_pids = new HashSet();
        this.m_pids.add(pid);
        this.m_viewPane = viewPane;
    }

    public ViewObjectXML(Set pids) {
        super("View Objects XML");
        this.m_pids = pids;
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.m_prompt) {
            String pid = JOptionPane.showInputDialog("Enter the PID.");
            if (pid == null) {
                return;
            }
            this.m_pids = new HashSet();
            this.m_pids.add(pid);
        }
        AutoExporter exporter = null;
        try {
            exporter = new AutoExporter(Administrator.APIA, Administrator.APIM);
        }
        catch (Exception e) {
            Administrator.showErrorDialog(Administrator.getDesktop(), "View Failure", e.getClass().getName() + ": " + e.getMessage(), e);
        }
        if (exporter != null) {
            Iterator pidIter = this.m_pids.iterator();
            while (pidIter.hasNext()) {
                try {
                    String pid = (String)pidIter.next();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    exporter.getObjectXML(pid, out);
                    JTextArea textEditor = new JTextArea();
                    ((JComponent)textEditor).setFont(new Font("monospaced", 0, 12));
                    textEditor.setText(new String(out.toString("UTF-8")));
                    textEditor.setCaretPosition(0);
                    textEditor.setEditable(false);
                    if (this.m_viewPane == null) {
                        JInternalFrame viewFrame = new JInternalFrame("Viewing " + pid, true, true, true, true);
                        viewFrame.setFrameIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/standard/general/Edit16.gif")));
                        viewFrame.getContentPane().add(new JScrollPane(textEditor));
                        viewFrame.setSize(720, 520);
                        viewFrame.setVisible(true);
                        Administrator.getDesktop().add(viewFrame);
                        try {
                            viewFrame.setSelected(true);
                        }
                        catch (PropertyVetoException pve) {}
                        continue;
                    }
                    this.m_viewPane.removeAll();
                    this.m_viewPane.setLayout(new BorderLayout());
                    this.m_viewPane.add((Component)new JScrollPane(textEditor), "Center");
                    this.m_viewPane.validate();
                }
                catch (Exception e) {
                    Administrator.showErrorDialog(Administrator.getDesktop(), "View Failure", e.getClass().getName() + ": " + e.getMessage(), e);
                }
            }
        }
    }
}

