/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.batch;

import fedora.client.batch.BatchTool;
import fedora.common.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

class BatchAdditions
implements Constants {
    static final String FS = File.separator;
    private final Properties dataProperties;
    private final Properties metadataProperties;
    private boolean mediaFileContainsUrl = false;
    private String mediaPath = null;
    private String keyPath = null;
    private String metadataPath = null;
    private String stringPrefix = null;
    private String additionsPath = null;
    private String objectNameSpace = null;
    private String namespaceDeclarations = null;
    private int startObject = 0;
    private static final Hashtable metadataCategories = new Hashtable();
    String[] datastreams = null;
    String[] objectnames = null;
    static final int BUFFERLENGTH = 1024;
    private boolean good2go = false;

    private static final String getPath(File file) {
        String temp;
        try {
            temp = file.getCanonicalPath();
        }
        catch (Exception eCaughtFiles) {
            temp = "";
        }
        return temp;
    }

    private static final String getContents(String filePrefix) {
        String contents = null;
        try {
            long lFileLength;
            File file = new File(filePrefix);
            FileInputStream fileInputStream = null;
            if (!file.exists()) {
                throw new Exception("x");
            }
            if (!file.canRead()) {
                throw new Exception("x");
            }
            try {
                lFileLength = file.length();
            }
            catch (Exception eCaughtStatFile) {
                throw new Exception("file " + BatchAdditions.getPath(file) + "couldn't be statted for reading");
            }
            if (lFileLength > Integer.MAX_VALUE) {
                throw new Exception("file " + BatchAdditions.getPath(file) + "too large for reading");
            }
            fileInputStream = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            StringBuffer sbuffer = new StringBuffer();
            while ((bytesRead = fileInputStream.read(buffer, 0, 1024)) != -1) {
                String temp = new String(buffer, 0, bytesRead);
                sbuffer.append(temp);
            }
            contents = new String(sbuffer);
        }
        catch (Exception e) {
            System.err.println("exception in content read " + e.getMessage());
        }
        return contents;
    }

    private static final void packageMetadata(PrintStream out, Properties metadataProperties, String context, String objectname, int indents) {
        Enumeration<?> elementNames = metadataProperties.propertyNames();
        String tabs = "STRING NOT ASSIGNED TO";
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < indents; ++i) {
            temp.append("\t");
        }
        tabs = new String(temp);
        if (elementNames.hasMoreElements()) {
            out.println(tabs + "<metadata>");
            while (elementNames.hasMoreElements()) {
                String metadata;
                String elementName = (String)elementNames.nextElement();
                String directoryName = metadataProperties.getProperty(elementName);
                String parentPath = context + directoryName;
                String fileName = BatchAdditions.getFilename(parentPath, objectname);
                if (fileName == null || fileName.equals("") || (metadata = BatchAdditions.getContents(parentPath + FS + fileName)) == null || metadata.equals("")) continue;
                out.println(tabs + "\t<metadata id=\"" + elementName + "\">");
                out.println(metadata);
                out.println(tabs + "\t</metadata>");
            }
            out.println(tabs + "</metadata>");
        }
    }

    protected String getHref(String webPrefix, String path) {
        return webPrefix + "/" + path;
    }

    static String getFilename(String parentPath, String objectName) {
        String filename = null;
        File temp = new File(parentPath);
        if (temp.exists()) {
            if (!temp.isDirectory()) {
                System.err.println("bad directory structure " + parentPath + " " + objectName);
            } else {
                String[] filenames = new File(parentPath).list();
                int nFound = 0;
                int iFound = -1;
                for (int i = 0; i < filenames.length; ++i) {
                    if (!filenames[i].startsWith(objectName)) continue;
                    ++nFound;
                    iFound = i;
                }
                if (nFound == 1) {
                    filename = filenames[iFound];
                }
            }
        }
        return filename;
    }

    BatchAdditions(Properties optValues, Properties dataProperties, Properties metadataProperties) throws Exception {
        this.dataProperties = dataProperties;
        this.metadataProperties = metadataProperties;
        String temp = optValues.getProperty("initial-pid");
        String[] parts = temp.split(":");
        this.objectNameSpace = parts[0];
        String startObjectAsString = parts[1];
        String urlPath = optValues.getProperty("url");
        String dataPath = optValues.getProperty("data");
        this.stringPrefix = optValues.getProperty("url-prefix");
        this.keyPath = optValues.getProperty("key-path");
        this.namespaceDeclarations = optValues.getProperty("namespace-declarations");
        this.metadataPath = optValues.getProperty("metadata");
        this.additionsPath = optValues.getProperty("specifics");
        if (!BatchTool.argOK(this.namespaceDeclarations)) {
            System.err.println("namespaceDeclarations required");
            throw new Exception();
        }
        if (!BatchTool.argOK(this.objectNameSpace)) {
            System.err.println("objectNameSpace required");
            throw new Exception();
        }
        if (!BatchTool.argOK(startObjectAsString)) {
            System.err.println("startObject required");
            throw new Exception();
        }
        try {
            this.startObject = Integer.parseInt(startObjectAsString);
        }
        catch (Exception e) {
            System.err.println("startObject must be integer");
            throw new Exception();
        }
        if (!BatchTool.argOK(this.keyPath)) {
            System.err.println("keyPath required");
            throw new Exception();
        }
        if (!BatchTool.argOK(this.metadataPath)) {
            System.err.println("metadataPath required");
            throw new Exception();
        }
        if (!BatchTool.argOK(this.additionsPath)) {
            System.err.println("additionsPath required");
            throw new Exception();
        }
        if (BatchTool.argOK(urlPath)) {
            if (BatchTool.argOK(dataPath)) {
                System.err.println("use either data or url path -- both provided");
                throw new Exception();
            }
            this.mediaPath = urlPath;
            this.mediaFileContainsUrl = true;
        } else if (BatchTool.argOK(dataPath)) {
            this.mediaPath = dataPath;
            this.mediaFileContainsUrl = false;
        } else {
            System.err.println("use either data or url path -- neither provided");
            throw new Exception();
        }
        if (!BatchTool.argOK(this.stringPrefix)) {
            System.err.println("stringprefix required");
            throw new Exception();
        }
    }

    final void prep() throws Exception {
        File mediaDirectory = new File(this.mediaPath);
        File[] datastreamDirectories = mediaDirectory.listFiles();
        this.datastreams = new String[datastreamDirectories.length];
        for (int i = 0; i < datastreamDirectories.length; ++i) {
            if (!datastreamDirectories[i].isDirectory()) continue;
            String directoryName = datastreamDirectories[i].getName();
            if (metadataCategories.get(directoryName) != null) {
                throw new Exception();
            }
            this.datastreams[i] = datastreamDirectories[i].getName();
        }
        File[] files = null;
        File keyDirectory = new File(this.keyPath);
        files = keyDirectory.listFiles();
        this.objectnames = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            String objectname = null;
            String filename = files[i].getName();
            int j = filename.lastIndexOf(46);
            this.objectnames[i] = objectname = j >= 0 ? filename.substring(0, j) : filename;
        }
        this.good2go = true;
    }

    final void process() throws Exception {
        if (this.good2go) {
            int object = this.startObject;
            for (String objectname : this.objectnames) {
                String objid = this.objectNameSpace + ":" + object++;
                PrintStream out = new PrintStream(new FileOutputStream(this.additionsPath + FS + objectname));
                out.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                out.print("<input OBJID=\"" + objid + "\"");
                out.println(" xmlns:METS=\"" + BatchAdditions.METS.uri + "\" " + this.namespaceDeclarations + " >");
                BatchAdditions.packageMetadata(out, this.metadataProperties, this.metadataPath + FS, objectname, 1);
                out.println("\t<datastreams>");
                Enumeration<?> ddatastreams = this.dataProperties.propertyNames();
                while (ddatastreams.hasMoreElements()) {
                    String ndatastream = (String)ddatastreams.nextElement();
                    String datastream = this.dataProperties.getProperty(ndatastream);
                    String href = this.mediaFileContainsUrl ? BatchAdditions.getContents(this.mediaPath + FS + datastream + FS + objectname) : this.getHref(this.stringPrefix, datastream + "/" + BatchAdditions.getFilename(this.mediaPath + "/" + datastream, objectname));
                    out.println("\t\t<datastream id=\"" + ndatastream + "\" href=\"" + href + "\">");
                    out.println("\t\t</datastream>");
                }
                out.println("\t</datastreams>");
                out.println("</input>");
                out.close();
            }
        }
    }

    public static final void main(String[] args) {
        try {
            Properties miscProperties = new Properties();
            Properties datastreamProperties = new Properties();
            Properties metadataProperties = new Properties();
            miscProperties.load(new FileInputStream("c:\\batchdemo\\batchtool.properties"));
            datastreamProperties.load(new FileInputStream("c:\\batchdemo\\datastream.properties"));
            metadataProperties.load(new FileInputStream("c:\\batchdemo\\metadata.properties"));
            BatchAdditions batchAdditions = new BatchAdditions(miscProperties, datastreamProperties, metadataProperties);
            batchAdditions.prep();
            batchAdditions.process();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

