/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.batch;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BatchModifyXMLErrorHandler
implements ErrorHandler {
    public void warning(SAXParseException e) throws SAXException {
        System.err.print("BatchModifyXMLErrorHandler detected SAX WARNING: ");
        this.printPubID(e);
        this.printMsg(e);
    }

    public void error(SAXParseException e) throws SAXException {
        System.err.print("BatchModifyXMLErrorHandler detected SAX ERROR.  Re-throwing SAXException.");
        throw new SAXException(this.formatParseExceptionMsg(e));
    }

    public void fatalError(SAXParseException e) throws SAXException {
        System.err.print("BatchModifyXMLErrorHandler detected SAX FATAL ERROR.  Re-throwing SAXException.");
        throw new SAXException(this.formatParseExceptionMsg(e));
    }

    private void printPubID(SAXParseException e) {
        if (e.getPublicId() != null) {
            System.err.print(e.getPublicId() + " ");
        }
        if (e.getLineNumber() != -1) {
            System.err.print("line: " + e.getLineNumber() + " ");
        }
    }

    private void printMsg(SAXParseException e) {
        System.err.println(e.getClass().getName() + " - " + (e.getMessage() == null ? "(no detail provided)" : e.getMessage()));
    }

    private String formatParseExceptionMsg(SAXParseException spe) {
        String systemId = spe.getSystemId();
        if (systemId == null) {
            systemId = "null";
        }
        String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
        return info;
    }
}

