/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.console.management;

import fedora.client.Administrator;
import fedora.client.console.Console;
import fedora.client.console.ConsoleCommand;
import fedora.client.console.ConsoleSendButtonListener;
import fedora.client.console.ServiceConsoleCommandFactory;
import fedora.server.management.FedoraAPIMServiceLocator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.xml.rpc.ServiceException;

public class ManagementConsole
extends JInternalFrame
implements Console {
    private static final long serialVersionUID = 1L;
    private final Administrator m_mainFrame;
    private final FedoraAPIMServiceLocator m_locator;
    private final JTextArea m_outputArea;
    private final JTextField m_hostTextField;
    private final JTextField m_portTextField;
    private boolean m_isBusy;

    public ManagementConsole(Administrator mainFrame) {
        super("Management Console", true, true, true, true);
        this.m_mainFrame = mainFrame;
        this.m_locator = new FedoraAPIMServiceLocator(Administrator.getUser(), Administrator.getPass());
        this.m_outputArea = new JTextArea();
        this.m_outputArea.setFont(new Font("Serif", 0, 16));
        this.m_outputArea.setEditable(false);
        JScrollPane outputScrollPane = new JScrollPane(this.m_outputArea);
        outputScrollPane.setVerticalScrollBarPolicy(22);
        outputScrollPane.setPreferredSize(new Dimension(250, 250));
        outputScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BorderLayout());
        JPanel hostPortPanel = new JPanel();
        hostPortPanel.setLayout(new BorderLayout());
        JPanel hostPanel = new JPanel();
        hostPanel.setLayout(new BorderLayout());
        hostPanel.add((Component)new JLabel("Host : "), "West");
        this.m_hostTextField = new JTextField(Administrator.getHost(), 13);
        hostPanel.add((Component)this.m_hostTextField, "East");
        JPanel portPanel = new JPanel();
        portPanel.setLayout(new BorderLayout());
        portPanel.add((Component)new JLabel("  Port : "), "West");
        this.m_portTextField = new JTextField(new Integer(Administrator.getPort()).toString(), 4);
        portPanel.add((Component)this.m_portTextField, "East");
        hostPortPanel.add((Component)hostPanel, "West");
        hostPortPanel.add((Component)portPanel, "East");
        JPanel commandPanel = new JPanel();
        commandPanel.setLayout(new BorderLayout());
        commandPanel.add((Component)new JLabel("  Command : "), "West");
        ConsoleCommand[] commands = null;
        try {
            commands = ServiceConsoleCommandFactory.getConsoleCommands(Class.forName("fedora.server.management.FedoraAPIM"), null);
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Could not find server management interface, FedoraAPIM.");
            System.exit(0);
        }
        JComboBox<ConsoleCommand> commandComboBox = new JComboBox<ConsoleCommand>(commands);
        commandComboBox.setSelectedIndex(0);
        commandPanel.add(commandComboBox);
        JButton sendButton = new JButton(" Send.. ");
        sendButton.addActionListener(new ConsoleSendButtonListener(commandComboBox.getModel(), this.m_mainFrame, this));
        commandPanel.add((Component)sendButton, "East");
        controlPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        controlPanel.add((Component)hostPortPanel, "West");
        controlPanel.add(commandPanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)controlPanel, "North");
        this.getContentPane().add(outputScrollPane);
        this.setFrameIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/standard/development/Host16.gif")));
        this.pack();
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (w > Administrator.getDesktop().getWidth() - 10) {
            w = Administrator.getDesktop().getWidth() - 10;
        }
        if (h > Administrator.getDesktop().getHeight() - 10) {
            h = Administrator.getDesktop().getHeight() - 10;
        }
        this.setSize(w, h);
        this.m_isBusy = false;
    }

    public void setBusy(boolean b) {
        this.m_isBusy = b;
        if (b) {
            this.getContentPane().setCursor(new Cursor(3));
        } else {
            this.getContentPane().setCursor(null);
        }
    }

    public boolean isBusy() {
        return this.m_isBusy;
    }

    public Object getInvocationTarget(ConsoleCommand cmd) throws InvocationTargetException {
        String hostString = this.m_hostTextField.getText();
        String portString = this.m_portTextField.getText();
        try {
            URL ourl = new URL(this.m_locator.getFedoraAPIMPortSOAPHTTPAddress());
            StringBuffer nurl = new StringBuffer();
            nurl.append(Administrator.getProtocol() + "://");
            nurl.append(hostString);
            nurl.append(':');
            nurl.append(portString);
            nurl.append(ourl.getPath());
            if (ourl.getQuery() != null && !ourl.getQuery().equals("")) {
                nurl.append('?');
                nurl.append(ourl.getQuery());
            }
            if (ourl.getRef() != null && !ourl.getRef().equals("")) {
                nurl.append('#');
                nurl.append(ourl.getRef());
            }
            return this.m_locator.getFedoraAPIMPortSOAPHTTP(new URL(nurl.toString()));
        }
        catch (MalformedURLException murle) {
            throw new InvocationTargetException(murle, "Badly formed URL");
        }
        catch (ServiceException se) {
            throw new InvocationTargetException(se);
        }
    }

    public void print(String output) {
        this.m_outputArea.append(output);
    }

    public void clear() {
        this.m_outputArea.setText("");
    }
}

