/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment;

import fedora.client.Administrator;
import fedora.client.deployment.GeneralPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;

public class DCElementDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextField dcName;
    private JTextField dcValue;
    private final GeneralPane parent;

    public DCElementDialog(GeneralPane parent, String title, boolean modal) {
        super(JOptionPane.getFrameForComponent(Administrator.getDesktop()), "Add DC Element", true);
        this.setLocationRelativeTo(parent);
        this.parent = parent;
        this.setTitle(title);
        this.setModal(modal);
        this.setSize(300, 200);
        this.render();
        this.setVisible(true);
    }

    public DCElementDialog(GeneralPane parent, String title, boolean modal, String txt_dcElement, String txt_dcValue) {
        super(JOptionPane.getFrameForComponent(Administrator.getDesktop()), "Edit DC Element", true);
        this.setLocationRelativeTo(parent);
        this.parent = parent;
        this.setTitle(title);
        this.setModal(modal);
        this.setSize(300, 200);
        this.render();
        this.dcName.setText(txt_dcElement);
        this.dcValue.setText(txt_dcValue);
        this.setVisible(true);
    }

    private void render() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new GridLayout(3, 2));
        textPanel.add(new JLabel("DC Element Name: "));
        this.dcName = new JTextField();
        textPanel.add(this.dcName);
        textPanel.add(new JLabel("Value: "));
        this.dcValue = new JTextField();
        textPanel.add(this.dcValue);
        textPanel.setName("text");
        JButton done = new JButton("OK");
        done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DCElementDialog.this.saveFields();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DCElementDialog.this.cancel();
            }
        });
        JPanel mainButtonPanel = new JPanel();
        mainButtonPanel.add(done);
        mainButtonPanel.add(cancel);
        this.getContentPane().add((Component)textPanel, "Center");
        this.getContentPane().add((Component)mainButtonPanel, "South");
        JRootPane root = this.getRootPane();
        root.setDefaultButton(done);
    }

    private void saveFields() {
        if (this.validDC()) {
            this.parent.setDCElement(this.dcName.getText().trim(), this.dcValue.getText().trim());
            this.setVisible(false);
            this.dispose();
        }
    }

    private void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private boolean validDC() {
        if (this.dcName.getText() == null || this.dcName.getText().trim().equals("")) {
            this.parent.assertInvalidDCMsg("You must enter a DC element name");
            return false;
        }
        if (!(this.dcName.getText().equalsIgnoreCase("title") || this.dcName.getText().equalsIgnoreCase("creator") || this.dcName.getText().equalsIgnoreCase("subject") || this.dcName.getText().equalsIgnoreCase("publisher") || this.dcName.getText().equalsIgnoreCase("contributor") || this.dcName.getText().equalsIgnoreCase("date") || this.dcName.getText().equalsIgnoreCase("format") || this.dcName.getText().equalsIgnoreCase("identifier") || this.dcName.getText().equalsIgnoreCase("source") || this.dcName.getText().equalsIgnoreCase("language") || this.dcName.getText().equalsIgnoreCase("relation") || this.dcName.getText().equalsIgnoreCase("coverage") || this.dcName.getText().equalsIgnoreCase("rights"))) {
            this.parent.assertInvalidDCMsg("You have entered an invalid DC element name: " + this.dcName.getText());
            return false;
        }
        if (this.dcValue.getText() == null || this.dcValue.getText().trim().equals("")) {
            this.parent.assertInvalidDCMsg("You must enter a DC element value");
            return false;
        }
        return true;
    }
}

