/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment;

import fedora.client.deployment.ComboBoxRenderer;
import fedora.client.deployment.ComboBoxTableCellEditor;
import fedora.client.deployment.ServiceDeploymentBuilder;
import fedora.client.deployment.data.DSInputRule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class DatastreamInputPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JTable dsinputTable;
    private final HashMap ordinalityTbl = new HashMap();
    private final HashMap ordinalityToDisplayTbl = new HashMap();

    private void loadOrdinalityTbl() {
        this.ordinalityTbl.put("YES", "true");
        this.ordinalityTbl.put("NO", "false");
    }

    private void loadOrdinalityToDisplayTbl() {
        this.ordinalityToDisplayTbl.put("true", "YES");
        this.ordinalityToDisplayTbl.put("false", "NO");
    }

    public DatastreamInputPane(ServiceDeploymentBuilder parent) {
        this.loadOrdinalityTbl();
        this.loadOrdinalityToDisplayTbl();
        this.setLayout(new BorderLayout());
        this.setSize(800, 400);
        JPanel textPanel = new JPanel();
        textPanel.setBorder(new TitledBorder("Datastream Input Specification"));
        JTextArea ta = new JTextArea("In the table below, define the data contract for this Service Definition. The data contract specifies what kinds of Datastreams must reside in a Fedora Data Object that uses this deployment. \n\nAny method parameters of type 'DatastreamInput' that you entered in the Service Methods tab will automatically appear in the table below. ");
        ta.setWrapStyleWord(true);
        ta.setLineWrap(true);
        ta.setBounds(0, 0, 500, 20);
        textPanel.add(ta);
        this.dsinputTable = new JTable(0, 7);
        this.dsinputTable.setColumnSelectionAllowed(false);
        this.dsinputTable.setRowSelectionAllowed(true);
        this.dsinputTable.setRowHeight(18);
        TableColumn tc0 = this.dsinputTable.getColumnModel().getColumn(0);
        tc0.setHeaderValue("Name");
        TableColumn tc1 = this.dsinputTable.getColumnModel().getColumn(1);
        tc1.setHeaderValue("MIMEType");
        tc1.sizeWidthToFit();
        TableColumn tc2 = this.dsinputTable.getColumnModel().getColumn(2);
        tc2.setHeaderValue("Min Occurs");
        tc2.sizeWidthToFit();
        TableColumn tc3 = this.dsinputTable.getColumnModel().getColumn(3);
        tc3.setHeaderValue("Max Occurs");
        tc3.sizeWidthToFit();
        TableColumn tc4 = this.dsinputTable.getColumnModel().getColumn(4);
        tc4.setHeaderValue("Ordered?");
        String[] orderReq = this.ordinalityTbl.keySet().toArray(new String[0]);
        tc4.setCellRenderer(new ComboBoxRenderer(orderReq));
        tc4.setCellEditor(new ComboBoxTableCellEditor(orderReq));
        TableColumn tc5 = this.dsinputTable.getColumnModel().getColumn(5);
        tc5.setHeaderValue("Pretty Label");
        tc5.sizeWidthToFit();
        TableColumn tc6 = this.dsinputTable.getColumnModel().getColumn(6);
        tc6.setHeaderValue("Other Details");
        tc6.sizeWidthToFit();
        JScrollPane scrollpane = new JScrollPane(this.dsinputTable);
        scrollpane.setColumnHeaderView(this.dsinputTable.getTableHeader());
        scrollpane.getViewport().setBackground(Color.white);
        JPanel dsinputPanel = new JPanel(new BorderLayout());
        dsinputPanel.setBorder(new TitledBorder("Datastream Input Parms:"));
        dsinputPanel.add((Component)scrollpane, "Center");
        this.add((Component)textPanel, "North");
        this.add((Component)dsinputPanel, "Center");
        this.setVisible(true);
    }

    public void renderDSBindingKeys(Vector dsBindingKeys) {
        int freeRows;
        String[] keys = dsBindingKeys.toArray(new String[0]);
        if (keys.length > (freeRows = this.dsinputTable.getRowCount())) {
            int newRows = keys.length - freeRows;
            for (int j = 0; j < newRows; ++j) {
                ((DefaultTableModel)this.dsinputTable.getModel()).addRow(new Object[]{null, null, null, null, null, null, null});
            }
        }
        for (int i = 0; i < keys.length; ++i) {
            this.dsinputTable.setValueAt(keys[i], i, 0);
            this.dsinputTable.setValueAt("1", i, 2);
            this.dsinputTable.setValueAt("1", i, 3);
            this.dsinputTable.setValueAt("NO", i, 4);
            this.dsinputTable.setValueAt(keys[i] + " Binding", i, 5);
        }
    }

    public DSInputRule[] getDSInputRules() {
        if (this.dsinputTable.isEditing()) {
            this.dsinputTable.getCellEditor().stopCellEditing();
        }
        Vector<DSInputRule> rules = new Vector<DSInputRule>();
        int rowcount = this.dsinputTable.getModel().getRowCount();
        for (int i = 0; i < rowcount; ++i) {
            DSInputRule dsRule = new DSInputRule();
            dsRule.bindingKeyName = (String)this.dsinputTable.getValueAt(i, 0);
            dsRule.bindingMIMEType = (String)this.dsinputTable.getValueAt(i, 1);
            dsRule.minNumBindings = (String)this.dsinputTable.getValueAt(i, 2);
            dsRule.maxNumBindings = (String)this.dsinputTable.getValueAt(i, 3);
            dsRule.ordinality = (String)this.ordinalityTbl.get(this.dsinputTable.getValueAt(i, 4));
            dsRule.bindingLabel = (String)this.dsinputTable.getValueAt(i, 5);
            dsRule.bindingInstruction = (String)this.dsinputTable.getValueAt(i, 6);
            if (dsRule.bindingKeyName == null || dsRule.bindingKeyName.trim().equals("")) continue;
            rules.add(dsRule);
        }
        return rules.toArray(new DSInputRule[0]);
    }
}

