/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment.xml;

import fedora.client.deployment.DeploymentBuilderException;
import fedora.client.deployment.data.ServiceDeploymentTemplate;
import fedora.client.deployment.data.ServiceProfile;
import fedora.client.deployment.data.ServiceSoftware;
import fedora.client.deployment.xml.XMLWriter;
import fedora.common.Constants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServiceProfileSerializer
implements Constants {
    private Document document;

    public ServiceProfileSerializer(ServiceDeploymentTemplate newSDep) throws DeploymentBuilderException {
        this.createDOM();
        this.genServiceProfile(newSDep);
    }

    private void createDOM() throws DeploymentBuilderException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new DeploymentBuilderException("ServiceProfileGenerator: error configuring parser.Underlying exception: " + pce.getMessage());
        }
    }

    private void genServiceProfile(ServiceDeploymentTemplate newSDep) {
        ServiceProfile profile = newSDep.getServiceProfile();
        Element root = this.document.createElementNS(ServiceProfileSerializer.SERVICE_PROFILE.uri, "fsvp:serviceProfile");
        root.setAttributeNS(ServiceProfileSerializer.XMLNS.uri, "xmlns:fsvp", ServiceProfileSerializer.SERVICE_PROFILE.uri);
        String sDefPID = newSDep.getSDefContractPID() == null ? "" : newSDep.getSDefContractPID();
        root.setAttribute("bDefPID", sDefPID);
        String name = profile.serviceName == null ? "" : profile.serviceName;
        root.setAttribute("name", name);
        this.document.appendChild(root);
        Element serviceLabel = this.document.createElementNS(ServiceProfileSerializer.SERVICE_PROFILE.uri, "fsvp:serviceDescription");
        String label = profile.serviceLabel == null ? "" : profile.serviceLabel;
        serviceLabel.appendChild(this.document.createTextNode(label));
        Element serviceTestURL = this.document.createElementNS(ServiceProfileSerializer.SERVICE_PROFILE.uri, "fsvp:serviceLiveTestURL");
        String testURL = profile.serviceTestURL == null ? "" : profile.serviceTestURL;
        serviceTestURL.appendChild(this.document.createTextNode(testURL));
        Element serviceMsgProtocol = this.document.createElementNS(ServiceProfileSerializer.SERVICE_PROFILE.uri, "fsvp:serviceMessagingProtocol");
        String msgProtocol = profile.msgProtocol == null ? "" : profile.msgProtocol;
        serviceMsgProtocol.appendChild(this.document.createTextNode(msgProtocol));
        Element serviceInputs = this.document.createElementNS(ServiceProfileSerializer.SERVICE_PROFILE.uri, "fsvp:serviceInputFormats");
        for (String element : profile.inputMIMETypes) {
            Element inMIME = this.document.createElementNS(ServiceProfileSerializer.SERVICE_PROFILE.uri, "fsvp:MIMEType");
            String MIMEtype = element == null ? "" : element;
            inMIME.appendChild(this.document.createTextNode(MIMEtype));
            serviceInputs.appendChild(inMIME);
        }
        Element serviceOutputs = this.document.createElementNS(ServiceProfileSerializer.SERVICE_PROFILE.uri, "fsvp:serviceOutputFormats");
        for (String element : profile.outputMIMETypes) {
            Element outMIME = this.document.createElementNS(ServiceProfileSerializer.SERVICE_PROFILE.uri, "fsvp:MIMEType");
            String MIMEtype = element == null ? "" : element;
            outMIME.appendChild(this.document.createTextNode(MIMEtype));
            serviceOutputs.appendChild(outMIME);
        }
        Element dependencies = this.document.createElementNS(ServiceProfileSerializer.SERVICE_PROFILE.uri, "fsvp:serviceImplDependencies");
        for (ServiceSoftware element : profile.software) {
            Element software = this.document.createElementNS(ServiceProfileSerializer.SERVICE_PROFILE.uri, "fsvp:software");
            String swName = element.swName == null ? "" : element.swName;
            software.setAttribute("name", swName);
            String swVersion = element.swVersion == null ? "" : element.swVersion;
            software.setAttribute("version", swVersion);
            String swType = element.swType == null ? "" : element.swType;
            software.setAttribute("type", swType);
            String swLicenceType = element.swLicenceType == null ? "" : element.swLicenceType;
            software.setAttribute("license", swLicenceType);
            String isOpenSrc = Boolean.toString(element.isOpenSource);
            software.setAttribute("opensource", isOpenSrc);
            dependencies.appendChild(software);
        }
        Element serviceImpl = this.document.createElementNS(ServiceProfileSerializer.SERVICE_PROFILE.uri, "fsvp:serviceImplementation");
        serviceImpl.appendChild(serviceTestURL);
        serviceImpl.appendChild(serviceMsgProtocol);
        serviceImpl.appendChild(serviceInputs);
        serviceImpl.appendChild(serviceOutputs);
        serviceImpl.appendChild(dependencies);
        root.appendChild(serviceLabel);
        root.appendChild(serviceImpl);
    }

    public Element getRootElement() {
        return this.document.getDocumentElement();
    }

    public Document getDocument() {
        return this.document;
    }

    public void printDSInputSpec() {
        try {
            String str = new XMLWriter(new DOMResult(this.document)).getXMLAsString();
            System.out.println(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

