/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment.xml;

import fedora.utilities.XmlTransformUtility;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLWriter {
    private final Element rootElement;

    public XMLWriter(DOMResult result) {
        this.rootElement = (Element)result.getNode().getFirstChild();
    }

    public XMLWriter(Document document) {
        this.rootElement = document.getDocumentElement();
    }

    public XMLWriter(Element root) {
        this.rootElement = root;
    }

    public String getXMLAsString() throws TransformerException, TransformerConfigurationException, ParserConfigurationException {
        StringWriter w = new StringWriter();
        PrintWriter out = new PrintWriter(w);
        TransformerFactory tfactory = XmlTransformUtility.getTransformerFactory();
        Transformer transformer = tfactory.newTransformer();
        Properties transProps = new Properties();
        transProps.put("method", "xml");
        transProps.put("indent", "yes");
        transProps.put("omit-xml-declaration", "yes");
        transformer.setOutputProperties(transProps);
        transformer.transform(new DOMSource(this.rootElement), new StreamResult(out));
        out.close();
        return ((Object)w).toString();
    }

    public void writeXMLToFile(File file) throws TransformerException, TransformerConfigurationException, ParserConfigurationException, IOException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        TransformerFactory tfactory = XmlTransformUtility.getTransformerFactory();
        Transformer transformer = tfactory.newTransformer();
        Properties transProps = new Properties();
        transProps.put("method", "xml");
        transProps.put("indent", "yes");
        transProps.put("omit-xml-declaration", "no");
        transformer.setOutputProperties(transProps);
        transformer.transform(new DOMSource(this.rootElement), new StreamResult(out));
        out.close();
    }

    public InputStream writeXMLToStream() throws TransformerException, TransformerConfigurationException, ParserConfigurationException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TransformerFactory tfactory = XmlTransformUtility.getTransformerFactory();
        Transformer transformer = tfactory.newTransformer();
        Properties transProps = new Properties();
        transProps.put("method", "xml");
        transProps.put("indent", "yes");
        transProps.put("omit-xml-declaration", "no");
        transformer.setOutputProperties(transProps);
        transformer.transform(new DOMSource(this.rootElement), new StreamResult(out));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        out.close();
        return in;
    }

    public String serializeRoot(Writer out) {
        return this.serializeNode(this.rootElement, out);
    }

    private String serializeNode(Node node, Writer out) {
        StringBuffer string = new StringBuffer();
        try {
            if (node == null) {
                return null;
            }
            short type = node.getNodeType();
            switch (type) {
                case 9: {
                    this.serializeNode(((Document)node).getDocumentElement(), out);
                    break;
                }
                case 1: {
                    string.append("<");
                    string.append(node.getNodeName());
                    out.write("<");
                    out.write(node.getNodeName());
                    NamedNodeMap attrs = node.getAttributes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        string.append(" ");
                        string.append(attrs.item(i).getNodeName());
                        string.append("=\"");
                        string.append(attrs.item(i).getNodeValue());
                        string.append("\"");
                        out.write(" ");
                        out.write(attrs.item(i).getNodeName());
                        out.write("=\"");
                        out.write(attrs.item(i).getNodeValue());
                        out.write("\"");
                    }
                    string.append(">");
                    out.write(">");
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    for (int i = 0; i < len; ++i) {
                        this.serializeNode(children.item(i), out);
                    }
                    break;
                }
                case 3: {
                    string.append(node.getNodeValue());
                    out.write(node.getNodeValue());
                }
            }
            if (type == 1) {
                string.append("</");
                string.append(node.getNodeName());
                string.append(">");
                out.write("</");
                out.write(node.getNodeName());
                out.write(">");
            }
            out.flush();
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        return XMLWriter.enc(string.toString());
    }

    private static String enc(String in) {
        StringBuffer out = new StringBuffer();
        XMLWriter.enc(in, out);
        return out.toString();
    }

    private static void enc(String in, StringBuffer out) {
        for (int i = 0; i < in.length(); ++i) {
            XMLWriter.enc(in.charAt(i), out);
        }
    }

    private static void enc(char in, StringBuffer out) {
        if (in == '&') {
            out.append("&amp;");
        } else if (in == '<') {
            out.append("&lt;");
        } else if (in == '>') {
            out.append("&gt;");
        } else if (in == '\"') {
            out.append("&quot;");
        } else if (in == '\'') {
            out.append("&apos;");
        } else {
            out.append(in);
        }
    }
}

