/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.objecteditor;

import fedora.client.Administrator;
import fedora.client.objecteditor.types.DatastreamInputSpec;
import fedora.client.objecteditor.types.MethodDefinition;
import fedora.server.types.gen.ComparisonOperator;
import fedora.server.types.gen.Condition;
import fedora.server.types.gen.FieldSearchQuery;
import fedora.server.types.gen.FieldSearchResult;
import fedora.server.types.gen.ObjectFields;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.apache.axis.types.NonNegativeInteger;

public abstract class Util {
    public static Map getSDefLabelMap() throws IOException {
        try {
            HashMap labelMap = new HashMap();
            FieldSearchQuery query = new FieldSearchQuery();
            Condition[] conditions = new Condition[]{new Condition()};
            conditions[0].setProperty("fType");
            conditions[0].setOperator(ComparisonOperator.fromValue("eq"));
            conditions[0].setValue("D");
            query.setConditions(conditions);
            String[] fields = new String[]{"pid", "label"};
            throw new UnsupportedOperationException("This operation uses obsolete field search semantics");
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static Map getDeploymentLabelMap(String sDefPID) throws IOException {
        try {
            HashMap labelMap = new HashMap();
            FieldSearchQuery query = new FieldSearchQuery();
            Condition[] conditions = new Condition[2];
            conditions[0] = new Condition();
            conditions[0].setProperty("fType");
            conditions[0].setOperator(ComparisonOperator.fromValue("eq"));
            conditions[0].setValue("M");
            conditions[1] = new Condition();
            conditions[1].setProperty("bDef");
            conditions[1].setOperator(ComparisonOperator.fromValue("has"));
            conditions[1].setValue(sDefPID);
            query.setConditions(conditions);
            String[] fields = new String[]{"pid", "label"};
            throw new UnsupportedOperationException("This operation uses obsolete field search semantics");
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static Map getInputSpecMap(Set deploymentPIDs) throws IOException {
        HashMap<String, DatastreamInputSpec> specMap = new HashMap<String, DatastreamInputSpec>();
        for (String pid : deploymentPIDs) {
            specMap.put(pid, Util.getInputSpec(pid));
        }
        return specMap;
    }

    public static DatastreamInputSpec getInputSpec(String deploymentPID) throws IOException {
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("itemID", "DSINPUTSPEC");
        return DatastreamInputSpec.parse(Administrator.DOWNLOADER.getDatastreamDissemination(deploymentPID, "DSINPUTSPEC", null));
    }

    public static List getMethodDefinitions(String sDefPID) throws IOException {
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("itemID", "METHODMAP");
        return MethodDefinition.parse(Administrator.DOWNLOADER.getDatastreamDissemination(sDefPID, "METHODMAP", null));
    }

    public static ObjectFields getObjectFields(String pid, String[] fields) throws IOException {
        FieldSearchQuery query = new FieldSearchQuery();
        Condition[] conditions = new Condition[]{new Condition()};
        conditions[0].setProperty("pid");
        conditions[0].setOperator(ComparisonOperator.fromValue("eq"));
        conditions[0].setValue(pid);
        query.setConditions(conditions);
        FieldSearchResult result = Administrator.APIA.findObjects(fields, new NonNegativeInteger("1"), query);
        ObjectFields[] resultList = result.getResultList();
        if (resultList == null || resultList.length == 0) {
            throw new IOException("Object not found in repository");
        }
        return resultList[0];
    }

    public static void addRows(JComponent[] left, JComponent[] right, GridBagLayout gridBag, Container container, boolean north, boolean allowStretching) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 4, 4, 4);
        c.anchor = north ? 18 : 17;
        for (int i = 0; i < left.length; ++i) {
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            gridBag.setConstraints(left[i], c);
            container.add(left[i]);
            c.gridwidth = 0;
            if (right[i] instanceof JComboBox) {
                if (allowStretching) {
                    c.fill = 2;
                }
            } else {
                c.fill = 2;
            }
            c.weightx = 1.0;
            gridBag.setConstraints(right[i], c);
            container.add(right[i]);
        }
    }
}

