/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.search;

import fedora.client.Administrator;
import fedora.client.search.ResultFrame;
import fedora.server.types.gen.ComparisonOperator;
import fedora.server.types.gen.Condition;
import fedora.server.types.gen.FieldSearchQuery;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class Search
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private final List<String> m_displayFields = new ArrayList<String>();
    private final JTextField m_simpleQueryField;
    private final ConditionsTableModel m_model;
    private final JTabbedPane m_tabbedPane;
    protected static String[] s_fieldArray = new String[]{"pid", "label", "state", "ownerId", "cDate", "mDate", "dcmDate", "title", "creator", "subject", "description", "publisher", "contributor", "date", "type", "format", "identifier", "source", "language", "relation", "coverage", "rights"};
    protected static String[] s_operatorArray = new String[]{"contains", "equals", "is less than", "is less than or equal to", "is greater than", "is greater than or equal to"};
    protected static String[] s_operatorActuals = new String[]{"has", "eq", "lt", "le", "gt", "ge"};

    public Search() {
        super("Search Repository", true, true, true, true);
        this.m_displayFields.add("pid");
        this.m_displayFields.add("cDate");
        this.m_displayFields.add("title");
        JLabel selectedFieldsLabel = new JLabel();
        StringBuffer text = new StringBuffer();
        text.append("<html><i>");
        for (int i = 0; i < this.m_displayFields.size(); ++i) {
            if (i > 0) {
                text.append(", ");
            }
            text.append(this.m_displayFields.get(i));
        }
        text.append("</i></html>");
        selectedFieldsLabel.setText(text.toString());
        JButton modifySelectedFieldsButton = new JButton("Change..");
        ChangeFieldsButtonListener cfbl = new ChangeFieldsButtonListener(selectedFieldsLabel, this.m_displayFields);
        modifySelectedFieldsButton.addActionListener(cfbl);
        JPanel fieldsPanel = new JPanel();
        fieldsPanel.setLayout(new BorderLayout());
        fieldsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Fields to Display"), BorderFactory.createEmptyBorder(0, 6, 6, 6)));
        fieldsPanel.add((Component)selectedFieldsLabel, "Center");
        fieldsPanel.add((Component)modifySelectedFieldsButton, "East");
        JLabel promptLabel = new JLabel("Search all fields for ");
        this.m_simpleQueryField = new JTextField("*", 15);
        JPanel simplePromptPanel = new JPanel();
        simplePromptPanel.setLayout(new FlowLayout(0));
        simplePromptPanel.add(promptLabel);
        simplePromptPanel.add(this.m_simpleQueryField);
        JLabel simpleInstructionsLabel = new JLabel("<html>Note: You may use the ? and * wildcards.  '?' means <i>any one</i> character, and '*' means <i>any number of any characters</i>. Searches are case-insensitive.");
        JPanel simpleSearchPanel = new JPanel();
        simpleSearchPanel.setLayout(new BorderLayout());
        simpleSearchPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        simpleSearchPanel.add((Component)simplePromptPanel, "North");
        simpleSearchPanel.add((Component)simpleInstructionsLabel, "Center");
        this.m_model = new ConditionsTableModel();
        JTable conditionsTable = new JTable(this.m_model);
        JScrollPane conditionsScrollPane = new JScrollPane(conditionsTable);
        conditionsScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 6));
        JPanel innerConditionsPanel = new JPanel();
        innerConditionsPanel.setLayout(new BorderLayout());
        innerConditionsPanel.add((Component)conditionsScrollPane, "Center");
        JButton addConditionButton = new JButton("Add..");
        JButton modifyConditionButton = new JButton("Change..");
        JButton deleteConditionButton = new JButton("Delete");
        conditionsTable.setSelectionMode(0);
        ConditionSelectionListener sListener = new ConditionSelectionListener(modifyConditionButton, deleteConditionButton, -1);
        conditionsTable.getSelectionModel().addListSelectionListener(sListener);
        addConditionButton.addActionListener(new AddConditionButtonListener(this.m_model));
        modifyConditionButton.addActionListener(new ChangeConditionButtonListener(this.m_model, sListener));
        deleteConditionButton.addActionListener(new DeleteConditionButtonListener(this.m_model, sListener));
        JPanel modifyConditionsInnerPanel = new JPanel();
        modifyConditionsInnerPanel.setLayout(new GridLayout(3, 1));
        modifyConditionsInnerPanel.add(addConditionButton);
        modifyConditionsInnerPanel.add(modifyConditionButton);
        modifyConditionsInnerPanel.add(deleteConditionButton);
        JPanel modifyConditionsOuterPanel = new JPanel();
        modifyConditionsOuterPanel.setLayout(new BorderLayout());
        modifyConditionsOuterPanel.add((Component)modifyConditionsInnerPanel, "North");
        JPanel advancedSearchPanel = new JPanel();
        advancedSearchPanel.setLayout(new BorderLayout());
        advancedSearchPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        advancedSearchPanel.add((Component)innerConditionsPanel, "Center");
        advancedSearchPanel.add((Component)modifyConditionsOuterPanel, "East");
        this.m_tabbedPane = new JTabbedPane();
        this.m_tabbedPane.addTab("Simple", simpleSearchPanel);
        this.m_tabbedPane.setSelectedIndex(0);
        this.m_tabbedPane.addTab("Advanced", advancedSearchPanel);
        JPanel tabbedPaneContainer = new JPanel();
        tabbedPaneContainer.setLayout(new BorderLayout());
        tabbedPaneContainer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(6, 0, 6, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Query"), BorderFactory.createEmptyBorder(0, 6, 6, 6))));
        tabbedPaneContainer.add((Component)this.m_tabbedPane, "Center");
        JButton searchButton = new JButton("Search");
        searchButton.addActionListener(new SearchButtonListener(cfbl, this.m_model));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Search.this.doDefaultCloseAction();
            }
        });
        JPanel finishButtonsPanel = new JPanel();
        finishButtonsPanel.setLayout(new FlowLayout(1));
        finishButtonsPanel.add(searchButton);
        finishButtonsPanel.add(cancelButton);
        JPanel outerPane = new JPanel();
        outerPane.setLayout(new BorderLayout());
        outerPane.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        outerPane.add((Component)fieldsPanel, "North");
        outerPane.add((Component)tabbedPaneContainer, "Center");
        outerPane.add((Component)finishButtonsPanel, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)outerPane, "Center");
        this.setFrameIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/standard/general/Search16.gif")));
        this.setSize(400, 400);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConditionsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        List<Condition> m_conditions;

        public ConditionsTableModel() {
            this.m_conditions = new ArrayList<Condition>();
        }

        public ConditionsTableModel(List<Condition> conditions) {
            this.m_conditions = conditions;
        }

        public List<Condition> getConditions() {
            return this.m_conditions;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "Field";
            }
            if (col == 1) {
                return "Operator";
            }
            return "Value";
        }

        @Override
        public int getRowCount() {
            return this.m_conditions.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Condition cond = this.m_conditions.get(row);
            if (col == 0) {
                return cond.getProperty();
            }
            if (col == 1) {
                return this.getNiceName(cond.getOperator().toString());
            }
            return cond.getValue();
        }

        private String getNiceName(String operString) {
            if (operString.equals("has")) {
                return "contains";
            }
            if (operString.equals("eq")) {
                return "equals";
            }
            if (operString.equals("lt")) {
                return "is less than";
            }
            if (operString.equals("le")) {
                return "is less than or equal to";
            }
            if (operString.equals("gt")) {
                return "is greater than";
            }
            return "is greater than or equal to";
        }
    }

    public class ChangeFieldsButtonListener
    implements ActionListener {
        private final JLabel m_fieldLabel;
        private List m_fieldList;

        public ChangeFieldsButtonListener(JLabel fieldLabel, List fieldList) {
            this.m_fieldLabel = fieldLabel;
            this.m_fieldList = fieldList;
        }

        public void actionPerformed(ActionEvent e) {
            SelectFieldsDialog dialog = new SelectFieldsDialog(this.m_fieldList);
            dialog.setVisible(true);
            if (dialog.getSelectedFields() != null) {
                this.m_fieldList = dialog.getSelectedFields();
                StringBuffer text = new StringBuffer();
                text.append("<html><i>");
                for (int i = 0; i < this.m_fieldList.size(); ++i) {
                    if (i > 0) {
                        text.append(", ");
                    }
                    text.append((String)this.m_fieldList.get(i));
                }
                text.append("</i></html>");
                this.m_fieldLabel.setText(text.toString());
            }
        }

        public List getFieldList() {
            return this.m_fieldList;
        }
    }

    public class SearchButtonListener
    implements ActionListener {
        private final ChangeFieldsButtonListener m_fieldSelector;
        private final ConditionsTableModel m_model;

        public SearchButtonListener(ChangeFieldsButtonListener fieldSelector, ConditionsTableModel model) {
            this.m_fieldSelector = fieldSelector;
            this.m_model = model;
        }

        public void actionPerformed(ActionEvent e) {
            List fields = this.m_fieldSelector.getFieldList();
            String[] displayFields = new String[fields.size()];
            for (int i = 0; i < fields.size(); ++i) {
                displayFields[i] = (String)fields.get(i);
            }
            FieldSearchQuery query = new FieldSearchQuery();
            if (Search.this.m_tabbedPane.getSelectedIndex() == 0) {
                query.setTerms(Search.this.m_simpleQueryField.getText());
            } else {
                List<Condition> conditions = this.m_model.getConditions();
                Condition[] cond = new Condition[conditions.size()];
                for (int i = 0; i < conditions.size(); ++i) {
                    cond[i] = conditions.get(i);
                }
                query.setConditions(cond);
            }
            ResultFrame frame = new ResultFrame("Search Results", displayFields, 100, query);
            frame.setVisible(true);
            Administrator.getDesktop().add(frame);
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
        }
    }

    public class ModConditionDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private final ConditionsTableModel m_model;
        private final int m_rowNum;
        private final JComboBox m_fieldBox;
        private final JComboBox m_operatorBox;
        private final JTextField m_valueField;

        public ModConditionDialog(ConditionsTableModel model, int rowNum) {
            super(Administrator.getInstance(), "Enter Condition", true);
            this.m_model = model;
            this.m_rowNum = rowNum;
            this.m_fieldBox = new JComboBox<String>(s_fieldArray);
            this.m_operatorBox = new JComboBox<String>(s_operatorArray);
            this.m_valueField = new JTextField(10);
            if (rowNum != -1) {
                this.m_fieldBox.setSelectedIndex(this.indexOf((String)this.m_model.getValueAt(rowNum, 0)));
                this.m_operatorBox.setSelectedIndex(this.indexOf((String)this.m_model.getValueAt(rowNum, 1)));
                this.m_valueField.setText((String)this.m_model.getValueAt(rowNum, 2));
            }
            JPanel northPanel = new JPanel();
            northPanel.setLayout(new FlowLayout(1));
            northPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            northPanel.add(this.m_fieldBox);
            northPanel.add(this.m_operatorBox);
            northPanel.add(this.m_valueField);
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ModConditionDialog.this.updateModelAndNotify();
                    ModConditionDialog.this.setVisible(false);
                }
            });
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ModConditionDialog.this.setVisible(false);
                }
            });
            JPanel southPanel = new JPanel();
            southPanel.setLayout(new FlowLayout(1));
            southPanel.add(okButton);
            southPanel.add(cancelButton);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)northPanel, "North");
            this.getContentPane().add((Component)southPanel, "South");
            this.pack();
            this.setLocation(Administrator.getInstance().getCenteredPos(this.getSize().width, this.getSize().height));
        }

        private int indexOf(String s) {
            int i;
            for (i = 0; i < s_fieldArray.length; ++i) {
                if (!s_fieldArray[i].equals(s)) continue;
                return i;
            }
            for (i = 0; i < s_operatorArray.length; ++i) {
                if (!s_operatorArray[i].equals(s)) continue;
                return i;
            }
            return -1;
        }

        public void updateModelAndNotify() {
            Condition cond = new Condition();
            cond.setProperty(s_fieldArray[this.m_fieldBox.getSelectedIndex()]);
            cond.setOperator(ComparisonOperator.fromValue(s_operatorActuals[this.m_operatorBox.getSelectedIndex()]));
            cond.setValue(this.m_valueField.getText());
            if (this.m_rowNum == -1) {
                this.m_model.getConditions().add(cond);
            } else {
                this.m_model.getConditions().set(this.m_rowNum, cond);
            }
            this.m_model.fireTableDataChanged();
        }
    }

    public class DeleteConditionButtonListener
    implements ActionListener {
        private final ConditionsTableModel m_model;
        private final ConditionSelectionListener m_sListener;

        public DeleteConditionButtonListener(ConditionsTableModel model, ConditionSelectionListener sListener) {
            this.m_model = model;
            this.m_sListener = sListener;
        }

        public void actionPerformed(ActionEvent e) {
            int r = this.m_sListener.getSelectedRow();
            this.m_model.getConditions().remove(r);
            this.m_model.fireTableRowsDeleted(r, r);
        }
    }

    public class ChangeConditionButtonListener
    implements ActionListener {
        private final ConditionsTableModel m_model;
        private final ConditionSelectionListener m_sListener;

        public ChangeConditionButtonListener(ConditionsTableModel model, ConditionSelectionListener sListener) {
            this.m_model = model;
            this.m_sListener = sListener;
        }

        public void actionPerformed(ActionEvent e) {
            ModConditionDialog dialog = new ModConditionDialog(this.m_model, this.m_sListener.getSelectedRow());
            dialog.setVisible(true);
        }
    }

    public class AddConditionButtonListener
    implements ActionListener {
        private final ConditionsTableModel m_model;

        public AddConditionButtonListener(ConditionsTableModel model) {
            this.m_model = model;
        }

        public void actionPerformed(ActionEvent e) {
            ModConditionDialog dialog = new ModConditionDialog(this.m_model, -1);
            dialog.setVisible(true);
        }
    }

    public class SelectFieldsDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private List<String> m_selectedFields;
        private final JCheckBox pidBox;
        private final JCheckBox typeBox;
        private final JCheckBox labelBox;
        private final JCheckBox formatBox;
        private final JCheckBox titleBox;
        private final JCheckBox identifierBox;
        private final JCheckBox creatorBox;
        private final JCheckBox sourceBox;
        private final JCheckBox stateBox;
        private final JCheckBox subjectBox;
        private final JCheckBox languageBox;
        private final JCheckBox ownerIdBox;
        private final JCheckBox descriptionBox;
        private final JCheckBox relationBox;
        private final JCheckBox cDateBox;
        private final JCheckBox publisherBox;
        private final JCheckBox coverageBox;
        private final JCheckBox mDateBox;
        private final JCheckBox contributorBox;
        private final JCheckBox rightsBox;
        private final JCheckBox dcmDateBox;
        private final JCheckBox dateBox;

        public SelectFieldsDialog(List fieldList) {
            super(Administrator.getInstance(), "Select Fields to Display", true);
            this.pidBox = new JCheckBox("pid", fieldList.contains("pid"));
            this.pidBox.setToolTipText("a globally unique id");
            this.typeBox = new JCheckBox("type", fieldList.contains("type"));
            this.typeBox.setToolTipText("a list of dc:type values, indicating nature or genre");
            this.labelBox = new JCheckBox("label", fieldList.contains("label"));
            this.labelBox.setToolTipText("a human-readable name");
            this.formatBox = new JCheckBox("format", fieldList.contains("format"));
            this.formatBox.setToolTipText("a list of dc:format values, indicating physical or digital forms");
            this.titleBox = new JCheckBox("title", fieldList.contains("title"));
            this.titleBox.setToolTipText("a list of dc:title values (names)");
            this.identifierBox = new JCheckBox("identifier", fieldList.contains("identifier"));
            this.identifierBox.setToolTipText("a list of dc:identifier values, providing unambiguous ids in certain contexts");
            this.creatorBox = new JCheckBox("creator", fieldList.contains("creator"));
            this.creatorBox.setToolTipText("a list of dc:creator values, identifying primary maker(s) of the content");
            this.sourceBox = new JCheckBox("source", fieldList.contains("source"));
            this.sourceBox.setToolTipText("a list of dc:source values, identifying resources from which this resource is derived");
            this.stateBox = new JCheckBox("state", fieldList.contains("state"));
            this.stateBox.setToolTipText("the state of the object, A for active");
            this.subjectBox = new JCheckBox("subject", fieldList.contains("subject"));
            this.subjectBox.setToolTipText("a list of dc:subject values, indicating the topic of the resource");
            this.languageBox = new JCheckBox("language", fieldList.contains("language"));
            this.languageBox.setToolTipText("a list of dc:language values, language(s) of the intellectual content");
            this.ownerIdBox = new JCheckBox("ownerId", fieldList.contains("ownerId"));
            this.ownerIdBox.setToolTipText("owner id, the identity of the repository user who owns the object");
            this.descriptionBox = new JCheckBox("description", fieldList.contains("description"));
            this.descriptionBox.setToolTipText("a list of description values; accounts of the content of the resouces");
            this.relationBox = new JCheckBox("relation", fieldList.contains("relation"));
            this.relationBox.setToolTipText("a list of dc:relation values, identifying related resources");
            this.cDateBox = new JCheckBox("cDate", fieldList.contains("cDate"));
            this.cDateBox.setToolTipText("creation date, the date the object was first created in the repository");
            this.publisherBox = new JCheckBox("publisher", fieldList.contains("publisher"));
            this.publisherBox.setToolTipText("a list of dc:publisher values, entities responsible for making the resouce available");
            this.coverageBox = new JCheckBox("coverage", fieldList.contains("coverage"));
            this.coverageBox.setToolTipText("a list of dc:coverage values, indicating the extent or scope of the content");
            this.mDateBox = new JCheckBox("mDate", fieldList.contains("mDate"));
            this.mDateBox.setToolTipText("modified date, the last date the object was changed");
            this.contributorBox = new JCheckBox("contributor", fieldList.contains("contributor"));
            this.contributorBox.setToolTipText("a list of dc:contributor values, identifying content-contributing entities");
            this.rightsBox = new JCheckBox("rights", fieldList.contains("rights"));
            this.rightsBox.setToolTipText("a list of dc:rights values, regarding rights held in and over the resource");
            this.dcmDateBox = new JCheckBox("dcmDate", fieldList.contains("dcmDate"));
            this.dcmDateBox.setToolTipText("dublin core modified date, the date of the last change to the DC record");
            this.dateBox = new JCheckBox("date", fieldList.contains("date"));
            this.dateBox.setToolTipText("a list of dc:date values, identifying significant events in the resource's lifecycle");
            JPanel northPanel = new JPanel();
            northPanel.setLayout(new GridLayout(9, 3));
            northPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            northPanel.add(this.pidBox);
            northPanel.add(this.typeBox);
            northPanel.add(this.labelBox);
            northPanel.add(this.formatBox);
            northPanel.add(this.titleBox);
            northPanel.add(this.identifierBox);
            northPanel.add(this.creatorBox);
            northPanel.add(this.sourceBox);
            northPanel.add(this.stateBox);
            northPanel.add(this.subjectBox);
            northPanel.add(this.languageBox);
            northPanel.add(this.ownerIdBox);
            northPanel.add(this.descriptionBox);
            northPanel.add(this.relationBox);
            northPanel.add(this.cDateBox);
            northPanel.add(this.publisherBox);
            northPanel.add(this.coverageBox);
            northPanel.add(this.mDateBox);
            northPanel.add(this.contributorBox);
            northPanel.add(this.rightsBox);
            northPanel.add(this.dcmDateBox);
            northPanel.add(this.dateBox);
            JLabel noteLabel = new JLabel("<html><i> Note: Hold your mouse over a field's name to see a brief description.</i></html>");
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectFieldsDialog.this.updateSelectedFields();
                    SelectFieldsDialog.this.setVisible(false);
                }
            });
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectFieldsDialog.this.setVisible(false);
                }
            });
            JPanel southPanel = new JPanel();
            southPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            southPanel.setLayout(new FlowLayout(1));
            southPanel.add(okButton);
            southPanel.add(cancelButton);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)northPanel, "North");
            this.getContentPane().add((Component)noteLabel, "Center");
            this.getContentPane().add((Component)southPanel, "South");
            this.pack();
            this.setLocation(Administrator.getInstance().getCenteredPos(this.getSize().width, this.getSize().height));
        }

        public void updateSelectedFields() {
            this.m_selectedFields = new ArrayList<String>();
            if (this.pidBox.isSelected()) {
                this.m_selectedFields.add("pid");
            }
            if (this.labelBox.isSelected()) {
                this.m_selectedFields.add("label");
            }
            if (this.stateBox.isSelected()) {
                this.m_selectedFields.add("state");
            }
            if (this.ownerIdBox.isSelected()) {
                this.m_selectedFields.add("ownerId");
            }
            if (this.cDateBox.isSelected()) {
                this.m_selectedFields.add("cDate");
            }
            if (this.mDateBox.isSelected()) {
                this.m_selectedFields.add("mDate");
            }
            if (this.dcmDateBox.isSelected()) {
                this.m_selectedFields.add("dcmDate");
            }
            if (this.titleBox.isSelected()) {
                this.m_selectedFields.add("title");
            }
            if (this.creatorBox.isSelected()) {
                this.m_selectedFields.add("creator");
            }
            if (this.subjectBox.isSelected()) {
                this.m_selectedFields.add("subject");
            }
            if (this.descriptionBox.isSelected()) {
                this.m_selectedFields.add("description");
            }
            if (this.publisherBox.isSelected()) {
                this.m_selectedFields.add("publisher");
            }
            if (this.contributorBox.isSelected()) {
                this.m_selectedFields.add("contributor");
            }
            if (this.dateBox.isSelected()) {
                this.m_selectedFields.add("date");
            }
            if (this.typeBox.isSelected()) {
                this.m_selectedFields.add("type");
            }
            if (this.formatBox.isSelected()) {
                this.m_selectedFields.add("format");
            }
            if (this.identifierBox.isSelected()) {
                this.m_selectedFields.add("identifier");
            }
            if (this.sourceBox.isSelected()) {
                this.m_selectedFields.add("source");
            }
            if (this.languageBox.isSelected()) {
                this.m_selectedFields.add("language");
            }
            if (this.relationBox.isSelected()) {
                this.m_selectedFields.add("relation");
            }
            if (this.coverageBox.isSelected()) {
                this.m_selectedFields.add("coverage");
            }
            if (this.rightsBox.isSelected()) {
                this.m_selectedFields.add("rights");
            }
        }

        public List getSelectedFields() {
            return this.m_selectedFields;
        }
    }

    public class ConditionSelectionListener
    implements ListSelectionListener {
        private int m_selectedRow;
        private final JButton m_modifyButton;
        private final JButton m_deleteButton;

        public ConditionSelectionListener(JButton modifyButton, JButton deleteButton, int selectedRow) {
            this.m_selectedRow = selectedRow;
            this.m_modifyButton = modifyButton;
            this.m_deleteButton = deleteButton;
            this.updateButtons();
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            this.m_selectedRow = lsm.isSelectionEmpty() ? -1 : lsm.getMinSelectionIndex();
            this.updateButtons();
        }

        public int getSelectedRow() {
            return this.m_selectedRow;
        }

        private void updateButtons() {
            if (this.getSelectedRow() == -1) {
                this.m_modifyButton.setEnabled(false);
                this.m_deleteButton.setEnabled(false);
            } else {
                this.m_modifyButton.setEnabled(true);
                this.m_deleteButton.setEnabled(true);
            }
        }
    }
}

