/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.ingest;

import fedora.common.Constants;
import fedora.server.access.FedoraAPIA;
import fedora.server.management.FedoraAPIM;
import fedora.server.types.gen.RepositoryInfo;
import fedora.server.utilities.StreamUtility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.rpc.ServiceException;

public class AutoIngestor
implements Constants {
    private final FedoraAPIA m_apia;
    private final FedoraAPIM m_apim;
    private static HashMap<FedoraAPIA, RepositoryInfo> s_repoInfo = new HashMap();

    public AutoIngestor(FedoraAPIA apia, FedoraAPIM apim) throws MalformedURLException, ServiceException {
        this.m_apia = apia;
        this.m_apim = apim;
    }

    @Deprecated
    public String ingestAndCommit(InputStream in, String logMessage) throws RemoteException, IOException {
        return AutoIngestor.ingestAndCommit(this.m_apia, this.m_apim, in, logMessage);
    }

    @Deprecated
    public static String ingestAndCommit(FedoraAPIA apia, FedoraAPIM apim, InputStream in, String logMessage) throws RemoteException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtility.pipeStream(in, out, 4096);
        String pid = apim.ingest(out.toByteArray(), AutoIngestor.METS_EXT1_0.uri, logMessage);
        return pid;
    }

    public String ingestAndCommit(InputStream in, String ingestFormat, String logMessage) throws RemoteException, IOException {
        return AutoIngestor.ingestAndCommit(this.m_apia, this.m_apim, in, ingestFormat, logMessage);
    }

    public static String ingestAndCommit(FedoraAPIA apia, FedoraAPIM apim, InputStream in, String ingestFormat, String logMessage) throws RemoteException, IOException {
        StringTokenizer stoken;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtility.pipeStream(in, out, 4096);
        RepositoryInfo repoInfo = s_repoInfo.get(apia);
        if (repoInfo == null) {
            repoInfo = apia.describeRepository();
            s_repoInfo.put(apia, repoInfo);
        }
        if (new Integer((stoken = new StringTokenizer(repoInfo.getRepositoryVersion(), ".")).nextToken()) < 2) {
            if (!ingestFormat.equals(AutoIngestor.METS_EXT1_0.uri)) {
                throw new IOException("You are connected to a pre-2.0 Fedora repository which will only accept the format \"" + AutoIngestor.METS_EXT1_0.uri + "\" for ingest.");
            }
            return apim.ingest(out.toByteArray(), AutoIngestor.METS_EXT1_0.uri, logMessage);
        }
        return apim.ingest(out.toByteArray(), ingestFormat, logMessage);
    }
}

