/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.ingest;

import fedora.client.FedoraClient;
import fedora.client.utility.AutoFinder;
import fedora.client.utility.export.AutoExporter;
import fedora.client.utility.ingest.AutoIngestor;
import fedora.client.utility.ingest.IngestCounter;
import fedora.client.utility.ingest.IngestLogger;
import fedora.common.Constants;
import fedora.server.access.FedoraAPIA;
import fedora.server.management.FedoraAPIM;
import fedora.server.types.gen.ComparisonOperator;
import fedora.server.types.gen.Condition;
import fedora.server.types.gen.FieldSearchQuery;
import fedora.server.types.gen.FieldSearchResult;
import fedora.server.types.gen.ObjectFields;
import fedora.server.types.gen.RepositoryInfo;
import fedora.utilities.FileComparator;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.StringTokenizer;

public class Ingest
implements Constants {
    public static String LAST_PATH;
    private static FileComparator _FILE_COMPARATOR;

    public static String oneFromFile(File file, String ingestFormat, FedoraAPIA targetRepoAPIA, FedoraAPIM targetRepoAPIM, String logMessage) throws Exception {
        LAST_PATH = file.getPath();
        String pid = AutoIngestor.ingestAndCommit(targetRepoAPIA, targetRepoAPIM, new FileInputStream(file), ingestFormat, Ingest.getMessage(logMessage, file));
        return pid;
    }

    public static void multiFromDirectory(File dir, String ingestFormat, FedoraAPIA targetRepoAPIA, FedoraAPIM targetRepoAPIM, String logMessage, PrintStream log, IngestCounter c) throws Exception {
        File[] files = dir.listFiles();
        Arrays.sort(files, _FILE_COMPARATOR);
        for (File element : files) {
            if (element.isHidden() || element.getName().startsWith(".")) continue;
            if (element.isDirectory()) {
                Ingest.multiFromDirectory(element, ingestFormat, targetRepoAPIA, targetRepoAPIM, logMessage, log, c);
                continue;
            }
            try {
                String pid = Ingest.oneFromFile(element, ingestFormat, targetRepoAPIA, targetRepoAPIM, logMessage);
                ++c.successes;
                IngestLogger.logFromFile(log, element, pid);
            }
            catch (Exception e) {
                ++c.failures;
                IngestLogger.logFailedFromFile(log, element, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean matches(File file, String searchString) throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if (line.indexOf(searchString) == -1) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        return false;
    }

    public static String oneFromRepository(FedoraAPIA sourceRepoAPIA, FedoraAPIM sourceRepoAPIM, String sourceExportFormat, String pid, FedoraAPIA targetRepoAPIA, FedoraAPIM targetRepoAPIM, String logMessage) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AutoExporter.export(sourceRepoAPIA, sourceRepoAPIM, pid, sourceExportFormat, "migrate", out);
        String ingestFormat = sourceExportFormat;
        if (sourceExportFormat.equals("metslikefedora1")) {
            ingestFormat = Constants.METS_EXT1_0.uri;
        } else if (sourceExportFormat.equals("foxml1.0")) {
            ingestFormat = Constants.FOXML1_0.uri;
        }
        String realLogMessage = logMessage;
        if (realLogMessage == null) {
            realLogMessage = "Ingested from source repository with pid " + pid;
        }
        return AutoIngestor.ingestAndCommit(targetRepoAPIA, targetRepoAPIM, new ByteArrayInputStream(out.toByteArray()), ingestFormat, realLogMessage);
    }

    public static void multiFromRepository(String sourceProtocol, String sourceHost, int sourcePort, FedoraAPIA sourceRepoAPIA, FedoraAPIM sourceRepoAPIM, String sourceExportFormat, FedoraAPIA targetRepoAPIA, FedoraAPIM targetRepoAPIM, String logMessage, PrintStream log, IngestCounter c) throws Exception {
        FieldSearchQuery query = new FieldSearchQuery();
        Condition cond = new Condition();
        cond.setProperty("pid");
        cond.setOperator(ComparisonOperator.fromValue("has"));
        Condition[] conditions = new Condition[]{cond};
        query.setConditions(conditions);
        query.setTerms(null);
        String[] resultFields = new String[]{"pid"};
        FieldSearchResult result = AutoFinder.findObjects(sourceRepoAPIA, resultFields, 100, query);
        while (result != null) {
            ObjectFields[] ofs;
            for (ObjectFields element : ofs = result.getResultList()) {
                String pid = element.getPid();
                try {
                    String newPID = Ingest.oneFromRepository(sourceRepoAPIA, sourceRepoAPIM, sourceExportFormat, pid, targetRepoAPIA, targetRepoAPIM, logMessage);
                    ++c.successes;
                    IngestLogger.logFromRepos(log, pid, newPID);
                }
                catch (Exception e) {
                    ++c.failures;
                    IngestLogger.logFailedFromRepos(log, pid, e);
                }
            }
            String token = null;
            try {
                token = result.getListSession().getToken();
            }
            catch (Throwable th) {
                // empty catch block
            }
            if (token != null) {
                result = AutoFinder.resumeFindObjects(sourceRepoAPIA, token);
                continue;
            }
            result = null;
        }
    }

    public static String getExportFormat(RepositoryInfo repoinfo) throws Exception {
        String sourceExportFormat = null;
        StringTokenizer stoken = new StringTokenizer(repoinfo.getRepositoryVersion(), ".");
        int majorVersion = new Integer(stoken.nextToken());
        sourceExportFormat = majorVersion < 2 ? "metslikefedora1" : repoinfo.getDefaultExportFormat();
        return sourceExportFormat;
    }

    private static String getMessage(String logMessage, File file) {
        if (logMessage != null) {
            return logMessage;
        }
        return "Ingested from local file " + file.getPath();
    }

    public static String getDuration(long millis) {
        long tsec = millis / 1000L;
        long h = tsec / 60L / 60L;
        long m = (tsec - h * 60L * 60L) / 60L;
        long s = tsec - h * 60L * 60L - m * 60L;
        StringBuffer out = new StringBuffer();
        if (h > 0L) {
            out.append(h + " hour");
            if (h > 1L) {
                out.append('s');
            }
        }
        if (m > 0L) {
            if (h > 0L) {
                out.append(", ");
            }
            out.append(m + " minute");
            if (m > 1L) {
                out.append('s');
            }
        }
        if (s > 0L || h == 0L && m == 0L) {
            if (h > 0L || m > 0L) {
                out.append(", ");
            }
            out.append(s + " second");
            if (s != 1L) {
                out.append('s');
            }
        }
        return out.toString();
    }

    public static void badArgs(String msg) {
        System.err.println("Command: fedora-ingest");
        System.err.println();
        System.err.println("Summary: Ingests one or more objects into a Fedora repository, from either");
        System.err.println("         the local filesystem or another Fedora repository.");
        System.err.println();
        System.err.println("Syntax:");
        System.err.println("  fedora-ingest f[ile] INPATH FORMAT THST:TPRT TUSR TPSS TPROTOCOL [LOG]");
        System.err.println("  fedora-ingest d[ir] INPATH FORMAT THST:TPRT TUSR TPSS TPROTOCOL [LOG]");
        System.err.println("  fedora-ingest r[epos] SHST:SPRT SUSR SPSS PID|* THST:TPRT TUSR TPSS SPROTOCOL TPROTOCOL [LOG]");
        System.err.println();
        System.err.println("Where:");
        System.err.println("  INPATH     is the local file or directory name that is ingest source.");
        System.err.println("  FORMAT     is a string value which indicates the XML format of the ingest file(s)");
        System.err.println("             ('" + Ingest.FOXML1_1.uri + "',");
        System.err.println("              '" + Ingest.FOXML1_0.uri + "',");
        System.err.println("              '" + Ingest.ATOM1_0.uri + "',");
        System.err.println("              or '" + Ingest.METS_EXT1_1.uri + "')");
        System.err.println("  PID        is the id of the object to ingest from the source repository.");
        System.err.println("  SHST/THST  is the source or target repository's hostname.");
        System.err.println("  SPRT/TPRT  is the source or target repository's port number.");
        System.err.println("  SUSR/TUSR  is the id of the source or target repository user.");
        System.err.println("  SPSS/TPSS  is the password of the source or target repository user.");
        System.err.println("  SPROTOCOL  is the protocol to communicate with source repository (http or https)");
        System.err.println("  TPROTOCOL  is the protocol to communicate with target repository (http or https)");
        System.err.println("  LOG        is the optional log message.  If unspecified, the log message");
        System.err.println("             will indicate the source filename or repository of the object(s).");
        System.err.println();
        System.err.println("Examples:");
        System.err.println("fedora-ingest f obj1.xml " + Ingest.FOXML1_1.uri + " myrepo.com:8443 jane jpw https");
        System.err.println();
        System.err.println("  Ingests obj1.xml (encoded in FOXML 1.1 format) from the");
        System.err.println("  current directory into the repository at myrepo.com:80");
        System.err.println("  as user 'jane' with password 'jpw' using the secure https protocol (SSL).");
        System.err.println("  The logmessage will be system-generated, indicating");
        System.err.println("  the source path+filename.");
        System.err.println();
        System.err.println("fedora-ingest d c:\\archive " + Ingest.FOXML1_1.uri + " myrepo.com:80 jane janepw http \"\"");
        System.err.println();
        System.err.println("  Traverses entire directory structure of c:\\archive, and ingests any file.");
        System.err.println("  It assumes all files will be in the FOXML 1.1 format");
        System.err.println("  and will fail on ingests of files that are not of this format.");
        System.err.println("  All log messages will be the quoted string.");
        System.err.println();
        System.err.println("fedora-ingest r jrepo.com:8081 mike mpw demo:1 myrepo.com:8443 jane jpw http https \"\"");
        System.err.println();
        System.err.println("  Ingests the object whose pid is 'demo:1' from the source repository");
        System.err.println("  'srcrepo.com:8081' into the target repository 'myrepo.com:80'.");
        System.err.println("  The object will be exported from the source repository in the default");
        System.err.println("  export format configured at the source.");
        System.err.println("  All log messages will be empty.");
        System.err.println();
        System.err.println("fedora-ingest r jrepo.com:8081 mike mpw O myrepo.com:8443 jane jpw http https \"\"");
        System.err.println();
        System.err.println("  Same as above, but ingests all data objects (type O).");
        System.err.println();
        System.err.println("ERROR  : " + msg);
        System.exit(1);
    }

    private static void summarize(IngestCounter counter, File logFile) {
        System.out.println();
        if (counter.failures > 0) {
            System.out.println("WARNING: " + counter.failures + " of " + counter.getTotal() + " objects failed.  Check log.");
        } else {
            System.out.println("SUCCESS: All " + counter.getTotal() + " objects were ingested.");
        }
        System.out.println();
        System.out.println("A detailed log is at " + logFile.getPath());
    }

    public static void main(String[] args) {
        block23: {
            try {
                if (args.length < 1) {
                    Ingest.badArgs("No arguments entered!");
                }
                PrintStream log = null;
                File logFile = null;
                String logRootName = null;
                IngestCounter counter = new IngestCounter();
                char kind = args[0].toLowerCase().charAt(0);
                if (kind == 'f') {
                    FedoraAPIM targetRepoAPIM;
                    if (args.length < 7 || args.length > 8) {
                        Ingest.badArgs("Wrong number of arguments for file ingest.");
                        System.out.println("USAGE: fedora-ingest f[ile] INPATH FORMAT THST:TPRT TUSR TPSS PROTOCOL [LOG]");
                    }
                    File f = new File(args[1]);
                    String ingestFormat = args[2];
                    String logMessage = null;
                    if (args.length == 8) {
                        logMessage = args[7];
                    }
                    String protocol = args[6];
                    String[] hp = args[3].split(":");
                    String baseURL = protocol + "://" + hp[0] + ":" + Integer.parseInt(hp[1]) + "/fedora";
                    FedoraClient fc = new FedoraClient(baseURL, args[4], args[5]);
                    FedoraAPIA targetRepoAPIA = fc.getAPIA();
                    String pid = Ingest.oneFromFile(f, ingestFormat, targetRepoAPIA, targetRepoAPIM = fc.getAPIM(), logMessage);
                    if (pid == null) {
                        System.out.print("ERROR: ingest failed for file: " + args[1]);
                    } else {
                        System.out.println("Ingested PID: " + pid);
                    }
                } else if (kind == 'd') {
                    if (args.length < 7 || args.length > 8) {
                        Ingest.badArgs("Wrong number of arguments (" + args.length + ") for directory ingest.");
                        System.out.println("USAGE: fedora-ingest d[ir] INPATH FORMAT THST:TPRT TUSR TPSS PROTOCOL [LOG]");
                    }
                    File d = new File(args[1]);
                    String ingestFormat = args[2];
                    String logMessage = null;
                    if (args.length == 8) {
                        logMessage = args[7];
                    }
                    String protocol = args[6];
                    String[] hp = args[3].split(":");
                    String baseURL = protocol + "://" + hp[0] + ":" + Integer.parseInt(hp[1]) + "/fedora";
                    FedoraClient fc = new FedoraClient(baseURL, args[4], args[5]);
                    FedoraAPIA targetRepoAPIA = fc.getAPIA();
                    FedoraAPIM targetRepoAPIM = fc.getAPIM();
                    logRootName = "ingest-from-dir";
                    logFile = IngestLogger.newLogFile(logRootName);
                    log = new PrintStream((OutputStream)new FileOutputStream(logFile), true, "UTF-8");
                    IngestLogger.openLog(log, logRootName);
                    Ingest.multiFromDirectory(d, ingestFormat, targetRepoAPIA, targetRepoAPIM, logMessage, log, counter);
                    IngestLogger.closeLog(log, logRootName);
                    Ingest.summarize(counter, logFile);
                } else if (kind == 'r') {
                    if (args.length < 10 || args.length > 11) {
                        Ingest.badArgs("Wrong number of arguments for repository ingest.");
                    }
                    String logMessage = null;
                    if (args.length == 11) {
                        logMessage = args[10];
                    }
                    String[] shp = args[1].split(":");
                    String source_host = shp[0];
                    String source_port = shp[1];
                    String source_user = args[2];
                    String source_password = args[3];
                    String source_protocol = args[8];
                    String sourceBaseURL = source_protocol + "://" + source_host + ":" + Integer.parseInt(source_port) + "/fedora";
                    FedoraClient sfc = new FedoraClient(sourceBaseURL, source_user, source_password);
                    FedoraAPIA sourceRepoAPIA = sfc.getAPIA();
                    FedoraAPIM sourceRepoAPIM = sfc.getAPIM();
                    String[] thp = args[5].split(":");
                    String target_host = thp[0];
                    String target_port = thp[1];
                    String target_user = args[6];
                    String target_password = args[7];
                    String target_protocol = args[9];
                    String targetBaseURL = target_protocol + "://" + target_host + ":" + Integer.parseInt(target_port) + "/fedora";
                    FedoraClient tfc = new FedoraClient(targetBaseURL, target_user, target_password);
                    FedoraAPIA targetRepoAPIA = tfc.getAPIA();
                    FedoraAPIM targetRepoAPIM = tfc.getAPIM();
                    RepositoryInfo repoinfo = sourceRepoAPIA.describeRepository();
                    System.out.println("Ingest: exporting from a source repo version " + repoinfo.getRepositoryVersion());
                    String sourceExportFormat = Ingest.getExportFormat(repoinfo);
                    System.out.println("Ingest: source repo is using " + sourceExportFormat + " export format.");
                    if (args[4].indexOf(":") != -1) {
                        String successfulPID = Ingest.oneFromRepository(sourceRepoAPIA, sourceRepoAPIM, sourceExportFormat, args[4], targetRepoAPIA, targetRepoAPIM, logMessage);
                        if (successfulPID == null) {
                            System.out.print("ERROR: ingest from repo failed for PID=" + args[4]);
                        } else {
                            System.out.println("Ingested PID: " + successfulPID);
                        }
                    } else {
                        logRootName = "ingest-from-repository";
                        logFile = IngestLogger.newLogFile(logRootName);
                        log = new PrintStream((OutputStream)new FileOutputStream(logFile), true, "UTF-8");
                        IngestLogger.openLog(log, logRootName);
                        Ingest.multiFromRepository(source_protocol, source_host, Integer.parseInt(source_port), sourceRepoAPIA, sourceRepoAPIM, sourceExportFormat, targetRepoAPIA, targetRepoAPIM, logMessage, log, counter);
                        IngestLogger.closeLog(log, logRootName);
                        Ingest.summarize(counter, logFile);
                    }
                } else {
                    Ingest.badArgs("First argument must start with f, d, or r.");
                }
            }
            catch (Exception e) {
                System.err.print("Error  : ");
                if (e.getMessage() == null) {
                    e.printStackTrace();
                } else {
                    System.err.print(e.getMessage());
                }
                System.err.println();
                if (LAST_PATH == null) break block23;
                System.out.println("(Last attempted file was " + LAST_PATH + ")");
            }
        }
    }

    static {
        _FILE_COMPARATOR = new FileComparator();
    }
}

