/*
 * Decompiled with CFR 0.152.
 */
package fedora.common;

import fedora.common.Constants;
import fedora.common.rdf.RDFName;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;

public abstract class Models {
    public static final RDFName SERVICE_DEFINITION_3_0 = Models.getSystemURI("ServiceDefinition-3.0");
    public static final RDFName SERVICE_DEPLOYMENT_3_0 = Models.getSystemURI("ServiceDeployment-3.0");
    public static final RDFName CONTENT_MODEL_3_0 = Models.getSystemURI("ContentModel-3.0");
    public static final RDFName FEDORA_OBJECT_3_0;
    public static final RDFName FEDORA_OBJECT_CURRENT;
    private static Set<String> m_values;

    private static RDFName getSystemURI(String identity) {
        return new RDFName(Constants.FEDORA, "fedora-system:" + identity);
    }

    public static boolean contains(String model) {
        return m_values.contains(model);
    }

    public static boolean isBasicModel(String model) {
        return Models.FEDORA_OBJECT_3_0.uri.equals(model);
    }

    static {
        FEDORA_OBJECT_CURRENT = FEDORA_OBJECT_3_0 = Models.getSystemURI("FedoraObject-3.0");
        m_values = new HashSet<String>();
        for (Field field : Models.class.getFields()) {
            if (!field.getType().equals(RDFName.class) || !Modifier.isPublic(field.getModifiers())) continue;
            try {
                m_values.add(((RDFName)field.get(null)).uri);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

