/*
 * Decompiled with CFR 0.152.
 */
package fedora.common.rdf;

import java.net.URI;
import org.jrdf.graph.Literal;
import org.jrdf.graph.Node;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.URIReference;

public abstract class JRDF {
    public static boolean sameNode(Node n1, Node n2) {
        if (n1 instanceof URIReference && n2 instanceof URIReference) {
            return JRDF.sameResource((URIReference)n1, (URIReference)n2);
        }
        if (n1 instanceof Literal && n2 instanceof Literal) {
            return JRDF.sameLiteral((Literal)n1, (Literal)n2);
        }
        return false;
    }

    public static boolean sameResource(URIReference u1, URIReference u2) {
        return JRDF.sameResource(u1, u2.getURI().toString());
    }

    public static boolean sameResource(URIReference u1, String u2) {
        return u1.getURI().toString().equals(u2);
    }

    public static boolean sameLiteral(Literal l1, Literal l2) {
        String type = null;
        URI l2Type = l2.getDatatypeURI();
        if (l2Type != null) {
            type = l2Type.toString();
        }
        return JRDF.sameLiteral(l1, l2.getLexicalForm(), type, l2.getLanguage());
    }

    public static boolean sameLiteral(Literal l1, String l2, String type, String lang) {
        if (l1.getLexicalForm().equals(l2) && JRDF.eq(l1.getLanguage(), lang)) {
            if (l1.getDatatypeURI() == null) {
                return type == null;
            }
            return type != null && type.equals(l1.getDatatypeURI().toString());
        }
        return false;
    }

    public static boolean sameSubject(SubjectNode s1, SubjectNode s2) {
        if (s1 instanceof URIReference && s2 instanceof URIReference) {
            return JRDF.sameResource((URIReference)s1, (URIReference)s2);
        }
        return false;
    }

    public static boolean sameSubject(SubjectNode s1, String s2) {
        if (s1 instanceof URIReference) {
            return JRDF.sameResource((URIReference)s1, s2);
        }
        return false;
    }

    public static boolean samePredicate(PredicateNode p1, PredicateNode p2) {
        return JRDF.sameResource((URIReference)p1, (URIReference)p2);
    }

    public static boolean samePredicate(PredicateNode p1, String p2) {
        return JRDF.sameResource((URIReference)p1, p2);
    }

    public static boolean sameObject(ObjectNode o1, ObjectNode o2) {
        return JRDF.sameNode((Node)o1, (Node)o2);
    }

    public static boolean sameObject(ObjectNode o1, String o2, boolean isLiteral, String type, String lang) {
        if (o1 instanceof URIReference) {
            return JRDF.sameResource((URIReference)o1, o2);
        }
        if (o1 instanceof Literal || isLiteral) {
            return JRDF.sameLiteral((Literal)o1, o2, type, lang);
        }
        return false;
    }

    private static boolean eq(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return b != null && a.equals(b);
    }
}

