/*
 * Decompiled with CFR 0.152.
 */
package fedora.server;

import fedora.common.Constants;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Parameterized
implements Constants {
    private Map<String, String> m_parameters;

    public Parameterized() {
        this.setParameters(null);
    }

    public Parameterized(Map<String, String> parameters) {
        this.setParameters(parameters);
    }

    protected final void setParameters(Map<String, String> parameters) {
        this.m_parameters = parameters;
        if (this.m_parameters == null) {
            this.m_parameters = new HashMap<String, String>();
        }
    }

    public final String getParameter(String name, boolean asAbsolutePath) {
        File f;
        String paramValue = this.m_parameters.get(name);
        if (asAbsolutePath && paramValue != null && !(f = new File(paramValue)).isAbsolute()) {
            paramValue = FEDORA_HOME + File.separator + paramValue;
        }
        return paramValue;
    }

    public final String getParameter(String name) {
        return this.getParameter(name, false);
    }

    protected final void setParameter(String name, String value) {
        this.m_parameters.put(name, value);
    }

    public Map<String, String> getParameters() {
        return this.m_parameters;
    }

    public final Iterator<String> parameterNames() {
        return this.m_parameters.keySet().iterator();
    }
}

