/*
 * Decompiled with CFR 0.152.
 */
package fedora.server.utilities.status;

import fedora.server.utilities.status.ServerState;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ServerStatusMessage {
    public static final ServerStatusMessage NEW_SERVER_MESSAGE = new ServerStatusMessage(ServerState.NEW_SERVER, null, null);
    public static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ssa z";
    private final ServerState _state;
    private Date _date;
    private String _detail;

    public ServerStatusMessage(ServerState state, Date time, String detail) {
        this._state = state;
        this._date = time;
        if (this._date == null) {
            this._date = new Date();
        }
        if (detail != null) {
            this._detail = detail.trim();
        }
    }

    public ServerState getState() {
        return this._state;
    }

    public Date getDate() {
        return this._date;
    }

    public String getDetail() {
        return this._detail;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("STATE  : " + this._state.getName() + "\n");
        out.append("AS OF  : " + ServerStatusMessage.dateToString(this._date) + "\n");
        if (this._detail != null) {
            out.append("DETAIL : " + this._detail + "\n");
        }
        return out.toString();
    }

    public static String dateToString(Date d) {
        SimpleDateFormat formatter = new SimpleDateFormat(TIME_FORMAT);
        return formatter.format(d);
    }

    public static Date stringToDate(String s) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(TIME_FORMAT);
        return formatter.parse(s);
    }
}

