/*
 * Decompiled with CFR 0.152.
 */
package fedora.swing.mdi;

import fedora.swing.mdi.MDIDesktopPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class WindowMenu
extends JMenu {
    private static final long serialVersionUID = 1L;
    private final MDIDesktopPane desktop;
    private final JMenuItem cascade = new JMenuItem("Cascade");
    private final JMenuItem tile = new JMenuItem("Tile");
    private final JMenuItem minAll = new JMenuItem("Minimize All");
    private final JMenuItem restoreAll = new JMenuItem("Restore All");

    public WindowMenu(MDIDesktopPane desktop, String name) {
        super(name);
        this.desktop = desktop;
        this.cascade.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.desktop.cascadeFrames();
            }
        });
        this.tile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.desktop.tileFrames();
            }
        });
        this.minAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.desktop.minimizeFrames();
            }
        });
        this.restoreAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.desktop.restoreFrames();
            }
        });
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
                WindowMenu.this.removeAll();
            }

            public void menuSelected(MenuEvent e) {
                WindowMenu.this.buildChildMenus();
            }
        });
    }

    private void buildChildMenus() {
        JInternalFrame[] array = this.desktop.getAllFrames();
        this.add(this.cascade);
        this.add(this.tile);
        this.add(this.minAll);
        this.add(this.restoreAll);
        if (array.length > 0) {
            this.addSeparator();
        }
        this.cascade.setEnabled(array.length > 0);
        this.tile.setEnabled(array.length > 0);
        this.minAll.setEnabled(this.desktop.deIconifiedFrames() > 0);
        this.restoreAll.setEnabled(this.desktop.iconifiedFrames() > 0);
        for (int i = 0; i < array.length; ++i) {
            ChildMenuItem menu = new ChildMenuItem(array[i]);
            menu.setState(i == 0);
            menu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JInternalFrame frame = ((ChildMenuItem)ae.getSource()).getFrame();
                    frame.moveToFront();
                    try {
                        frame.setSelected(true);
                    }
                    catch (PropertyVetoException e) {
                        e.printStackTrace();
                    }
                }
            });
            menu.setIcon(array[i].getFrameIcon());
            this.add(menu);
        }
    }

    class ChildMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 1L;
        private final JInternalFrame frame;

        public ChildMenuItem(JInternalFrame frame) {
            super(frame.getTitle());
            this.frame = frame;
        }

        public JInternalFrame getFrame() {
            return this.frame;
        }
    }
}

