/*
 * Decompiled with CFR 0.152.
 */
package proai.cache;

import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import proai.CloseableIterator;
import proai.MetadataFormat;
import proai.SetInfo;
import proai.cache.CachedMetadataFormat;
import proai.cache.ParsedRecord;
import proai.cache.RCDisk;
import proai.cache.RecordCache;
import proai.cache.StringResultIterator;
import proai.driver.impl.RemoteIteratorImpl;
import proai.driver.impl.SetInfoImpl;
import proai.error.ServerException;
import proai.util.DBUtil;
import proai.util.DDLConverter;
import proai.util.TableSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RCDatabase {
    private static final Logger logger = Logger.getLogger((String)RCDatabase.class.getName());
    public static final String RCADMIN_TABLE_IS_EMPTY = "rcAdmin table is empty";
    private boolean m_backslashIsEscape;
    private boolean m_mySQLTrickling;
    private RCDisk m_rcDisk;

    public RCDatabase(Connection conn, DDLConverter ddlc, boolean mySQLTrickling, boolean backslashIsEscape, boolean pollingEnabled, RCDisk rcDisk) throws ServerException {
        this.m_mySQLTrickling = mySQLTrickling;
        this.m_backslashIsEscape = backslashIsEscape;
        this.m_rcDisk = rcDisk;
        if (!this.tablesExist(conn)) {
            this.createTables(conn, ddlc);
        }
        this.createAdminRowIfNeeded(conn);
        this.setPollingEnabled(conn, pollingEnabled);
    }

    private String qs(String in) {
        return DBUtil.quotedString(in, this.m_backslashIsEscape);
    }

    private String qsc(String in) {
        return DBUtil.quotedString(in, this.m_backslashIsEscape) + ", ";
    }

    private String qss(String in) {
        return DBUtil.quotedString(in, this.m_backslashIsEscape) + " ";
    }

    private static ResultSet executeQuery(Statement stmt, String sql) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing query: " + sql));
        }
        return stmt.executeQuery(sql);
    }

    private static int executeUpdate(Statement stmt, String sql) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing update: " + sql));
        }
        return stmt.executeUpdate(sql);
    }

    public String getIdentifyPath(Connection conn) throws ServerException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getStatement(conn, false);
            rs = RCDatabase.executeQuery(stmt, "SELECT identifyPath FROM rcAdmin");
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            try {
                throw new ServerException(RCADMIN_TABLE_IS_EMPTY);
            }
            catch (SQLException e) {
                throw new ServerException("Error reading rcAdmin.identifyPath", e);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private Statement getStatement(Connection conn, boolean possiblyLong) throws SQLException {
        if (this.m_mySQLTrickling && possiblyLong) {
            Statement stmt = conn.createStatement(1003, 1007);
            stmt.setFetchSize(Integer.MIN_VALUE);
            return stmt;
        }
        return conn.createStatement();
    }

    public void setIdentifyPath(Connection conn, String path) throws ServerException {
        Statement stmt = null;
        try {
            String xmlPathToPrune = this.getIdentifyPath(conn);
            stmt = this.getStatement(conn, false);
            String sql = path == null ? "UPDATE rcAdmin SET identifyPath = NULL" : "UPDATE rcAdmin SET identifyPath = " + this.qs(path);
            RCDatabase.executeUpdate(stmt, sql);
            if (xmlPathToPrune != null) {
                this.addPrunable(stmt, xmlPathToPrune);
            }
        }
        catch (SQLException se) {
            throw new ServerException("Error setting rcAdmin.identifyPath", se);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public void setPollingEnabled(Connection conn, boolean pollingEnabled) throws ServerException {
        Statement stmt = null;
        try {
            stmt = this.getStatement(conn, false);
            int val = 0;
            if (pollingEnabled) {
                val = 1;
            }
            RCDatabase.executeUpdate(stmt, "UPDATE rcAdmin SET pollingEnabled = " + val);
        }
        catch (SQLException se) {
            throw new ServerException("Error setting rcAdmin.pollingEnabled", se);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public boolean isPollingEnabled(Connection conn) throws ServerException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getStatement(conn, false);
            rs = RCDatabase.executeQuery(stmt, "SELECT pollingEnabled FROM rcAdmin");
            rs.next();
            boolean bl = rs.getInt(1) == 1;
            return bl;
        }
        catch (SQLException e) {
            throw new ServerException("Error reading rcAdmin.pollingEnabled", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void putFormat(Connection conn, MetadataFormat format) throws ServerException {
        String newprefix = format.getPrefix();
        String newuri = format.getNamespaceURI();
        String newloc = format.getSchemaLocation();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getStatement(conn, false);
            String sql = "SELECT formatKey, namespaceURI, schemaLocation FROM rcFormat WHERE mdPrefix = " + this.qs(newprefix);
            rs = RCDatabase.executeQuery(stmt, sql);
            if (rs.next()) {
                int key = rs.getInt(1);
                String uri = rs.getString(2);
                String loc = rs.getString(3);
                if (!uri.equals(newuri) || !loc.equals(newloc)) {
                    logger.info((Object)("Format " + newprefix + " changed.  Updating in db."));
                    sql = "UPDATE rcFormat SET namespaceURI = " + this.qsc(newuri) + "schemaLocation = " + this.qss(newloc) + "WHERE formatKey = " + key;
                    RCDatabase.executeUpdate(stmt, sql);
                }
            } else {
                logger.info((Object)("Format " + newprefix + " is new.  Adding to db."));
                sql = "INSERT INTO rcFormat (mdPrefix, namespaceURI, schemaLocation) VALUES (" + this.qsc(newprefix) + this.qsc(newuri) + this.qs(newloc) + ")";
                RCDatabase.executeUpdate(stmt, sql);
            }
        }
        catch (SQLException se) {
            throw new ServerException("Unable to add/modify format in cache db", se);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public long getEarliestPollDate(Connection conn) throws ServerException {
        try {
            return this.getLongValue(conn, "SELECT lastPollDate FROM rcFormat ORDER BY lastPollDate ASC");
        }
        catch (SQLException e) {
            throw new ServerException("Error getting earliest poll date", e);
        }
    }

    public long getLastPollDate(Connection conn, String mdPrefix) throws ServerException {
        try {
            return this.getLongValue(conn, "SELECT lastPollDate FROM rcFormat WHERE mdPrefix = " + this.qs(mdPrefix));
        }
        catch (SQLException e) {
            throw new ServerException("Error getting last poll date", e);
        }
    }

    public void setLastPollDate(Connection conn, String mdPrefix, long lastPollDate) throws ServerException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getStatement(conn, false);
            RCDatabase.executeUpdate(stmt, "UPDATE rcFormat SET lastPollDate = " + lastPollDate + " " + "WHERE mdPrefix = " + this.qs(mdPrefix));
        }
        catch (SQLException e) {
            throw new ServerException("Error setting last poll date", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLongValue(Connection conn, String query) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getStatement(conn, true);
            rs = RCDatabase.executeQuery(stmt, query);
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public List<CachedMetadataFormat> getFormats(Connection conn) throws ServerException {
        return this.getFormats(conn, null);
    }

    public List<CachedMetadataFormat> getFormats(Connection conn, String identifier) throws ServerException {
        ArrayList<CachedMetadataFormat> list = new ArrayList<CachedMetadataFormat>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getStatement(conn, false);
            String query = identifier == null ? "SELECT formatKey, mdPrefix, namespaceURI, schemaLocation FROM rcFormat" : "SELECT rcFormat.formatKey, rcFormat.mdPrefix, rcFormat.namespaceURI, rcFormat.schemaLocation FROM rcFormat, rcItem, rcRecord WHERE rcItem.identifier = " + this.qss(identifier) + "AND rcRecord.itemKey = rcItem.itemKey " + "AND rcRecord.formatKey = rcFormat.formatKey";
            rs = RCDatabase.executeQuery(stmt, query);
            while (rs.next()) {
                list.add(new CachedMetadataFormat(rs.getInt(1), rs.getString(2), rs.getString(3), rs.getString(4)));
            }
            ArrayList<CachedMetadataFormat> arrayList = list;
            return arrayList;
        }
        catch (SQLException e) {
            throw new ServerException("Error reading rcFormat", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public Map<String, Integer> getFormatKeyMap(Connection conn) throws ServerException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (CachedMetadataFormat format : this.getFormats(conn)) {
            map.put(format.getPrefix(), new Integer(format.getKey()));
        }
        return map;
    }

    public void deleteFormat(Connection conn, String prefix) throws ServerException {
        block17: {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                logger.info((Object)("Deleting format: " + prefix));
                stmt = this.getStatement(conn, false);
                rs = RCDatabase.executeQuery(stmt, "SELECT formatKey FROM rcFormat WHERE mdPrefix = " + this.qs(prefix));
                if (rs.next()) {
                    int formatKey = rs.getInt(1);
                    RCDatabase.executeUpdate(stmt, "DELETE FROM rcFormat WHERE formatKey = " + formatKey);
                    rs.close();
                    String selectRecordKey = "SELECT recordKey, xmlPath FROM rcRecord WHERE formatKey = " + formatKey;
                    rs = RCDatabase.executeQuery(stmt, selectRecordKey);
                    while (rs.next()) {
                        int recordKey = rs.getInt(1);
                        String xmlPathToPrune = rs.getString(2);
                        RCDatabase.executeUpdate(stmt, "DELETE from rcMembership WHERE recordKey = " + recordKey);
                        this.addPrunable(stmt, xmlPathToPrune);
                    }
                    RCDatabase.executeUpdate(stmt, "DELETE FROM rcRecord WHERE formatKey = " + formatKey);
                    break block17;
                }
                throw new ServerException("Format does not exist in rcFormat table: " + prefix);
            }
            catch (SQLException e) {
                throw new ServerException("Error deleting format: " + prefix, e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public void putSetInfo(Connection conn, String setSpec, String xmlPath) throws ServerException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getStatement(conn, false);
            rs = RCDatabase.executeQuery(stmt, "SELECT setKey, xmlPath FROM rcSet WHERE setSpec = " + this.qs(setSpec));
            if (rs.next()) {
                int setKey = rs.getInt(1);
                String xmlPathToPrune = rs.getString(2);
                logger.info((Object)("Set " + setSpec + " exists. Updating in db."));
                rs.close();
                RCDatabase.executeUpdate(stmt, "UPDATE rcSet SET xmlPath = " + this.qss(xmlPath) + "WHERE setKey = " + setKey);
                this.addPrunable(stmt, xmlPathToPrune);
            } else {
                logger.info((Object)("Set " + setSpec + " is new. Adding to db."));
                RCDatabase.executeUpdate(stmt, "INSERT INTO rcSet (setSpec, xmlPath) VALUES (" + this.qsc(setSpec) + this.qs(xmlPath) + ")");
            }
        }
        catch (SQLException e) {
            throw new ServerException("Error reading rcSet", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public List<SetInfo> getSetInfo(Connection conn) throws ServerException {
        ArrayList<SetInfo> list = new ArrayList<SetInfo>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getStatement(conn, false);
            rs = RCDatabase.executeQuery(stmt, "SELECT setSpec, xmlPath FROM rcSet");
            while (rs.next()) {
                list.add(new SetInfoImpl(rs.getString(1), this.m_rcDisk.getFile(rs.getString(2))));
            }
            ArrayList<SetInfo> arrayList = list;
            return arrayList;
        }
        catch (SQLException e) {
            throw new ServerException("Error reading rcSet", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public List<String[]> getSetInfoPaths(Connection conn) throws ServerException {
        String[] list = new ArrayList();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String[] a;
            stmt = this.getStatement(conn, false);
            rs = RCDatabase.executeQuery(stmt, "SELECT xmlPath FROM rcSet");
            while (rs.next()) {
                a = new String[]{rs.getString(1)};
                list.add(a);
            }
            a = list;
            return a;
        }
        catch (SQLException e) {
            throw new ServerException("Error reading rcSet", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void deleteSet(Connection conn, String setSpec) throws ServerException {
        block16: {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                logger.info((Object)("Deleting set: " + setSpec));
                stmt = this.getStatement(conn, false);
                rs = RCDatabase.executeQuery(stmt, "SELECT setKey, xmlPath FROM rcSet WHERE setSpec = " + this.qs(setSpec));
                if (rs.next()) {
                    int setKey = rs.getInt(1);
                    String xmlPathToPrune = rs.getString(2);
                    rs.close();
                    RCDatabase.executeUpdate(stmt, "DELETE from rcSet WHERE setKey = " + setKey);
                    RCDatabase.executeUpdate(stmt, "DELETE from rcMembership WHERE setKey = " + setKey);
                    this.addPrunable(stmt, xmlPathToPrune);
                    break block16;
                }
                throw new ServerException("Set does not exist in rcSet table: " + setSpec);
            }
            catch (SQLException e) {
                throw new ServerException("Error deleting set: " + setSpec, e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public void setUncommittedRecordDates(Connection conn, Date newDate) throws ServerException {
        Statement stmt = null;
        try {
            stmt = this.getStatement(conn, false);
            RCDatabase.executeUpdate(stmt, "UPDATE rcRecord SET modDate = " + newDate.getTime() + " WHERE modDate IS NULL");
        }
        catch (SQLException e) {
            throw new ServerException("Error setting uncommitted record dates", e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void putRecord(Connection conn, ParsedRecord rec, Map<String, Integer> formatKeyMap) throws ServerException {
        block23: {
            String xmlPath = rec.getSourceInfo();
            Statement stmt = null;
            ResultSet rs = null;
            try {
                logger.info((Object)("Putting record: " + rec.getItemID() + " (" + rec.getPrefix() + ")"));
                int itemKey = this.getItemKey(conn, rec.getItemID());
                Integer fKey = formatKeyMap.get(rec.getPrefix());
                if (fKey == null) {
                    throw new ServerException("Error in parsed record; no such format in cache: " + rec.getPrefix());
                }
                int formatKey = fKey;
                stmt = this.getStatement(conn, false);
                int[] setKeys = this.getSetKeys(stmt, rec.getSetSpecs());
                rs = RCDatabase.executeQuery(stmt, "SELECT recordKey, xmlPath FROM rcRecord WHERE itemKey = " + itemKey + " " + "AND formatKey = " + formatKey);
                if (rs.next()) {
                    int recordKey = rs.getInt(1);
                    String xmlPathToPrune = rs.getString(2);
                    rs.close();
                    RCDatabase.executeUpdate(stmt, "UPDATE rcRecord SET modDate = NULL, xmlPath = " + this.qss(xmlPath) + "WHERE recordKey = " + recordKey);
                    this.addPrunable(stmt, xmlPathToPrune);
                    ArrayList<Integer> priorSetKeys = new ArrayList<Integer>();
                    rs = RCDatabase.executeQuery(stmt, "SELECT setKey from rcMembership WHERE recordKey = " + recordKey);
                    while (rs.next()) {
                        priorSetKeys.add(new Integer(rs.getInt(1)));
                    }
                    rs.close();
                    rs = null;
                    for (int i = 0; i < setKeys.length; ++i) {
                        Integer newSetKey = new Integer(setKeys[i]);
                        if (priorSetKeys.contains(newSetKey)) continue;
                        int nsk = newSetKey;
                        RCDatabase.executeUpdate(stmt, "INSERT INTO rcMembership (setKey, recordKey) VALUES (" + nsk + ", " + recordKey + ")");
                    }
                    for (Integer priorSetKey : priorSetKeys) {
                        int psk = priorSetKey;
                        boolean noLongerInSet = true;
                        for (int i = 0; i < setKeys.length; ++i) {
                            if (setKeys[i] != psk) continue;
                            noLongerInSet = false;
                        }
                        if (!noLongerInSet) continue;
                        RCDatabase.executeUpdate(stmt, "DELETE FROM rcMembership WHERE recordKey = " + recordKey + " " + "AND setKey = " + psk);
                    }
                    break block23;
                }
                rs.close();
                RCDatabase.executeUpdate(stmt, "INSERT INTO rcRecord (itemKey, formatKey, modDate, xmlPath) VALUES (" + itemKey + ", " + formatKey + ", NULL, " + this.qs(xmlPath) + ")");
                rs = RCDatabase.executeQuery(stmt, "SELECT recordKey from rcRecord WHERE itemKey = " + itemKey + " " + "AND formatKey = " + formatKey);
                if (rs.next()) {
                    int recordKey = rs.getInt(1);
                    rs.close();
                    for (int i = 0; i < setKeys.length; ++i) {
                        RCDatabase.executeUpdate(stmt, "INSERT INTO rcMembership (setKey, recordKey) VALUES (" + setKeys[i] + ", " + recordKey + ")");
                    }
                    break block23;
                }
                throw new ServerException("Insert into rcRecord didn't work (itemkey, formatkey = " + itemKey + ", " + formatKey + ")");
            }
            catch (SQLException e) {
                throw new ServerException("Error putting record", e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private int[] getSetKeys(Statement stmt, List<String> specs) throws ServerException {
        ResultSet rs = null;
        try {
            int[] keys = new int[specs.size()];
            for (int i = 0; i < specs.size(); ++i) {
                rs = RCDatabase.executeQuery(stmt, "SELECT setKey from rcSet WHERE setSpec = " + this.qs(specs.get(i)));
                if (!rs.next()) {
                    throw new ServerException("Record contains setSpec not listed sets: " + specs.get(i));
                }
                keys[i] = rs.getInt(1);
            }
            int[] nArray = keys;
            return nArray;
        }
        catch (SQLException e) {
            throw new ServerException("Unable to get setKey(s) for record's setSpec(s)", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getItemKey(Connection conn, String itemID) throws ServerException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getStatement(conn, false);
            rs = RCDatabase.executeQuery(stmt, "SELECT itemKey from rcItem where identifier = " + this.qs(itemID));
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            rs.close();
            RCDatabase.executeUpdate(stmt, "INSERT INTO rcItem (identifier) VALUES (" + this.qs(itemID) + ")");
            rs = RCDatabase.executeQuery(stmt, "SELECT itemKey from rcItem where identifier = " + this.qs(itemID));
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            throw new ServerException("Insert into rcItem didn't work (identifier = " + itemID + ")");
        }
        catch (SQLException e) {
            throw new ServerException("Error getting key for itemID " + itemID, e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean itemExists(Connection conn, String itemID) throws ServerException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getStatement(conn, false);
            rs = RCDatabase.executeQuery(stmt, "SELECT itemKey from rcItem where identifier = " + this.qs(itemID));
            boolean bl = rs.next();
            return bl;
        }
        catch (SQLException e) {
            throw new ServerException("Error determining if item exists: " + itemID, e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public String[] getRecordInfo(Connection conn, String itemID, String mdPrefix) throws ServerException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.getStatement(conn, false);
            rs = RCDatabase.executeQuery(stmt, "SELECT rcRecord.xmlPath, rcRecord.modDate from rcItem, rcRecord, rcFormat WHERE rcItem.identifier = " + this.qss(itemID) + "AND rcItem.itemKey = rcRecord.itemKey " + "AND rcRecord.formatKey = rcFormat.formatKey " + "AND rcFormat.mdPrefix = " + this.qs(mdPrefix));
            if (rs.next()) {
                String path = rs.getString(1);
                Date d = new Date(rs.getLong(2));
                String dateString = null;
                try {
                    dateString = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(d);
                }
                catch (Exception e) {
                    // empty catch block
                }
                String[] stringArray = new String[]{path, dateString};
                return stringArray;
            }
            String[] path = null;
            return path;
        }
        catch (SQLException e) {
            throw new ServerException("Error determining if item exists: " + itemID, e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public CloseableIterator<String[]> findRecordInfo(Connection conn, Date from, Date until, String prefix, String set) throws ServerException {
        if (from != null && until != null && from.getTime() == until.getTime()) {
            until.setTime(until.getTime() + 999L);
        }
        Statement stmt = null;
        ResultSet rs = null;
        boolean releaseConnectionBeforeReturning = true;
        try {
            stmt = this.getStatement(conn, true);
            rs = RCDatabase.executeQuery(stmt, "SELECT formatKey FROM rcFormat WHERE mdPrefix = " + this.qs(prefix));
            if (!rs.next()) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                RemoteIteratorImpl<String[]> e = new RemoteIteratorImpl<String[]>(new ArrayList().iterator());
                return e;
            }
            int formatKey = rs.getInt(1);
            rs.close();
            int setKey = -1;
            if (set != null) {
                rs = RCDatabase.executeQuery(stmt, "SELECT setKey FROM rcSet WHERE setSpec = " + this.qs(set));
                if (!rs.next()) {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    RemoteIteratorImpl<String[]> e = new RemoteIteratorImpl<String[]>(new ArrayList().iterator());
                    return e;
                }
                setKey = rs.getInt(1);
                rs.close();
            }
            StringBuffer query = new StringBuffer();
            if (set == null) {
                query.append("SELECT xmlPath, modDate FROM rcRecord WHERE formatKey = " + formatKey);
            } else {
                query.append("SELECT rcRecord.xmlPath, rcRecord.modDate FROM rcMembership, rcRecord WHERE rcMembership.setKey = " + setKey + " " + "AND rcMembership.recordKey = rcRecord.recordKey " + "AND rcRecord.formatKey = " + formatKey);
            }
            if (from == null) {
                if (until != null) {
                    query.append(" AND rcRecord.modDate <= " + until.getTime());
                }
            } else if (until == null) {
                query.append(" AND rcRecord.modDate >= " + from.getTime());
            } else {
                query.append(" AND rcRecord.modDate >= " + from.getTime());
                query.append(" AND rcRecord.modDate <= " + until.getTime());
            }
            rs = RCDatabase.executeQuery(stmt, query.toString());
            releaseConnectionBeforeReturning = false;
            StringResultIterator stringResultIterator = new StringResultIterator(conn, stmt, rs);
            return stringResultIterator;
        }
        catch (SQLException se) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw new ServerException("Error finding record paths", se);
        }
        finally {
            if (releaseConnectionBeforeReturning) {
                RecordCache.releaseConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tablesExist(Connection conn) throws ServerException {
        Statement stmt = null;
        ResultSet results = null;
        try {
            stmt = this.getStatement(conn, false);
            results = RCDatabase.executeQuery(stmt, "SELECT * from rcAdmin");
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTables(Connection conn, DDLConverter ddlc) throws ServerException {
        List<TableSpec> specs;
        logger.debug((Object)"Creating tables...");
        try {
            InputStream in = this.getClass().getResourceAsStream("/dbspec.xml");
            specs = TableSpec.getTableSpecs(in);
        }
        catch (Exception e) {
            throw new ServerException("Unable to initialize tablespecs", e);
        }
        ArrayList<String> createdCommands = new ArrayList<String>();
        Iterator<TableSpec> iter = specs.iterator();
        Statement stmt = null;
        String tableName = null;
        String command = null;
        try {
            stmt = this.getStatement(conn, false);
            while (iter.hasNext()) {
                TableSpec spec = iter.next();
                tableName = spec.getName();
                logger.info((Object)("Creating " + tableName + " table"));
                List<String> commands = ddlc.getDDL(spec);
                for (int i = 0; i < commands.size(); ++i) {
                    command = commands.get(i);
                    RCDatabase.executeUpdate(stmt, command);
                    createdCommands.add(command);
                }
            }
        }
        catch (Exception e) {
            StringBuffer msg = new StringBuffer();
            msg.append("Error creating table: " + tableName + ".  The following command failed:\n" + command);
            String dropCmd = "(unknown)";
            if (createdCommands.size() > 0) {
                Statement dstmt = null;
                try {
                    dstmt = this.getStatement(conn, false);
                    for (int i = 0; i < createdCommands.size(); ++i) {
                        String createdCommand = (String)createdCommands.get(i);
                        dropCmd = ddlc.getDropDDL(createdCommand);
                        RCDatabase.executeUpdate(stmt, dropCmd);
                    }
                }
                catch (Exception ex) {
                    msg.append("\nWARNING: An additional error occurred while attempting to drop partially-created tables, while running the following command:\n");
                    msg.append(dropCmd);
                    String ae = ex.getClass().getName() + ": " + ex.getMessage();
                    msg.append("\nThe additional error was: " + ae);
                    msg.append("\nBefore trying again, you should manually drop any remaining tables or other database objects created by this process.");
                }
                finally {
                    if (dstmt != null) {
                        try {
                            dstmt.close();
                        }
                        catch (Exception ex) {}
                    }
                }
            }
            throw new ServerException(msg.toString(), e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private void createAdminRowIfNeeded(Connection conn) throws ServerException {
        try {
            this.getIdentifyPath(conn);
        }
        catch (ServerException e) {
            if (e.getMessage().equals(RCADMIN_TABLE_IS_EMPTY)) {
                Statement stmt = null;
                try {
                    stmt = this.getStatement(conn, false);
                    RCDatabase.executeUpdate(stmt, "INSERT INTO rcAdmin (pollingEnabled) VALUES (1)");
                }
                catch (SQLException se) {
                    throw new ServerException("Error creating initial rcAdmin row", se);
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception ex) {}
                    }
                }
            }
            throw new ServerException("Error determining if rcAdmin table is empty", e);
        }
    }

    public void queueFailedRecords(Connection conn, int maxFailedRetries) throws ServerException {
        if (maxFailedRetries > 0) {
            Statement stmt = null;
            ResultSet results = null;
            Connection queueConn = null;
            if (this.m_mySQLTrickling) {
                try {
                    queueConn = RecordCache.getConnection();
                }
                catch (SQLException se) {
                    throw new ServerException("Unable to get additional connection for queueing failed records", se);
                }
            }
            try {
                stmt = this.getStatement(conn, true);
                results = RCDatabase.executeQuery(stmt, "SELECT identifier, mdPrefix, sourceInfo FROM rcFailure WHERE failCount <= " + maxFailedRetries);
                while (results.next()) {
                    if (queueConn != null) {
                        this.queueFailedRecord(queueConn, results.getString(1), results.getString(2), DBUtil.getLongString(results, 3));
                        continue;
                    }
                    this.queueFailedRecord(conn, results.getString(1), results.getString(2), DBUtil.getLongString(results, 3));
                }
            }
            catch (SQLException e) {
                throw new ServerException("Failed while attempting to enqueue failed records", e);
            }
            finally {
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (Exception ex) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception ex) {}
                }
                if (queueConn != null) {
                    try {
                        queueConn.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueFailedRecord(Connection conn, String identifier, String mdPrefix, String sourceInfo) throws SQLException {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            RCDatabase.executeUpdate(stmt, this.getQueueInsertSQL(identifier, mdPrefix, sourceInfo, 'F'));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private String getQueueInsertSQL(String identifier, String mdPrefix, String sourceInfo, char queueSource) {
        if (sourceInfo.indexOf("\n") != -1 || sourceInfo.indexOf("\r") != -1) {
            throw new ServerException("INSERT aborted: bad sourceInfo for " + identifier + "/" + mdPrefix + " (contains " + "newline(s))");
        }
        return "INSERT INTO rcQueue (identifier, mdPrefix, sourceInfo, queueSource) VALUES (" + this.qsc(identifier) + this.qsc(mdPrefix) + this.qsc(sourceInfo) + "'" + queueSource + "')";
    }

    public void queueRemoteRecord(Connection conn, String identifier, String mdPrefix, String sourceInfo) throws ServerException {
        Statement stmt = null;
        ResultSet results = null;
        try {
            stmt = conn.createStatement();
            RCDatabase.executeUpdate(stmt, this.getQueueInsertSQL(identifier, mdPrefix, sourceInfo, 'R'));
        }
        catch (SQLException e) {
            throw new ServerException("Failed while attempting to enqueue remote record", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public int getQueueSize(Connection conn) throws ServerException {
        Statement stmt = null;
        ResultSet results = null;
        try {
            stmt = conn.createStatement();
            results = RCDatabase.executeQuery(stmt, "SELECT count(*) FROM rcQueue");
            results.next();
            int n = results.getInt(1);
            return n;
        }
        catch (SQLException e) {
            throw new ServerException("Failed to determine queue size", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public void dumpQueue(Connection conn, PrintWriter writer) throws ServerException {
        logger.info((Object)"Preparing queue for processing...");
        Statement stmt = null;
        ResultSet results = null;
        int resultCount = 0;
        try {
            stmt = conn.createStatement();
            results = RCDatabase.executeQuery(stmt, "SELECT queueKey, identifier, mdPrefix, sourceInfo, queueSource FROM rcQueue ORDER BY queueKey ASC");
            while (results.next()) {
                ++resultCount;
                writer.print(results.getInt(1) + " ");
                String identifier = results.getString(2);
                writer.print(identifier + " ");
                String mdPrefix = results.getString(3);
                writer.print(mdPrefix + " ");
                writer.print(results.getString(5) + " ");
                String sourceInfo = DBUtil.getLongString(results, 4);
                if (sourceInfo.indexOf("\n") != -1 || sourceInfo.indexOf("\r") != -1) {
                    throw new ServerException("rcQueue contains bad sourceInfo for " + identifier + "/" + mdPrefix + " (contains " + "newline(s)): '" + sourceInfo + "'");
                }
                writer.println(sourceInfo);
            }
        }
        catch (SQLException e) {
            throw new ServerException("Failed to dump queue", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
            if (resultCount > 0) {
                results = null;
                stmt = null;
                System.gc();
            }
        }
    }

    public void removeFromQueue(Connection conn, int queueKey) throws ServerException {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            RCDatabase.executeUpdate(stmt, "DELETE FROM rcQueue WHERE queueKey = " + queueKey);
        }
        catch (SQLException e) {
            throw new ServerException("Failed to remove record from queue", e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public void removeFailure(Connection conn, String identifier, String mdPrefix) throws ServerException {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            RCDatabase.executeUpdate(stmt, "DELETE FROM rcFailure WHERE identifier = " + this.qss(identifier) + "AND mdPrefix = " + this.qs(mdPrefix));
        }
        catch (SQLException e) {
            throw new ServerException("Failed to remove record from rcFailure", e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public int getFailCount(Connection conn, String identifier, String mdPrefix) {
        Statement stmt = null;
        ResultSet results = null;
        try {
            stmt = conn.createStatement();
            results = RCDatabase.executeQuery(stmt, "SELECT failCount FROM rcFailure WHERE identifier = " + this.qss(identifier) + "AND mdPrefix = " + this.qs(mdPrefix));
            if (results.next()) {
                int n = results.getInt(1);
                return n;
            }
            int n = -1;
            return n;
        }
        catch (SQLException e) {
            throw new ServerException("Failed to determine queue size", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public void addFailure(Connection conn, String identifier, String mdPrefix, String sourceInfo, String failDate, String failReason) throws ServerException {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            RCDatabase.executeUpdate(stmt, "INSERT INTO rcFailure (identifier, mdPrefix, sourceInfo, failCount, firstFailDate, lastFailDate, lastFailReason) VALUES (" + this.qsc(identifier) + this.qsc(mdPrefix) + this.qsc(sourceInfo) + "0, " + this.qsc(failDate) + this.qsc(failDate) + this.qs(failReason) + ")");
        }
        catch (SQLException e) {
            throw new ServerException("Failed to add row to rcFailure", e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public void updateFailure(Connection conn, String identifier, String mdPrefix, String sourceInfo, int newFailCount, String failDate, String failReason) throws ServerException {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            RCDatabase.executeUpdate(stmt, "UPDATE rcFailure SET sourceInfo = " + this.qs(sourceInfo) + ", " + "failCount = " + newFailCount + ", " + "lastFailDate = " + this.qsc(failDate) + "lastFailReason = " + this.qss(failReason) + "WHERE identifier = " + this.qss(identifier) + "AND mdPrefix = " + this.qs(mdPrefix));
        }
        catch (SQLException e) {
            throw new ServerException("Failed to update row in rcFailure", e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private void addPrunable(Statement stmt, String xmlPathToPrune) throws SQLException {
        RCDatabase.executeUpdate(stmt, "INSERT INTO rcPrunable (xmlPath) VALUES (" + this.qs(xmlPathToPrune) + ")");
    }

    public int getPrunableCount(Connection conn) throws ServerException {
        Statement stmt = null;
        ResultSet results = null;
        try {
            stmt = conn.createStatement();
            results = RCDatabase.executeQuery(stmt, "SELECT count(*) FROM rcPrunable");
            results.next();
            int n = results.getInt(1);
            return n;
        }
        catch (SQLException e) {
            throw new ServerException("Failed to determine prunable count", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePrunables(Connection conn, int[] keys, int num) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM rcPrunable WHERE pruneKey IN (");
        for (int i = 0; i < num; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(keys[i]);
        }
        sql.append(")");
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            RCDatabase.executeUpdate(stmt, sql.toString());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public int dumpPrunables(Connection conn, PrintWriter writer) throws ServerException {
        logger.info((Object)"Preparing list of prunable files in cache");
        Statement stmt = null;
        ResultSet results = null;
        int resultCount = 0;
        try {
            stmt = conn.createStatement();
            results = RCDatabase.executeQuery(stmt, "SELECT pruneKey, xmlPath FROM rcPrunable");
            while (results.next()) {
                ++resultCount;
                writer.println(results.getInt(1) + " " + results.getString(2));
            }
            int n = resultCount;
            return n;
        }
        catch (SQLException e) {
            throw new ServerException("Failed to dump prunables", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
            if (resultCount > 0) {
                results = null;
                stmt = null;
                System.gc();
            }
        }
    }
}

