/*
 * Decompiled with CFR 0.152.
 */
package proai.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import proai.Writable;
import proai.cache.CachedContent;
import proai.cache.RCDiskWriter;
import proai.error.ServerException;

public class RCDisk {
    public static final String PATH_DATE_PATTERN = "yyyy/MM/dd/HH/mm/ss.SSS.'xml'";
    private static final Logger logger = Logger.getLogger((String)RCDisk.class.getName());
    private File m_baseDir;
    private long _lastPathDate;

    public RCDisk(File baseDir) {
        this.m_baseDir = baseDir;
        if (!this.m_baseDir.exists()) {
            this.m_baseDir.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNewPath() {
        SimpleDateFormat formatter = new SimpleDateFormat(PATH_DATE_PATTERN);
        String path = null;
        RCDisk rCDisk = this;
        synchronized (rCDisk) {
            long now = System.currentTimeMillis();
            while (now == this._lastPathDate) {
                logger.debug((Object)"Path date collision... waiting for a unique date");
                try {
                    Thread.sleep(10L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
            }
            path = formatter.format(new Date(now));
            this._lastPathDate = now;
        }
        File dir = new File(this.m_baseDir, path.substring(0, 16));
        dir.mkdirs();
        return path;
    }

    public RCDiskWriter getNewWriter() throws ServerException {
        String path = this.getNewPath();
        try {
            return new RCDiskWriter(this.m_baseDir, path);
        }
        catch (Exception e) {
            throw new ServerException("Error creating new cache file: " + path, e);
        }
    }

    public String write(Writable writable) throws ServerException {
        String path = this.getNewPath();
        try {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.m_baseDir, path)), "UTF-8"));
            writable.write(writer);
            writer.close();
            return path;
        }
        catch (Exception e) {
            throw new ServerException("Error writing stream to file in cache: " + path, e);
        }
    }

    public File getFile(String path) {
        return new File(this.m_baseDir, path);
    }

    public CachedContent getContent(String path) {
        if (path == null) {
            return null;
        }
        return new CachedContent(this.getFile(path));
    }

    public CachedContent getContent(String path, String dateStamp, boolean headerOnly) {
        return new CachedContent(this.getFile(path), dateStamp, headerOnly);
    }

    public void delete(String path) {
        new File(this.m_baseDir, path).delete();
    }

    public void cancel(String path) throws ServerException {
        double second;
        int minute;
        int hour;
        int day;
        int month;
        int year;
        String[] parts = path.split("/");
        try {
            year = Integer.parseInt(parts[0]);
            month = Integer.parseInt(parts[1]);
            day = Integer.parseInt(parts[2]);
            hour = Integer.parseInt(parts[3]);
            minute = Integer.parseInt(parts[4]);
            second = Double.parseDouble(parts[5].substring(0, 6));
        }
        catch (Exception e) {
            throw new ServerException("Error parsing cache file path: " + path, e);
        }
        File[] yearDirs = this.m_baseDir.listFiles();
        if (yearDirs != null) {
            for (int yearIndex = 0; yearIndex < yearDirs.length; ++yearIndex) {
                block21: {
                    try {
                        File[] monthDirs;
                        if (Integer.parseInt(yearDirs[yearIndex].getName()) < year || (monthDirs = yearDirs[yearIndex].listFiles()) == null) break block21;
                        for (int monthIndex = 0; monthIndex < monthDirs.length; ++monthIndex) {
                            block22: {
                                try {
                                    File[] dayDirs;
                                    if (Integer.parseInt(monthDirs[monthIndex].getName()) < month || (dayDirs = monthDirs[monthIndex].listFiles()) == null) break block22;
                                    for (int dayIndex = 0; dayIndex < dayDirs.length; ++dayIndex) {
                                        block23: {
                                            try {
                                                File[] hourDirs;
                                                if (Integer.parseInt(dayDirs[dayIndex].getName()) < day || (hourDirs = dayDirs[dayIndex].listFiles()) == null) break block23;
                                                for (int hourIndex = 0; hourIndex < hourDirs.length; ++hourIndex) {
                                                    block24: {
                                                        try {
                                                            File[] minuteDirs;
                                                            if (Integer.parseInt(hourDirs[hourIndex].getName()) < hour || (minuteDirs = hourDirs[hourIndex].listFiles()) == null) break block24;
                                                            for (int minuteIndex = 0; minuteIndex < minuteDirs.length; ++minuteIndex) {
                                                                try {
                                                                    int minNum = Integer.parseInt(minuteDirs[minuteIndex].getName());
                                                                    if (minNum == minute) {
                                                                        this.deleteIfNeeded(minuteDirs[minuteIndex], second);
                                                                    } else if (minNum > minute) {
                                                                        this.deleteIfNeeded(minuteDirs[minuteIndex], 0.0);
                                                                    }
                                                                }
                                                                catch (NumberFormatException e) {
                                                                    e.printStackTrace();
                                                                }
                                                                this.deleteIfEmpty(minuteDirs[minuteIndex]);
                                                            }
                                                        }
                                                        catch (NumberFormatException e) {
                                                            e.printStackTrace();
                                                        }
                                                    }
                                                    this.deleteIfEmpty(hourDirs[hourIndex]);
                                                }
                                            }
                                            catch (NumberFormatException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                        this.deleteIfEmpty(dayDirs[dayIndex]);
                                    }
                                }
                                catch (NumberFormatException e) {
                                    e.printStackTrace();
                                }
                            }
                            this.deleteIfEmpty(monthDirs[monthIndex]);
                        }
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
                this.deleteIfEmpty(yearDirs[yearIndex]);
            }
        }
    }

    private void deleteIfNeeded(File dir, double second) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                try {
                    double fileSecond = Double.parseDouble(file.getName().substring(0, 6));
                    if (!(fileSecond >= second)) continue;
                    if (file.delete()) {
                        logger.info((Object)("Deleted canceled file: " + file.getPath()));
                        continue;
                    }
                    logger.warn((Object)("Could not delete unused file: " + file.getPath()));
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Unable to parse " + file.getName());
                    e.printStackTrace();
                }
            }
        }
    }

    public void pruneEmptyDirs() {
        File[] yearDirs = this.m_baseDir.listFiles();
        if (yearDirs != null) {
            for (int yearIndex = 0; yearIndex < yearDirs.length; ++yearIndex) {
                File[] monthDirs = yearDirs[yearIndex].listFiles();
                if (monthDirs != null) {
                    for (int monthIndex = 0; monthIndex < monthDirs.length; ++monthIndex) {
                        File[] dayDirs = monthDirs[monthIndex].listFiles();
                        if (dayDirs != null) {
                            for (int dayIndex = 0; dayIndex < dayDirs.length; ++dayIndex) {
                                File[] hourDirs = dayDirs[dayIndex].listFiles();
                                if (hourDirs != null) {
                                    for (int hourIndex = 0; hourIndex < hourDirs.length; ++hourIndex) {
                                        File[] minuteDirs = hourDirs[hourIndex].listFiles();
                                        if (minuteDirs != null) {
                                            for (int minuteIndex = 0; minuteIndex < minuteDirs.length; ++minuteIndex) {
                                                this.deleteIfEmpty(minuteDirs[minuteIndex]);
                                            }
                                        }
                                        this.deleteIfEmpty(hourDirs[hourIndex]);
                                    }
                                }
                                this.deleteIfEmpty(dayDirs[dayIndex]);
                            }
                        }
                        this.deleteIfEmpty(monthDirs[monthIndex]);
                    }
                }
                this.deleteIfEmpty(yearDirs[yearIndex]);
            }
        }
    }

    private void deleteIfEmpty(File dir) {
        if (dir.delete()) {
            logger.info((Object)("Pruned directory " + dir.getPath()));
        }
    }

    public void writeAllPaths(PrintWriter writer) {
        File[] yearDirs = this.m_baseDir.listFiles();
        if (yearDirs != null) {
            for (int yearIndex = 0; yearIndex < yearDirs.length; ++yearIndex) {
                File[] monthDirs = yearDirs[yearIndex].listFiles();
                if (monthDirs == null) continue;
                for (int monthIndex = 0; monthIndex < monthDirs.length; ++monthIndex) {
                    File[] dayDirs = monthDirs[monthIndex].listFiles();
                    if (dayDirs == null) continue;
                    for (int dayIndex = 0; dayIndex < dayDirs.length; ++dayIndex) {
                        File[] hourDirs = dayDirs[dayIndex].listFiles();
                        if (hourDirs == null) continue;
                        for (int hourIndex = 0; hourIndex < hourDirs.length; ++hourIndex) {
                            File[] minuteDirs = hourDirs[hourIndex].listFiles();
                            if (minuteDirs == null) continue;
                            for (int minuteIndex = 0; minuteIndex < minuteDirs.length; ++minuteIndex) {
                                String[] files = minuteDirs[minuteIndex].list();
                                for (int i = 0; i < files.length; ++i) {
                                    String path = yearDirs[yearIndex].getName() + "/" + monthDirs[monthIndex].getName() + "/" + dayDirs[dayIndex].getName() + "/" + hourDirs[hourIndex].getName() + "/" + minuteDirs[minuteIndex].getName() + "/" + files[i];
                                    writer.println(path);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

