/*
 * Decompiled with CFR 0.152.
 */
package proai.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import proai.util.ColumnSpec;
import proai.util.DDLConverter;
import proai.util.TableSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresDDLConverter
implements DDLConverter {
    @Override
    public boolean supportsTableType() {
        return false;
    }

    @Override
    public String getDropDDL(String command) {
        String[] parts = command.split(" ");
        String objectType = parts[1];
        String objectName = parts[2];
        return "DROP " + objectType + " " + objectName;
    }

    @Override
    public List<String> getDDL(TableSpec spec) {
        ArrayList<String> l = new ArrayList<String>();
        StringBuffer out = new StringBuffer();
        StringBuffer end = new StringBuffer();
        out.append("CREATE TABLE " + spec.getName() + " (\n");
        Iterator<ColumnSpec> csi = spec.columnSpecIterator();
        int csNum = 0;
        while (csi.hasNext()) {
            if (csNum > 0) {
                out.append(",\n");
            }
            ++csNum;
            ColumnSpec cs = csi.next();
            out.append("  ");
            out.append(cs.getName());
            out.append(' ');
            if (cs.isAutoIncremented()) {
                out.append(" bigserial");
            } else {
                if (cs.getType().toLowerCase().indexOf("int(") == 0) {
                    out.append("int");
                } else if (cs.getType().toLowerCase().indexOf("smallint(") == 0) {
                    out.append("smallint");
                } else {
                    out.append(cs.getType());
                }
                if (cs.isNotNull()) {
                    out.append(" NOT NULL");
                }
                if (cs.getDefaultValue() != null) {
                    out.append(" DEFAULT ");
                    if (cs.getType().toLowerCase().indexOf("char(") > -1 || cs.getType().toLowerCase().indexOf("text") > -1) {
                        out.append("'");
                    }
                    out.append(cs.getDefaultValue());
                    if (cs.getType().toLowerCase().indexOf("char(") > -1 || cs.getType().toLowerCase().indexOf("text") > -1) {
                        out.append("'");
                    }
                }
            }
            if (cs.isUnique()) {
                if (!end.toString().equals("")) {
                    end.append(",\n");
                }
                end.append("  UNIQUE");
                end.append(" (");
                end.append(cs.getName());
                end.append(")");
            }
            if (cs.getIndexName() != null) {
                l.add("CREATE INDEX " + spec.getName() + "_" + cs.getName() + " ON " + spec.getName() + " (" + cs.getName() + ")");
            }
            if (cs.getForeignTableName() == null) continue;
            if (!end.toString().equals("")) {
                end.append(",\n");
            }
            end.append("  FOREIGN KEY ");
            end.append(cs.getName());
            end.append(" (");
            end.append(cs.getName());
            end.append(") REFERENCES ");
            end.append(cs.getForeignTableName());
            end.append(" (");
            end.append(cs.getForeignColumnName());
            end.append(")");
            if (cs.getOnDeleteAction() == null) continue;
            end.append(" ON DELETE ");
            end.append(cs.getOnDeleteAction());
        }
        if (spec.getPrimaryColumnName() != null) {
            out.append(",\n  PRIMARY KEY (");
            out.append(spec.getPrimaryColumnName());
            out.append(")");
        }
        if (!end.toString().equals("")) {
            out.append(",\n");
            out.append(end);
        }
        out.append("\n");
        out.append(")");
        l.add(0, out.toString());
        return l;
    }
}

