/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bvalid;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import net.sf.bvalid.SchemaLanguage;
import net.sf.bvalid.ValidationException;
import net.sf.bvalid.Validator;
import net.sf.bvalid.ValidatorFactory;
import net.sf.bvalid.ValidatorOption;
import org.apache.log4j.Logger;

public class BValid {
    private static Logger _LOG = Logger.getLogger((String)BValid.class.getName());
    private Options _opts;
    private String _version;
    private String _buildDate;

    public BValid(String[] args) throws ArgException {
        Properties props = new Properties();
        InputStream in = BValid.class.getClassLoader().getResourceAsStream("net/sf/bvalid/BValid.properties");
        try {
            props.load(in);
            this._version = props.getProperty("bvalid.version");
            this._buildDate = props.getProperty("bvalid.buildDate");
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading bvalid.properties");
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        this._opts = new Options(args);
    }

    private String getVersionLine() {
        return "BValid version " + this._version + " (build date: " + this._buildDate + ")";
    }

    private void showVersion() {
        System.out.println(this.getVersionLine());
    }

    private void showUsage() {
        System.out.println("Usage: bvalid [OPTIONS] LANG XMLFILE");
        System.out.println("   Or: bvalid --version");
        System.out.println("   Or: bvalid --help");
        System.out.println("");
        System.out.println("Where:");
        System.out.println("  LANG            a supported schema language, such as xsd");
        System.out.println("  XMLFILE         the path to the instance file to validate");
        System.out.println("");
        System.out.println("Options:");
        System.out.println("  -cf, --cache-files     Cache schema files locally");
        System.out.println("  -co, --cache-objects   Cache parsed grammar objects in memory");
        System.out.println("  -am, --allow-missing   Allow missing referenced schemas.  If the instance");
        System.out.println("                         includes references to schemas that can't be found,");
        System.out.println("                         this will skip them rather than failing validation.");
        System.out.println("  --repeat=n             Repeat the validation n times (for testing)");
        System.out.println("  --schema=file          Use the given schema file (url or filename)");
        System.out.println("  -v, --version          Print version and exit (exclusive option)");
        System.out.println("  -h, --help             Print help and exit (exclusive option)");
        System.out.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        if (this._opts.showVersion()) {
            this.showVersion();
        } else if (this._opts.showUsage()) {
            this.showVersion();
            System.out.println();
            this.showUsage();
        } else {
            Validator validator;
            _LOG.info((Object)this.getVersionLine());
            HashMap<ValidatorOption, String> vopts = new HashMap<ValidatorOption, String>();
            if (this._opts.cacheObjects()) {
                vopts.put(ValidatorOption.CACHE_PARSED_GRAMMARS, "true");
            }
            if (this._opts.allowMissing()) {
                vopts.put(ValidatorOption.FAIL_ON_MISSING_REFERENCED, "false");
            }
            File cacheDir = null;
            if (this._opts.cacheFiles()) {
                cacheDir = File.createTempFile("bvalid-schemaCache", "");
                cacheDir.delete();
                cacheDir.mkdir();
                validator = ValidatorFactory.getValidator(this._opts.getLang(), cacheDir, vopts);
            } else {
                validator = ValidatorFactory.getValidator(this._opts.getLang(), vopts);
            }
            try {
                this.runValidation(validator, this._opts.getXMLFile(), this._opts.getSchema(), this._opts.getRepeat());
            }
            finally {
                if (cacheDir != null && cacheDir.isDirectory()) {
                    try {
                        File[] files = cacheDir.listFiles();
                        for (int i = 0; i < files.length; ++i) {
                            files[i].delete();
                        }
                        cacheDir.delete();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private void runValidation(Validator validator, File xmlFile, String schema, int times) throws Exception {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < times; ++i) {
            long ms;
            long st = System.currentTimeMillis();
            try {
                FileInputStream in = new FileInputStream(xmlFile);
                if (schema != null) {
                    validator.validate(in, schema);
                } else {
                    validator.validate(in);
                }
                ms = System.currentTimeMillis() - st;
                _LOG.info((Object)("Validation of " + xmlFile.getPath() + " succeeded in " + ms + "ms."));
                continue;
            }
            catch (ValidationException e) {
                ms = System.currentTimeMillis() - st;
                if (e.getCause() != null) {
                    _LOG.error((Object)("Validation of " + xmlFile.getPath() + " failed in " + ms + "ms."), e.getCause());
                    continue;
                }
                _LOG.error((Object)("Validation of " + xmlFile.getPath() + " failed in " + ms + "ms.\n" + e.getMessage()));
            }
        }
        long total = System.currentTimeMillis() - startTime;
        long msPerDoc = total / (long)times;
        _LOG.info((Object)("Overall validation rate: " + msPerDoc + "ms/doc"));
    }

    public static void main(String[] args) {
        System.setProperty("org.apache.commons.logging.LogFactory", "org.apache.commons.logging.impl.Log4jFactory");
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Log4JLogger");
        int errorLevel = 1;
        try {
            BValid bvalid = new BValid(args);
            bvalid.run();
            errorLevel = 0;
        }
        catch (ArgException e) {
            System.out.println("bvalid: " + e.getMessage() + " ( -h to show usage )");
        }
        catch (Exception e) {
            _LOG.fatal((Object)"Unexpected error", (Throwable)e);
        }
        System.exit(errorLevel);
    }

    public class ArgException
    extends Exception {
        public ArgException(String message) {
            super(message);
        }
    }

    public class Options {
        private SchemaLanguage _lang;
        private File _xmlFile;
        private boolean _cacheFiles;
        private boolean _cacheObjects;
        private boolean _allowMissing;
        private int _repeat = 1;
        private String _schema;
        private boolean _showVersion;
        private boolean _showUsage;

        public Options(String[] args) throws ArgException {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) {
                    String value;
                    if (args[i].equals("-cf") || args[i].equals("--cache-files")) {
                        this._cacheFiles = true;
                        continue;
                    }
                    if (args[i].equals("-co") || args[i].equals("--cache-objects")) {
                        this._cacheObjects = true;
                        continue;
                    }
                    if (args[i].equals("-am") || args[i].equals("--allow-missing")) {
                        this._allowMissing = true;
                        continue;
                    }
                    if (args[i].startsWith("--repeat=")) {
                        value = args[i].substring(9);
                        try {
                            this._repeat = Integer.parseInt(value);
                            continue;
                        }
                        catch (Exception e) {
                            throw new ArgException("must specify integer value for repeat option");
                        }
                    }
                    if (args[i].startsWith("--schema=")) {
                        value = args[i].substring(9);
                        if (!value.startsWith("/") && value.indexOf(":") != -1) {
                            this._schema = value;
                            continue;
                        }
                        try {
                            this._schema = new File(value).toURI().toString();
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("cannot get URI for local schema file: " + value, e);
                        }
                    }
                    if (args[i].equals("-h") || args[i].equals("--help")) {
                        this._showUsage = true;
                        if (args.length <= 1) continue;
                        throw new ArgException("option is exclusive: " + args[i]);
                    }
                    if (args[i].equals("-v") || args[i].equals("--version")) {
                        this._showVersion = true;
                        if (args.length <= 1) continue;
                        throw new ArgException("option is exclusive: " + args[i]);
                    }
                    throw new ArgException("unrecognized argument: " + args[i]);
                }
                if (this._lang == null) {
                    try {
                        this._lang = SchemaLanguage.forName(args[i]);
                        continue;
                    }
                    catch (Exception e) {
                        throw new ArgException(e.getMessage());
                    }
                }
                if (this._xmlFile == null) {
                    this._xmlFile = new File(args[i]);
                    continue;
                }
                throw new ArgException("Too many arguments");
            }
            if (!this._showVersion && !this._showUsage && this._xmlFile == null) {
                throw new ArgException("Too few arguments");
            }
        }

        public SchemaLanguage getLang() {
            return this._lang;
        }

        public File getXMLFile() {
            return this._xmlFile;
        }

        public boolean cacheFiles() {
            return this._cacheFiles;
        }

        public boolean cacheObjects() {
            return this._cacheObjects;
        }

        public boolean allowMissing() {
            return this._allowMissing;
        }

        public int getRepeat() {
            return this._repeat;
        }

        public String getSchema() {
            return this._schema;
        }

        public boolean showVersion() {
            return this._showVersion;
        }

        public boolean showUsage() {
            return this._showUsage;
        }
    }
}

