/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bvalid;

public class ValidatorOption {
    public static final ValidatorOption FAIL_ON_MISSING_REFERENCED = new ValidatorOption("fail-on-missing-referenced", "Whether validation should fail when a schema referenced within the instance document cannot be found.", new String[]{"true", "false"}, "true");
    public static final ValidatorOption CACHE_PARSED_GRAMMARS = new ValidatorOption("cache-parsed-grammars", "Whether the validator should cache parsed grammars in memory after they have been successfully used to validate an instance document.", new String[]{"true", "false"}, "false");
    private String _name;
    private String _description;
    private String[] _validValues;
    private String _defaultValue;

    protected ValidatorOption(String name, String description, String[] validValues, String defaultValue) {
        this._name = name;
        this._description = description;
        this._validValues = validValues;
        this._defaultValue = defaultValue;
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public String[] getValidValues() {
        return this._validValues;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public boolean isValidValue(String value) {
        if (this._validValues == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        for (int i = 0; i < this._validValues.length; ++i) {
            if (!value.equals(this._validValues[i])) continue;
            return true;
        }
        return false;
    }
}

