/*
 * Decompiled with CFR 0.152.
 */
package org.jrdf.graph.mem;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jrdf.graph.BlankNode;
import org.jrdf.graph.Graph;
import org.jrdf.graph.GraphElementFactory;
import org.jrdf.graph.GraphElementFactoryException;
import org.jrdf.graph.Literal;
import org.jrdf.graph.Node;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.jrdf.graph.TripleFactoryException;
import org.jrdf.graph.URIReference;
import org.jrdf.graph.mem.BlankNodeImpl;
import org.jrdf.graph.mem.GraphImpl;
import org.jrdf.graph.mem.LiteralImpl;
import org.jrdf.graph.mem.MemNode;
import org.jrdf.graph.mem.TripleImpl;
import org.jrdf.graph.mem.URIReferenceImpl;

public class GraphElementFactoryImpl
implements GraphElementFactory {
    private Map nodePool;
    private Map stringPool;
    private Graph graph;
    private long nextNode;

    GraphElementFactoryImpl(GraphImpl graphImpl) throws TripleFactoryException {
        this.graph = graphImpl;
        this.nodePool = new HashMap();
        this.stringPool = new HashMap();
        this.nextNode = 1L;
    }

    public BlankNode createResource() throws GraphElementFactoryException {
        Long l = new Long(this.nextNode);
        BlankNodeImpl blankNodeImpl = new BlankNodeImpl(l);
        this.nodePool.put(l, blankNodeImpl);
        ++this.nextNode;
        return blankNodeImpl;
    }

    public URIReference createResource(URI uRI) throws GraphElementFactoryException {
        if (uRI == null) {
            throw new GraphElementFactoryException("URI may not be null for a URIReference");
        }
        Long l = this.getNodeIdByString(uRI.toString());
        if (l != null) {
            return (URIReference)this.getNodeById(l);
        }
        l = new Long(this.nextNode++);
        URIReferenceImpl uRIReferenceImpl = new URIReferenceImpl(uRI, l);
        this.nodePool.put(l, uRIReferenceImpl);
        this.stringPool.put(uRI.toString(), l);
        return uRIReferenceImpl;
    }

    public URIReference createResource(URI uRI, boolean bl) throws GraphElementFactoryException {
        if (uRI == null) {
            throw new GraphElementFactoryException("URI may not be null for a URIReference");
        }
        Long l = this.getNodeIdByString(uRI.toString());
        if (l != null) {
            return (URIReference)this.getNodeById(l);
        }
        l = new Long(this.nextNode++);
        URIReferenceImpl uRIReferenceImpl = new URIReferenceImpl(uRI, bl, l);
        this.nodePool.put(l, uRIReferenceImpl);
        this.stringPool.put(uRI.toString(), l);
        return uRIReferenceImpl;
    }

    public Literal createLiteral(String string) throws GraphElementFactoryException {
        LiteralImpl literalImpl = new LiteralImpl(string);
        this.addNodeId(literalImpl);
        return literalImpl;
    }

    public Literal createLiteral(String string, String string2) throws GraphElementFactoryException {
        LiteralImpl literalImpl = new LiteralImpl(string, string2);
        this.addNodeId(literalImpl);
        return literalImpl;
    }

    public Literal createLiteral(String string, URI uRI) throws GraphElementFactoryException {
        LiteralImpl literalImpl = new LiteralImpl(string, uRI);
        this.addNodeId(literalImpl);
        return literalImpl;
    }

    private void addNodeId(LiteralImpl literalImpl) throws GraphElementFactoryException {
        String string = literalImpl.getEscapedForm();
        Long l = (Long)this.stringPool.get(string);
        if (l != null) {
            literalImpl.setId(l);
            return;
        }
        Long l2 = new Long(this.nextNode);
        literalImpl.setId(l2);
        this.nodePool.put(l2, literalImpl);
        this.stringPool.put(string, l2);
        ++this.nextNode;
    }

    public Triple createTriple(SubjectNode subjectNode, PredicateNode predicateNode, ObjectNode objectNode) throws GraphElementFactoryException {
        return new TripleImpl(subjectNode, predicateNode, objectNode);
    }

    void registerNode(MemNode memNode) {
        Long l = memNode.getId();
        MemNode memNode2 = (MemNode)this.nodePool.get(l);
        if (memNode2 != null) {
            if (memNode2.equals(memNode)) {
                return;
            }
            throw new IllegalArgumentException("Node conflicts with one already in the graph");
        }
        this.nodePool.put(l, memNode);
        if (!(memNode instanceof BlankNode)) {
            if (memNode instanceof Literal) {
                this.stringPool.put(((Literal)((Object)memNode)).getEscapedForm(), memNode.getId());
            } else {
                this.stringPool.put(memNode.toString(), memNode.getId());
            }
        }
        if (l >= this.nextNode) {
            this.nextNode = l + 1L;
        }
    }

    Collection getNodePool() {
        return this.nodePool.values();
    }

    Node getNodeById(Long l) {
        return (Node)this.nodePool.get(l);
    }

    Long getNodeIdByString(String string) {
        return (Long)this.stringPool.get(string);
    }
}

