/*
 * Decompiled with CFR 0.152.
 */
package org.jrdf.graph.mem;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jrdf.graph.Graph;
import org.jrdf.graph.GraphElementFactory;
import org.jrdf.graph.GraphException;
import org.jrdf.graph.Node;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.jrdf.graph.TripleFactory;
import org.jrdf.graph.TripleFactoryException;
import org.jrdf.graph.mem.BlankNodeImpl;
import org.jrdf.graph.mem.EmptyClosableIterator;
import org.jrdf.graph.mem.GraphElementFactoryImpl;
import org.jrdf.graph.mem.GraphIterator;
import org.jrdf.graph.mem.LiteralImpl;
import org.jrdf.graph.mem.MemNode;
import org.jrdf.graph.mem.OneFixedIterator;
import org.jrdf.graph.mem.ThreeFixedIterator;
import org.jrdf.graph.mem.TripleFactoryImpl;
import org.jrdf.graph.mem.TwoFixedIterator;
import org.jrdf.util.ClosableIterator;

public class GraphImpl
implements Graph,
Serializable {
    protected HashMap index012;
    protected transient HashMap index120;
    protected transient HashMap index201;
    protected transient GraphElementFactoryImpl elementFactory;
    protected transient TripleFactoryImpl tripleFactory;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GraphImpl() throws GraphException {
        this.init();
    }

    private void init() throws GraphException {
        if (this.index012 == null) {
            this.index012 = new HashMap();
        }
        if (this.index120 == null) {
            this.index120 = new HashMap();
        }
        if (this.index201 == null) {
            this.index201 = new HashMap();
        }
        if (this.elementFactory == null) {
            try {
                this.elementFactory = new GraphElementFactoryImpl(this);
            }
            catch (TripleFactoryException tripleFactoryException) {
                throw new GraphException(tripleFactoryException);
            }
        }
        if (this.tripleFactory == null) {
            try {
                this.tripleFactory = new TripleFactoryImpl(this, this.elementFactory);
            }
            catch (TripleFactoryException tripleFactoryException) {
                throw new GraphException(tripleFactoryException);
            }
        }
    }

    public boolean contains(SubjectNode subjectNode, PredicateNode predicateNode, ObjectNode objectNode) throws GraphException {
        Long[] longArray;
        try {
            longArray = this.localize(subjectNode, predicateNode, objectNode);
        }
        catch (GraphException graphException) {
            return false;
        }
        if (subjectNode == null && predicateNode == null && objectNode == null) {
            return this.index012.size() > 0;
        }
        if (subjectNode == null) {
            if (predicateNode == null) {
                Map map = (Map)this.index201.get(longArray[2]);
                return map != null;
            }
            Map map = (Map)this.index120.get(longArray[1]);
            if (map == null) {
                return false;
            }
            if (objectNode == null) {
                return true;
            }
            Collection collection = (Collection)map.get(longArray[2]);
            return collection != null;
        }
        Map map = (Map)this.index012.get(longArray[0]);
        if (map == null) {
            return false;
        }
        if (predicateNode == null) {
            if (objectNode == null) {
                return true;
            }
            Map map2 = (Map)this.index201.get(longArray[2]);
            if (map2 == null) {
                return false;
            }
            Collection collection = (Collection)map2.get(longArray[0]);
            return collection != null;
        }
        Collection collection = (Collection)map.get(longArray[1]);
        if (collection == null) {
            return false;
        }
        if (objectNode != null) {
            return collection.contains(longArray[2]);
        }
        return true;
    }

    public boolean contains(Triple triple) throws GraphException {
        return this.contains(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public ClosableIterator find(SubjectNode subjectNode, PredicateNode predicateNode, ObjectNode objectNode) throws GraphException {
        Long[] longArray;
        try {
            longArray = this.localize(subjectNode, predicateNode, objectNode);
        }
        catch (GraphException graphException) {
            return new EmptyClosableIterator();
        }
        if (subjectNode != null) {
            if (predicateNode != null) {
                if (objectNode != null) {
                    return new ThreeFixedIterator(this, subjectNode, predicateNode, objectNode);
                }
                return new TwoFixedIterator(this.index012, 0, longArray[0], longArray[1], this.elementFactory, this);
            }
            if (objectNode == null) {
                return new OneFixedIterator(this.index012, 0, longArray[0], this.elementFactory, this);
            }
        }
        if (predicateNode != null) {
            if (objectNode != null) {
                return new TwoFixedIterator(this.index120, 2, longArray[1], longArray[2], this.elementFactory, this);
            }
            if (!$assertionsDisabled && subjectNode != null) {
                throw new AssertionError();
            }
            return new OneFixedIterator(this.index120, 2, longArray[1], this.elementFactory, this);
        }
        if (objectNode != null) {
            if (subjectNode != null) {
                return new TwoFixedIterator(this.index201, 1, longArray[2], longArray[0], this.elementFactory, this);
            }
            if (!$assertionsDisabled && predicateNode != null) {
                throw new AssertionError();
            }
            return new OneFixedIterator(this.index201, 1, longArray[2], this.elementFactory, this);
        }
        return new GraphIterator(this.index012, this.elementFactory, this);
    }

    public ClosableIterator find(Triple triple) throws GraphException {
        return this.find(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public void add(SubjectNode subjectNode, PredicateNode predicateNode, ObjectNode objectNode) throws GraphException {
        Long[] longArray = this.localize(subjectNode, predicateNode, objectNode);
        this.add(this.index012, longArray[0], longArray[1], longArray[2]);
        try {
            this.add(this.index120, longArray[1], longArray[2], longArray[0]);
            try {
                this.add(this.index201, longArray[2], longArray[0], longArray[1]);
            }
            catch (GraphException graphException) {
                this.remove(this.index120, longArray[1], longArray[2], longArray[0]);
                throw graphException;
            }
        }
        catch (GraphException graphException) {
            this.remove(this.index012, longArray[0], longArray[1], longArray[2]);
            throw graphException;
        }
    }

    public void add(Triple triple) throws GraphException {
        this.add(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public void add(Iterator iterator) throws GraphException {
        while (iterator.hasNext()) {
            Triple triple = (Triple)iterator.next();
            this.add(triple);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(SubjectNode subjectNode, PredicateNode predicateNode, ObjectNode objectNode) throws GraphException {
        Long[] longArray = this.localize(subjectNode, predicateNode, objectNode);
        this.remove(this.index012, longArray[0], longArray[1], longArray[2]);
        try {
            this.remove(this.index120, longArray[1], longArray[2], longArray[0]);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.remove(this.index201, longArray[2], longArray[0], longArray[1]);
            throw throwable;
        }
        this.remove(this.index201, longArray[2], longArray[0], longArray[1]);
    }

    public void remove(Triple triple) throws GraphException {
        this.remove(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public void remove(Iterator iterator) throws GraphException {
        while (iterator.hasNext()) {
            Triple triple = (Triple)iterator.next();
            this.remove(triple);
        }
    }

    public GraphElementFactory getElementFactory() {
        return this.elementFactory;
    }

    public TripleFactory getTripleFactory() {
        return this.tripleFactory;
    }

    public long getNumberOfTriples() throws GraphException {
        long l = 0L;
        Iterator iterator = this.index012.values().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((Map)iterator.next()).values().iterator();
            while (iterator2.hasNext()) {
                l += (long)((Collection)iterator2.next()).size();
            }
        }
        return l;
    }

    public boolean isEmpty() throws GraphException {
        return this.index012.isEmpty();
    }

    public void close() throws GraphException {
    }

    private Long[] localize(Node node, Node node2, Node node3) throws GraphException {
        Long[] longArray = new Long[3];
        if (node != null) {
            longArray[0] = node instanceof BlankNodeImpl ? ((BlankNodeImpl)node).getId() : this.elementFactory.getNodeIdByString(String.valueOf(node));
            if (longArray[0] == null) {
                throw new GraphException("Subject does not exist in graph");
            }
        }
        if (node2 != null) {
            longArray[1] = this.elementFactory.getNodeIdByString(String.valueOf(node2));
            if (longArray[1] == null) {
                throw new GraphException("Predicate does not exist in graph");
            }
        }
        if (node3 != null) {
            longArray[2] = node3 instanceof BlankNodeImpl ? ((BlankNodeImpl)node3).getId() : (node3 instanceof LiteralImpl ? this.elementFactory.getNodeIdByString(((LiteralImpl)node3).getEscapedForm()) : this.elementFactory.getNodeIdByString(String.valueOf(node3)));
            if (longArray[2] == null) {
                throw new GraphException("Object does not exist in graph");
            }
        }
        return longArray;
    }

    private void add(Map map, Long l, Long l2, Long l3) throws GraphException {
        HashSet<Long> hashSet;
        HashMap<Long, HashSet<Long>> hashMap = (HashMap<Long, HashSet<Long>>)map.get(l);
        if (hashMap == null) {
            hashMap = new HashMap<Long, HashSet<Long>>();
            map.put(l, hashMap);
        }
        if ((hashSet = (HashSet<Long>)hashMap.get(l2)) == null) {
            hashSet = new HashSet<Long>();
            hashMap.put(l2, hashSet);
        }
        hashSet.add(l3);
    }

    protected void remove(Map map, Long l, Long l2, Long l3) throws GraphException {
        Map map2 = (Map)map.get(l);
        if (map2 == null) {
            throw new GraphException("Unable to remove nonexistent statement");
        }
        Collection collection = (Collection)map2.get(l2);
        if (collection == null) {
            throw new GraphException("Unable to remove nonexistent statement");
        }
        if (!collection.remove(l3)) {
            throw new GraphException("Unable to remove nonexistent statement");
        }
        if (collection.isEmpty()) {
            map2.remove(l2);
            if (map2.isEmpty()) {
                map.remove(l);
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.elementFactory.getNodePool().toArray());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.init();
        }
        catch (GraphException graphException) {
            throw new ClassNotFoundException("Unable to initialize a new graph", graphException);
        }
        Object[] objectArray = (Object[])objectInputStream.readObject();
        try {
            if (this.elementFactory == null) {
                this.elementFactory = new GraphElementFactoryImpl(this);
            }
        }
        catch (TripleFactoryException tripleFactoryException) {
            throw new ClassNotFoundException("Unable to build NodeFactory", tripleFactoryException);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.elementFactory.registerNode((MemNode)objectArray[i]);
        }
        try {
            Iterator iterator = this.index012.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Long l = (Long)entry.getKey();
                Iterator iterator2 = ((Map)entry.getValue()).entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry2 = iterator2.next();
                    Long l2 = (Long)entry2.getKey();
                    Iterator iterator3 = ((Set)entry2.getValue()).iterator();
                    while (iterator3.hasNext()) {
                        Long l3 = (Long)iterator3.next();
                        this.add(this.index120, l2, l3, l);
                        this.add(this.index201, l3, l, l2);
                    }
                }
            }
        }
        catch (GraphException graphException) {
            throw new ClassNotFoundException("Unable to add to a graph index", graphException);
        }
    }

    static void dumpIndex(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Long l = (Long)entry.getKey();
            int n = l.toString().length() + 5;
            System.out.print(l.toString() + " --> ");
            Map map2 = (Map)entry.getValue();
            if (map2.isEmpty()) {
                System.out.println("X");
                continue;
            }
            boolean bl = true;
            Iterator iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                int n2;
                Object object;
                Map.Entry entry2 = iterator2.next();
                Long l2 = (Long)entry2.getKey();
                int n3 = l2.toString().length() + 5;
                if (!bl) {
                    object = new StringBuffer(n);
                    ((StringBuffer)object).setLength(n);
                    for (n2 = 0; n2 < n; ++n2) {
                        ((StringBuffer)object).setCharAt(n2, ' ');
                    }
                    System.out.print(((StringBuffer)object).toString());
                } else {
                    bl = false;
                }
                System.out.print(l2.toString() + " --> ");
                object = (Set)entry2.getValue();
                if (object.isEmpty()) {
                    System.out.println("X");
                    continue;
                }
                n2 = 1;
                Iterator iterator3 = object.iterator();
                while (iterator3.hasNext()) {
                    Long l3 = (Long)iterator3.next();
                    if (n2 == 0) {
                        StringBuffer stringBuffer = new StringBuffer(n + n3);
                        stringBuffer.setLength(n + n3);
                        for (int i = 0; i < n + n3; ++i) {
                            stringBuffer.setCharAt(i, ' ');
                        }
                        System.out.print(stringBuffer.toString());
                    } else {
                        n2 = 0;
                    }
                    System.out.println(l3);
                }
            }
        }
    }

    static {
        $assertionsDisabled = !GraphImpl.class.desiredAssertionStatus();
    }
}

