/*
 * Decompiled with CFR 0.152.
 */
package org.jrdf.graph.mem;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jrdf.graph.AbstractGraphUnitTest;
import org.jrdf.graph.Graph;
import org.jrdf.graph.Literal;
import org.jrdf.graph.URIReference;
import org.jrdf.graph.mem.GraphImpl;

public class GraphImplUnitTest
extends AbstractGraphUnitTest {
    public GraphImplUnitTest(String string) {
        super(string);
    }

    public Graph newGraph() throws Exception {
        return new GraphImpl();
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new GraphImplUnitTest("testEmpty"));
        testSuite.addTest((Test)new GraphImplUnitTest("testFactory"));
        testSuite.addTest((Test)new GraphImplUnitTest("testAddition"));
        testSuite.addTest((Test)new GraphImplUnitTest("testRemoval"));
        testSuite.addTest((Test)new GraphImplUnitTest("testContains"));
        testSuite.addTest((Test)new GraphImplUnitTest("testFinding"));
        testSuite.addTest((Test)new GraphImplUnitTest("testIteration"));
        testSuite.addTest((Test)new GraphImplUnitTest("testIterativeRemoval"));
        testSuite.addTest((Test)new GraphImplUnitTest("testFullIterativeRemoval"));
        testSuite.addTest((Test)new GraphImplUnitTest("testSerializing"));
        return testSuite;
    }

    public static void main(String[] stringArray) throws Exception {
        TestRunner.run((Test)GraphImplUnitTest.suite());
    }

    public void testSerializing() throws Exception {
        this.graph.add(blank1, ref1, blank2);
        this.graph.add(blank1, ref2, blank2);
        this.graph.add(blank1, ref1, l1);
        this.graph.add(blank1, ref1, l2);
        this.graph.add(blank2, ref1, blank2);
        this.graph.add(blank2, ref2, blank2);
        this.graph.add(blank2, ref1, l1);
        this.graph.add(blank2, ref1, l2);
        this.graph.add(blank2, ref1, l2);
        this.graph.add(ref1, ref1, ref1);
        GraphImplUnitTest.assertEquals((long)9L, (long)this.graph.getNumberOfTriples());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.graph);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Graph graph = (Graph)objectInputStream.readObject();
        URIReference uRIReference = graph.getElementFactory().createResource(ref1.getURI());
        Literal literal = graph.getElementFactory().createLiteral(l1.getLexicalForm());
        GraphImplUnitTest.assertEquals((long)this.graph.getNumberOfTriples(), (long)graph.getNumberOfTriples());
        GraphImplUnitTest.assertTrue((boolean)graph.contains(blank1, ref1, blank2));
        GraphImplUnitTest.assertTrue((boolean)graph.contains(blank1, ref2, blank2));
        GraphImplUnitTest.assertTrue((boolean)graph.contains(blank1, ref1, l1));
        GraphImplUnitTest.assertTrue((boolean)graph.contains(blank1, ref1, l2));
        GraphImplUnitTest.assertTrue((boolean)graph.contains(blank2, ref1, blank2));
        GraphImplUnitTest.assertTrue((boolean)graph.contains(blank2, ref2, blank2));
        GraphImplUnitTest.assertTrue((boolean)graph.contains(blank2, ref1, l1));
        GraphImplUnitTest.assertTrue((boolean)graph.contains(blank2, uRIReference, l2));
        GraphImplUnitTest.assertTrue((boolean)graph.contains(blank1, uRIReference, literal));
        GraphImplUnitTest.assertTrue((boolean)graph.contains(ref1, ref1, ref1));
        GraphImplUnitTest.assertTrue((boolean)graph.contains(null, ref1, null));
        GraphImplUnitTest.assertTrue((boolean)graph.contains(uRIReference, uRIReference, uRIReference));
        GraphImplUnitTest.assertTrue((boolean)graph.contains(null, uRIReference, null));
        GraphImplUnitTest.assertTrue((boolean)graph.contains(null, uRIReference, literal));
    }
}

