/*
 * Decompiled with CFR 0.152.
 */
package org.jrdf.graph.mem;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jrdf.graph.GraphException;
import org.jrdf.graph.mem.GraphElementFactoryImpl;
import org.jrdf.graph.mem.GraphImpl;
import org.jrdf.graph.mem.TripleImpl;
import org.jrdf.util.ClosableIterator;

public class OneFixedIterator
implements ClosableIterator {
    private Iterator subIterator;
    private Iterator itemIterator;
    private Map.Entry secondEntry;
    private GraphElementFactoryImpl nodeFactory;
    private GraphImpl graph;
    private Map index;
    private Map subIndex;
    private Long first;
    private int var;
    private Long[] currentNodes;
    static final /* synthetic */ boolean $assertionsDisabled;

    OneFixedIterator(Map map, int n, Long l, GraphElementFactoryImpl graphElementFactoryImpl, GraphImpl graphImpl) {
        this.nodeFactory = graphElementFactoryImpl;
        this.graph = graphImpl;
        this.first = l;
        this.var = n;
        this.index = map;
        this.currentNodes = null;
        this.itemIterator = null;
        this.subIterator = null;
        this.subIndex = (Map)map.get(this.first);
        if (this.subIndex != null) {
            this.subIterator = this.subIndex.entrySet().iterator();
            if (!$assertionsDisabled && !this.subIterator.hasNext()) {
                throw new AssertionError();
            }
        }
    }

    public boolean hasNext() {
        return this.itemIterator != null && this.itemIterator.hasNext() || this.subIterator != null && this.subIterator.hasNext();
    }

    public Object next() throws NoSuchElementException {
        if (this.subIterator == null) {
            throw new NoSuchElementException();
        }
        this.updatePosition();
        if (this.subIterator == null) {
            throw new NoSuchElementException();
        }
        Long l = (Long)this.itemIterator.next();
        Long l2 = (Long)this.secondEntry.getKey();
        this.currentNodes = new Long[]{this.first, l2, l};
        return new TripleImpl(this.nodeFactory, this.var, this.first, l2, l);
    }

    private void updatePosition() {
        if (this.itemIterator == null || !this.itemIterator.hasNext()) {
            if (!this.subIterator.hasNext()) {
                this.subIterator = null;
                return;
            }
            this.secondEntry = (Map.Entry)this.subIterator.next();
            this.itemIterator = ((Set)this.secondEntry.getValue()).iterator();
            if (!$assertionsDisabled && !this.itemIterator.hasNext()) {
                throw new AssertionError();
            }
        }
    }

    public void remove() {
        if (this.itemIterator == null) {
            throw new IllegalStateException("Beyond end of data");
        }
        this.itemIterator.remove();
        this.cleanIndex();
        this.removeFromNonCurrentIndex();
    }

    private void cleanIndex() {
        Set set = (Set)this.secondEntry.getValue();
        if (set.isEmpty()) {
            this.subIterator.remove();
            if (this.subIndex.isEmpty()) {
                this.index.remove(this.first);
                this.subIndex = null;
            }
        }
    }

    private void removeFromNonCurrentIndex() {
        try {
            if (this.index == this.graph.index012) {
                this.graph.remove(this.graph.index120, this.currentNodes[1], this.currentNodes[2], this.currentNodes[0]);
                this.graph.remove(this.graph.index201, this.currentNodes[2], this.currentNodes[0], this.currentNodes[1]);
            }
            if (this.index == this.graph.index120) {
                this.graph.remove(this.graph.index012, this.currentNodes[2], this.currentNodes[0], this.currentNodes[1]);
                this.graph.remove(this.graph.index201, this.currentNodes[1], this.currentNodes[2], this.currentNodes[0]);
            }
            if (this.index == this.graph.index201) {
                this.graph.remove(this.graph.index012, this.currentNodes[1], this.currentNodes[2], this.currentNodes[0]);
                this.graph.remove(this.graph.index120, this.currentNodes[2], this.currentNodes[0], this.currentNodes[1]);
            }
        }
        catch (GraphException graphException) {
            throw new IllegalStateException(graphException.getMessage());
        }
    }

    public boolean close() {
        return true;
    }

    static {
        $assertionsDisabled = !OneFixedIterator.class.desiredAssertionStatus();
    }
}

