/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bvalid;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sf.bvalid.SchemaLanguage;
import net.sf.bvalid.Validator;
import net.sf.bvalid.ValidatorException;
import net.sf.bvalid.ValidatorOption;
import net.sf.bvalid.catalog.DiskSchemaCatalog;
import net.sf.bvalid.catalog.FileSchemaIndex;
import net.sf.bvalid.catalog.MemorySchemaCatalog;
import net.sf.bvalid.locator.CachingSchemaLocator;
import net.sf.bvalid.locator.SchemaLocator;
import net.sf.bvalid.locator.URLSchemaLocator;
import net.sf.bvalid.xsd.XercesXSDValidator;

public abstract class ValidatorFactory {
    public static Validator getValidator(SchemaLanguage lang, Map validatorOptions) throws ValidatorException {
        return ValidatorFactory.getValidator(lang, new URLSchemaLocator(), validatorOptions);
    }

    public static Validator getValidator(SchemaLanguage lang, File cacheDir, Map options) throws ValidatorException {
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
            if (!cacheDir.exists()) {
                throw new ValidatorException("Unable to create schema cache directory: " + cacheDir.getPath());
            }
        }
        File indexFile = new File(cacheDir, "index.dat");
        FileSchemaIndex index = new FileSchemaIndex(indexFile);
        DiskSchemaCatalog catalog = new DiskSchemaCatalog(index, cacheDir);
        CachingSchemaLocator locator = new CachingSchemaLocator(new MemorySchemaCatalog(), catalog, new URLSchemaLocator());
        return ValidatorFactory.getValidator(lang, locator, options);
    }

    public static Validator getValidator(SchemaLanguage lang, SchemaLocator locator, Map options) throws ValidatorException {
        if (options == null) {
            options = new HashMap();
        }
        boolean failOnMissingReferenced = ValidatorFactory.getBoolean(options, ValidatorOption.FAIL_ON_MISSING_REFERENCED);
        boolean cacheParsedGrammars = ValidatorFactory.getBoolean(options, ValidatorOption.CACHE_PARSED_GRAMMARS);
        if (lang == SchemaLanguage.XSD) {
            return new XercesXSDValidator(locator, failOnMissingReferenced, cacheParsedGrammars);
        }
        throw new ValidatorException("Unrecognized schema language: " + lang.toString());
    }

    private static boolean getBoolean(Map options, ValidatorOption option) throws ValidatorException {
        return ValidatorFactory.getBoolean((String)options.get(option), option.getDefaultValue());
    }

    private static boolean getBoolean(String value, String defaultValue) throws ValidatorException {
        if (value == null) {
            value = defaultValue;
        }
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new ValidatorException("Unrecognized boolean value: '" + value + "', expected 'true' or 'false'");
    }
}

