/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bvalid.catalog;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.sf.bvalid.ValidatorException;
import net.sf.bvalid.catalog.SchemaCatalog;

public class MemorySchemaCatalog
implements SchemaCatalog {
    private Map _map = new HashMap();

    public synchronized Iterator listURIs() {
        return new HashSet(this._map.keySet()).iterator();
    }

    public synchronized boolean contains(String uri) {
        return this._map.containsKey(uri);
    }

    public synchronized InputStream get(String uri) {
        byte[] bytes = (byte[])this._map.get(uri);
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public synchronized void put(String uri, InputStream in) throws ValidatorException {
        try {
            int len;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            byte[] bytes = out.toByteArray();
            this._map.put(uri, bytes);
        }
        catch (Throwable th) {
            throw new ValidatorException("Error reading schema inputstream", th);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
    }

    public synchronized void remove(String uri) {
        this._map.remove(uri);
    }
}

